/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.config;

import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationUtil.class);

    private ConfigurationUtil() {
    }

    public static List<PackageConfig> buildParentsFromString(Configuration configuration, String parent) {
        List<String> parentPackageNames = ConfigurationUtil.buildParentListFromString(parent);
        ArrayList<PackageConfig> parentPackageConfigs = new ArrayList<PackageConfig>();
        for (String parentPackageName : parentPackageNames) {
            PackageConfig parentPackageContext = configuration.getPackageConfig(parentPackageName);
            if (parentPackageContext == null) continue;
            parentPackageConfigs.add(parentPackageContext);
        }
        return parentPackageConfigs;
    }

    public static List<String> buildParentListFromString(String parent) {
        if (parent == null || "".equals(parent)) {
            return Collections.emptyList();
        }
        StringTokenizer tokenizer = new StringTokenizer(parent, ",");
        ArrayList<String> parents = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String parentName = tokenizer.nextToken().trim();
            if ("".equals(parentName)) continue;
            parents.add(parentName);
        }
        return parents;
    }
}

