/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CardinalityHelper {
    static final Pattern PATTERN_OPTIONAL = Pattern.compile("\\[.*\\]");
    static final Pattern PATTERN_MANDATORY = Pattern.compile("\\<.*\\>");
    public static final Pattern PATTERN_NO_MAX_BOUND = Pattern.compile("(.*)(\\+|\\*)");
    public static final Pattern PATTERN_EXTACLY = Pattern.compile("(.*)\\{([0-9]+)\\}");
    public static final Pattern PATTERN_BOUNDED = Pattern.compile("(.*)\\{([0-9]+),([0-9]+|\\*)\\}");

    public static boolean isDefaultMandatory(int min, int max) {
        return min == 1 && max == 1;
    }

    public static boolean isDefaultOptional(int min, int max) {
        return min == 0 && max == 1;
    }

    public static boolean isMandatory(int min) {
        return min > 0;
    }

    public static boolean isMaxBounded(int max) {
        return max != -1;
    }

    public static boolean isRepetable(int max) {
        return !CardinalityHelper.isMaxBounded(max) || max > 1;
    }

    public static boolean isAvailable(int current, int max) {
        return !CardinalityHelper.isMaxBounded(max) || current < max;
    }

    public static int getDefaultMin(boolean mandatory) {
        return mandatory ? 1 : 0;
    }

    public static Object[] parseCardinalite(String txt, boolean mandatory) {
        Object[] result = new Object[3];
        Matcher matcher = PATTERN_NO_MAX_BOUND.matcher(txt = txt.trim());
        if (matcher.matches()) {
            result[0] = matcher.group(1).trim();
            result[1] = CardinalityHelper.getDefaultMin(matcher.group(2).equals("+"));
            result[2] = -1;
        } else {
            matcher = PATTERN_EXTACLY.matcher(txt);
            if (matcher.matches()) {
                result[0] = matcher.group(1).trim();
                result[1] = Integer.valueOf(matcher.group(2));
                result[2] = result[1];
            } else {
                matcher = PATTERN_BOUNDED.matcher(txt);
                if (matcher.matches()) {
                    result[0] = matcher.group(1).trim();
                    result[1] = Integer.valueOf(matcher.group(2));
                    String max = matcher.group(3);
                    result[2] = max.equals("*") ? -1 : Integer.valueOf(max);
                } else {
                    result[0] = txt.trim();
                    result[1] = CardinalityHelper.getDefaultMin(mandatory);
                    result[2] = 1;
                }
            }
        }
        return result;
    }

    public static void printCardinalite(StringBuilder sb, String txt, int min, int max, boolean mandatory, String mo, String mc, String oo, String oc) {
        boolean print = false;
        boolean maxBounded = CardinalityHelper.isMaxBounded(max);
        if (CardinalityHelper.isMandatory(min)) {
            sb.append(mo).append(txt).append(mc);
            if (CardinalityHelper.isDefaultMandatory(min, max)) {
                if (!mandatory && mo.length() <= 0) {
                    print = true;
                }
            } else if (!maxBounded && min == 1) {
                sb.append('+');
            } else {
                print = true;
            }
        } else {
            sb.append(oo).append(txt).append(oc);
            if (CardinalityHelper.isDefaultOptional(min, max)) {
                if (mandatory && oo.length() <= 0) {
                    print = true;
                }
            } else if (!maxBounded) {
                sb.append('*');
            } else {
                print = true;
            }
        }
        if (print) {
            sb.append('{');
            sb.append(min);
            if (max != min) {
                sb.append(',');
                sb.append(maxBounded ? Integer.valueOf(max) : "*");
            }
            sb.append('}');
        }
    }

    protected CardinalityHelper() {
    }
}

