package com.franciaflex.faxtomail.ui.swing.content.reply;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.Stamp;
import org.jdesktop.beans.AbstractSerializableBean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author Kevin Morin (Code Lutin)
 * @since 1.4
 */
public class SigningSettingsUIModel extends AbstractSerializableBean {

    public static final String PROPERTY_SIGNINGS = "signings";
    public static final String PROPERTY_SELECTED_SIGNING = "selectedSigning";
    public static final String PROPERTY_SELECTED_SIGNING_NAME = "selectedSigningName";
    public static final String PROPERTY_SELECTED_SIGNING_TEXT = "selectedSigningText";
    public static final String PROPERTY_SELECTED_SIGNING_DEFAULT = "selectedSigningDefault";
    public static final String PROPERTY_SET_DEFAULT_BUTTON_ENABLED = "setDefaultButtonEnabled";
    public static final String PROPERTY_MODIFIED = "modified";


    protected List<Stamp> signings = new ArrayList<>();
    protected Stamp selectedSigning;
    protected String selectedSigningName;
    protected String selectedSigningText;
    protected boolean selectedSigningDefault;
    protected boolean modified;

    public Stamp getSelectedSigning() {
        return selectedSigning;
    }

    public void setSelectedSigning(Stamp selectedSigning) {
        Object oldValue = getSelectedSigning();
        this.selectedSigning = selectedSigning;
        firePropertyChange(PROPERTY_SELECTED_SIGNING, oldValue, selectedSigning);

        setSelectedSigningName(selectedSigning != null ? selectedSigning.getLabel() : "");
        setSelectedSigningText(selectedSigning != null ? selectedSigning.getText() : "");

        setModified(false);
        updateSetDefaultButtonEnabled();
    }

    public List<Stamp> getSignings() {
        return signings;
    }

    public void setSignings(Collection<Stamp> signings) {
        this.signings.clear();
        if (signings != null) {
            this.signings.addAll(signings);
        }
        firePropertyChange(PROPERTY_SIGNINGS, null, this.signings);
    }

    public void addSigning(Stamp signing) {
        this.signings.add(signing);
        firePropertyChange(PROPERTY_SIGNINGS, null, this.signings);
    }

    public void removeSigning(Stamp signing) {
        this.signings.remove(signing);
        firePropertyChange(PROPERTY_SIGNINGS, null, this.signings);
    }

    public String getSelectedSigningName() {
        return selectedSigningName;
    }

    public void setSelectedSigningName(String selectedSigningName) {
        Object oldValue = getSelectedSigningName();
        this.selectedSigningName = selectedSigningName;
        firePropertyChange(PROPERTY_SELECTED_SIGNING_NAME, oldValue, selectedSigningName);
        setModified(true);
    }

    public String getSelectedSigningText() {
        return selectedSigningText;
    }

    public void setSelectedSigningText(String selectedSigningText) {
        Object oldValue = getSelectedSigningText();
        this.selectedSigningText = selectedSigningText;
        firePropertyChange(PROPERTY_SELECTED_SIGNING_TEXT, oldValue, selectedSigningText);
        setModified(true);
    }

    public boolean isSelectedSigningDefault() {
        return selectedSigningDefault;
    }

    public void setSelectedSigningDefault(boolean selectedSigningDefault) {
        Object oldValue = isSelectedSigningDefault();
        this.selectedSigningDefault = selectedSigningDefault;
        firePropertyChange(PROPERTY_SELECTED_SIGNING_DEFAULT, oldValue, selectedSigningDefault);
        updateSetDefaultButtonEnabled();
    }

    public boolean isSetDefaultButtonEnabled() {
        return selectedSigning != null
                && selectedSigning.isPersisted()
                && !selectedSigningDefault;
    }

    public void updateSetDefaultButtonEnabled() {
        firePropertyChange(PROPERTY_SET_DEFAULT_BUTTON_ENABLED, null, isSetDefaultButtonEnabled());
    }

    public boolean isModified() {
        return modified;
    }

    public void setModified(boolean modified) {
        Object oldValue = isModified();
        this.modified = modified;
        firePropertyChange(PROPERTY_MODIFIED, oldValue, modified);
    }

    public void resetSelectedSigning() {
        setSelectedSigningName(selectedSigning.getLabel());
        setSelectedSigningText(selectedSigning.getText());
        setModified(false);
    }
}
