package com.franciaflex.faxtomail.ui.swing.content.demande.history;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.History;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.JAXXUtil.getStringValue;
import static org.nuiton.i18n.I18n.t;

public class HistoryItem extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DATE_TEXT = "date.text";
    public static final String BINDING_FIELDS_TEXT = "fields.text";
    public static final String BINDING_TYPE_TEXT = "type.text";
    public static final String BINDING_USER_TEXT = "user.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1VQW8bRRSebGOnTgKURoRWFGmBSywla9oeQKSCkhQrKQ6tmgZV+MLs7jieanZnOjvbrBWBkOAH8BPgzgWJGyfEgTMHLoi/gBAHroj3Zje7cbJWHBUrmtjz3vvem/fm++a7P0kj0eS1xzTLPJ3GhkfMu/v+o0f3/McsMHdYEmiujNQk/8w4xOmThbDcTwx5o9/D8E4R3tmUkZIxi49Fr/fIfGJGgiVDxowhr45HBEnS2S3N65lK9RFqWVQd6jd//+V8HX7xrUNIpqC6BTiKe1ZUdZLZHnF4aMhlyPSUdgSN96EMzeN9qPc53NsUNEk+ohF7Qj4ncz3SVFQDmCGvT39ki2HjM2XIpSFPwDraNiy6T2MmDOkGMvIGmsYBpwPBMm9AMyMjyoWXci85gHq8QMYG4L2QRTQOmVegeFsVmlI2S9OQRiRDBP7w/wHeQbQKfW4IjoJpQ+49O34P/u1tb+WIVY7ZkBoKg8EZZAXSXdsudGiVfi3wYz3q42nHne0mel0eA7WDfHl8v2VGipX+J4yzaKwLShOmJwahsWa/OeBMhElpgYNo8srYhQUqeBUVqrs60ycNncK2IVf6p9nzAEw5b66c4A0CWuu/y0u//fjHD90jsixC7pdqXY9xHS6x0lLBtDmmfiFnSmq46OxQtd4nrYQJEAorBNdqCtstzFAc5HsRwz0M97ZoMgSIxtzvP/28/OmvF4jTJfNC0rBL0X8bxjLU0AUpwky9d9tWtHhwEdZLWBvUEtGMR2n0QB5syhRJ6dx4M4MOXKvpQFmG3/rln6Xd728fdcGBqq5OdK860fiENHkseMysaBR6UCsSCyphaSgr3tcpAQEtWN5gNO5yYZimPphl5MsNmRU0uIkui+hywtC261pdT5q+1CFSs3PobtiveTdHXqAZ3P4PImVGuWHlxqp7c9XFte1+lqWIeR1RiuQ1UqWmKEAq+iSFi9sYUJGwOljL7bOgHGQey2CoVytRAbmJZOzBn8gpPz8AdVmzvYXU3FDBg7qUlUxMn/f6oVsIHWhXIDUgrFhd9faZAUnkAx5Qw2V8By1t6KEhC7aeA8b3h4Aw6+PdndABNn0lM++c46Sllk2P/9ahiy/+HrISzpa/gB9TkR478EOAXWnjNwt+zvNiUc8ycX907omX8jzFpS3yvn164nuAUjWhS7OHcgfqstvtVdfolE0gj30Cps+9djp3174Vx7Lnv9sTEhZvyzQcFXQkU0j6/C2kouvzOISJv3sKdQbX+TMRcftLXL6qR1gChP8ATxaUD2gKAAA=";
    private static final Log log = LogFactory.getLog(HistoryItem.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel data;
    protected JLabel date;
    protected JLabel dateLabel;
    protected JLabel fields;
    protected HistoryListUIHandler handler;
    protected HistoryItem historyItemPanel = this;
    protected HistoryItemModel model;
    protected JLabel type;
    protected JLabel typeLabel;
    protected JLabel user;
    protected JLabel userLabel;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public HistoryItem(HistoryListUIHandler handler) {
        setContextValue(handler);
            $initialize();
    }

    public HistoryItem(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public HistoryItem(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public HistoryItem(boolean param0) {
        super(param0);
        $initialize();
    }

    public HistoryItem(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public HistoryItem() {
        $initialize();
    }

    public HistoryItem(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public HistoryItem(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public HistoryItem(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getData() {
        return data;
    }

    public JLabel getDate() {
        return date;
    }

    public JLabel getDateLabel() {
        return dateLabel;
    }

    public JLabel getFields() {
        return fields;
    }

    public HistoryListUIHandler getHandler() {
        return handler;
    }

    public HistoryItemModel getModel() {
        return model;
    }

    public JLabel getType() {
        return type;
    }

    public JLabel getTypeLabel() {
        return typeLabel;
    }

    public JLabel getUser() {
        return user;
    }

    public JLabel getUserLabel() {
        return userLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToData() {
        if (!allComponentsCreated) {
            return;
        }
        data.add(dateLabel);
        data.add(date);
        data.add(typeLabel);
        data.add(type);
        data.add(userLabel);
        data.add(user);
    }

    protected void addChildrenToHistoryItemPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(data);
        add(fields);
    }

    protected void createData() {
        $objectMap.put("data", data = new JPanel());
        
        data.setName("data");
        data.setLayout(new FlowLayout(FlowLayout.LEADING));
        data.setOpaque(false);
    }

    protected void createDate() {
        $objectMap.put("date", date = new JLabel());
        
        date.setName("date");
        if (date.getFont() != null) {
            date.setFont(date.getFont().deriveFont(date.getFont().getStyle() | Font.BOLD));
        }
    }

    protected void createDateLabel() {
        $objectMap.put("dateLabel", dateLabel = new JLabel());
        
        dateLabel.setName("dateLabel");
        dateLabel.setText(t("faxtomail.common.on.label"));
        if (dateLabel.getFont() != null) {
            dateLabel.setFont(dateLabel.getFont().deriveFont(dateLabel.getFont().getStyle() | Font.ITALIC));
        }
    }

    protected void createFields() {
        $objectMap.put("fields", fields = new JLabel());
        
        fields.setName("fields");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(HistoryListUIHandler.class));
    }

    protected void createModel() {
        $objectMap.put("model", model = new HistoryItemModel());
    }

    protected void createType() {
        $objectMap.put("type", type = new JLabel());
        
        type.setName("type");
        if (type.getFont() != null) {
            type.setFont(type.getFont().deriveFont(type.getFont().getStyle() | Font.BOLD));
        }
    }

    protected void createTypeLabel() {
        $objectMap.put("typeLabel", typeLabel = new JLabel());
        
        typeLabel.setName("typeLabel");
        typeLabel.setText(t(":"));
        if (typeLabel.getFont() != null) {
            typeLabel.setFont(typeLabel.getFont().deriveFont(typeLabel.getFont().getStyle() | Font.ITALIC));
        }
    }

    protected void createUser() {
        $objectMap.put("user", user = new JLabel());
        
        user.setName("user");
    }

    protected void createUserLabel() {
        $objectMap.put("userLabel", userLabel = new JLabel());
        
        userLabel.setName("userLabel");
        userLabel.setText(t("faxtomail.common.by.label"));
        if (userLabel.getFont() != null) {
            userLabel.setFont(userLabel.getFont().deriveFont(userLabel.getFont().getStyle() | Font.ITALIC));
        }
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHistoryItemPanel();
        addChildrenToData();
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        setBorder( BorderFactory.createEmptyBorder(2, 3, 2, 3) );
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("historyItemPanel", historyItemPanel);
        createModel();
        createHandler();
        createData();
        createDateLabel();
        createDate();
        createTypeLabel();
        createType();
        createUserLabel();
        createUser();
        createFields();
        // inline creation of historyItemPanel
        setName("historyItemPanel");
        setLayout(new GridLayout(0,1));
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DATE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modificationDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    date.setText(t( handler.decorate(model.getModificationDate()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modificationDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TYPE_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("type", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getType() != null) {
                    type.setText(t( JAXXUtil.getStringValue(model.getType().getLabel()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("type", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_USER_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("faxToMailUser", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    user.setText(t( handler.decorateUser(model.getFaxToMailUser(), true) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("faxToMailUser", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIELDS_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("fields", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    fields.setText(t( handler.decorateFields(model.getFields()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("fields", this);
                }
            }
        });
    }

}