/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.pdfparser.PDFStreamParser;

class DefaultAppearanceHandler {
    private List<Object> appearanceTokens;

    DefaultAppearanceHandler(String defaultApperanceString) throws IOException {
        this.appearanceTokens = this.getStreamTokens(defaultApperanceString);
    }

    float getFontSize() {
        int fontIndex;
        if (!this.appearanceTokens.isEmpty() && (fontIndex = this.appearanceTokens.indexOf(Operator.getOperator("Tf"))) != -1) {
            return ((COSNumber)this.appearanceTokens.get(fontIndex - 1)).floatValue();
        }
        return 0.0f;
    }

    void setFontSize(float fontSize) {
        int fontIndex = this.appearanceTokens.indexOf(Operator.getOperator("Tf"));
        if (fontIndex != -1) {
            this.appearanceTokens.set(fontIndex - 1, new COSFloat(fontSize));
        }
    }

    COSName getFontName() {
        int setFontOperatorIndex = this.appearanceTokens.indexOf(Operator.getOperator("Tf"));
        return (COSName)this.appearanceTokens.get(setFontOperatorIndex - 2);
    }

    List<Object> getTokens() {
        return this.appearanceTokens;
    }

    private List<Object> getStreamTokens(String defaultAppearanceString) throws IOException {
        List<Object> tokens = new ArrayList<Object>();
        if (defaultAppearanceString != null && !defaultAppearanceString.isEmpty()) {
            PDFStreamParser parser = null;
            ByteArrayInputStream stream = new ByteArrayInputStream(defaultAppearanceString.getBytes());
            parser = new PDFStreamParser(stream);
            parser.parse();
            tokens = parser.getTokens();
            parser.close();
        }
        return tokens;
    }
}

