/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.Vector;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.ICOSVisitor;
import org.apache.pdfbox.pdmodel.common.PDStream;

public class COSStreamArray
extends COSStream {
    private COSArray streams;
    private COSStream firstStream;

    public COSStreamArray(COSArray array) {
        super(new COSDictionary());
        this.streams = array;
        if (array.size() > 0) {
            this.firstStream = (COSStream)array.getObject(0);
        }
    }

    public COSBase get(int index) {
        return this.streams.get(index);
    }

    public int getStreamCount() {
        return this.streams.size();
    }

    @Override
    public COSBase getItem(COSName key) {
        return this.firstStream.getItem(key);
    }

    @Override
    public COSBase getDictionaryObject(COSName key) {
        return this.firstStream.getDictionaryObject(key);
    }

    @Override
    public String toString() {
        return "COSStream{}";
    }

    public COSDictionary getDictionary() {
        return this.firstStream;
    }

    @Override
    public InputStream getFilteredStream() throws IOException {
        throw new IOException("Error: Not allowed to get filtered stream from array of streams.");
    }

    @Override
    public InputStream getUnfilteredStream() throws IOException {
        Vector<InputStream> inputStreams = new Vector<InputStream>();
        byte[] inbetweenStreamBytes = "\n".getBytes("ISO-8859-1");
        for (int i = 0; i < this.streams.size(); ++i) {
            COSStream stream = (COSStream)this.streams.getObject(i);
            inputStreams.add(stream.getUnfilteredStream());
            inputStreams.add(new ByteArrayInputStream(inbetweenStreamBytes));
        }
        return new SequenceInputStream(inputStreams.elements());
    }

    @Override
    public Object accept(ICOSVisitor visitor) throws IOException {
        return this.streams.accept(visitor);
    }

    @Override
    public COSBase getFilters() {
        return this.firstStream.getFilters();
    }

    @Override
    public OutputStream createFilteredStream() throws IOException {
        return this.firstStream.createFilteredStream();
    }

    @Override
    public OutputStream createFilteredStream(COSBase expectedLength) throws IOException {
        return this.firstStream.createFilteredStream(expectedLength);
    }

    @Override
    public void setFilters(COSBase filters) throws IOException {
        this.firstStream.setFilters(filters);
    }

    @Override
    public OutputStream createUnfilteredStream() throws IOException {
        return this.firstStream.createUnfilteredStream();
    }

    public void appendStream(COSStream streamToAppend) {
        this.streams.add(streamToAppend);
    }

    public void insertCOSStream(PDStream streamToBeInserted) {
        COSArray tmp = new COSArray();
        tmp.add(streamToBeInserted);
        tmp.addAll(this.streams);
        this.streams.clear();
        this.streams = tmp;
    }
}

