/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDChoice;
import org.apache.pdfbox.pdmodel.interactive.form.PDFieldTreeNode;

public final class PDComboBox
extends PDChoice {
    private static final int FLAG_EDIT = 262144;

    public PDComboBox(PDAcroForm theAcroForm) {
        super(theAcroForm);
        this.setCombo(true);
    }

    public PDComboBox(PDAcroForm acroForm, COSDictionary field, PDFieldTreeNode parentNode) {
        super(acroForm, field, parentNode);
    }

    public boolean isEdit() {
        return this.getCOSObject().getFlag(COSName.FF, 262144);
    }

    public void setEdit(boolean edit) {
        this.getCOSObject().setFlag(COSName.FF, 262144, edit);
    }

    @Override
    public void setValue(String value) {
        if (value != null) {
            if (!this.isEdit() && this.getOptions().indexOf(value) == -1) {
                throw new IllegalArgumentException("The list box does not contain the given value.");
            }
            this.getCOSObject().setString(COSName.V, value);
            this.setSelectedOptionsIndex(null);
        } else {
            this.getCOSObject().removeItem(COSName.V);
        }
    }
}

