/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.actions;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.services.service.EmailService;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyAttachmentModel;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUI;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUIModel;

public class AddAttachmentToReplyAction
extends AbstractFaxToMailAction<ReplyFormUIModel, ReplyFormUI, ReplyFormUIHandler> {
    protected ReplyAttachmentModel replyAttachmentModel;

    public AddAttachmentToReplyAction(ReplyFormUIHandler handler) {
        super(handler, false);
        this.setActionDescription("faxtomail.action.addAttachmentToReply.tip");
    }

    public ReplyAttachmentModel getReplyAttachmentModel() {
        return this.replyAttachmentModel;
    }

    public void setReplyAttachmentModel(ReplyAttachmentModel replyAttachmentModel) {
        this.replyAttachmentModel = replyAttachmentModel;
    }

    @Override
    public void doAction() throws Exception {
        Attachment attachment = this.replyAttachmentModel.getAttachment();
        if (this.replyAttachmentModel.getAttachmentFile() == null && attachment.isPersisted()) {
            EmailService service = this.getContext().newServiceContext().getEmailService();
            boolean original = this.replyAttachmentModel.isOriginal();
            AttachmentFile file = service.getAttachmentFile(attachment.getTopiaId(), original);
            if (original) {
                attachment.setOriginalFile(file);
            } else {
                attachment.setEditedFile(file);
            }
        }
    }
}

