/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.command;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.FlywayCallback;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.info.MigrationInfoImpl;
import org.flywaydb.core.internal.info.MigrationInfoServiceImpl;
import org.flywaydb.core.internal.metadatatable.AppliedMigration;
import org.flywaydb.core.internal.metadatatable.MetaDataTable;
import org.flywaydb.core.internal.util.ObjectUtils;
import org.flywaydb.core.internal.util.jdbc.TransactionCallback;
import org.flywaydb.core.internal.util.jdbc.TransactionTemplate;

public class DbRepair {
    private final Connection connection;
    private final MigrationInfoServiceImpl migrationInfoService;
    private final MetaDataTable metaDataTable;
    private final FlywayCallback[] callbacks;

    public DbRepair(Connection connection, MigrationResolver migrationResolver, MetaDataTable metaDataTable, FlywayCallback[] callbacks) {
        this.connection = connection;
        this.migrationInfoService = new MigrationInfoServiceImpl(migrationResolver, metaDataTable, MigrationVersion.LATEST, true, true);
        this.metaDataTable = metaDataTable;
        this.callbacks = callbacks;
    }

    public void repair() {
        for (final FlywayCallback callback : this.callbacks) {
            new TransactionTemplate(this.connection).execute(new TransactionCallback<Object>(){

                @Override
                public Object doInTransaction() throws SQLException {
                    callback.beforeRepair(DbRepair.this.connection);
                    return null;
                }
            });
        }
        new TransactionTemplate(this.connection).execute(new TransactionCallback<Void>(){

            @Override
            public Void doInTransaction() {
                DbRepair.this.metaDataTable.removeFailedMigrations();
                DbRepair.this.migrationInfoService.refresh();
                for (MigrationInfo migrationInfo : DbRepair.this.migrationInfoService.all()) {
                    MigrationInfoImpl migrationInfoImpl = (MigrationInfoImpl)migrationInfo;
                    ResolvedMigration resolved = migrationInfoImpl.getResolvedMigration();
                    AppliedMigration applied = migrationInfoImpl.getAppliedMigration();
                    if (resolved == null || applied == null || ObjectUtils.nullSafeEquals(resolved.getChecksum(), applied.getChecksum())) continue;
                    DbRepair.this.metaDataTable.updateChecksum(migrationInfoImpl.getVersion(), resolved.getChecksum());
                }
                return null;
            }
        });
        for (final FlywayCallback callback : this.callbacks) {
            new TransactionTemplate(this.connection).execute(new TransactionCallback<Object>(){

                @Override
                public Object doInTransaction() throws SQLException {
                    callback.afterRepair(DbRepair.this.connection);
                    return null;
                }
            });
        }
    }
}

