/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdfparser.PDFStreamParser;
import org.apache.pdfbox.pdfwriter.ContentStreamWriter;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.interactive.action.PDFormFieldAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceEntry;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.form.AppearanceStyle;
import org.apache.pdfbox.pdmodel.interactive.form.DefaultAppearanceHandler;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDTextField;
import org.apache.pdfbox.pdmodel.interactive.form.PDVariableText;
import org.apache.pdfbox.pdmodel.interactive.form.PlainText;
import org.apache.pdfbox.pdmodel.interactive.form.PlainTextFormatter;

class AppearanceGeneratorHelper {
    private static final Log LOG = LogFactory.getLog(AppearanceGeneratorHelper.class);
    private static final float GLYPH_TO_PDF_SCALE = 1000.0f;
    private final PDVariableText parent;
    private String value;
    private final DefaultAppearanceHandler defaultAppearanceHandler;
    private final PDAcroForm acroForm;
    private List<COSObjectable> widgets = new ArrayList<COSObjectable>();

    public AppearanceGeneratorHelper(PDAcroForm acroForm, PDVariableText field) throws IOException {
        this.acroForm = acroForm;
        this.parent = field;
        this.widgets = field.getKids();
        if (this.widgets == null) {
            this.widgets = new ArrayList<COSObjectable>();
            this.widgets.add(field.getWidget());
        }
        this.defaultAppearanceHandler = new DefaultAppearanceHandler(this.getDefaultAppearance());
    }

    private String getDefaultAppearance() {
        return this.parent.getDefaultAppearance();
    }

    private List<Object> getStreamTokens(PDAppearanceStream appearanceStream) throws IOException {
        List<Object> tokens = new ArrayList<Object>();
        if (appearanceStream != null) {
            tokens = this.getStreamTokens(appearanceStream.getCOSStream());
        }
        return tokens;
    }

    private List<Object> getStreamTokens(COSStream stream) throws IOException {
        List<Object> tokens = new ArrayList<Object>();
        if (stream != null) {
            PDFStreamParser parser = new PDFStreamParser(stream);
            parser.parse();
            tokens = parser.getTokens();
            parser.close();
        }
        return tokens;
    }

    private boolean containsMarkedContent(List<Object> streamTokens) {
        return streamTokens.contains(Operator.getOperator("BMC"));
    }

    public void setAppearanceValue(String apValue) throws IOException {
        this.value = apValue;
        for (COSObjectable next : this.widgets) {
            PDAppearanceEntry normalAppearance;
            PDAppearanceStream appearanceStream;
            PDAnnotationWidget widget;
            PDField field = null;
            if (next instanceof PDField) {
                field = (PDField)next;
                widget = field.getWidget();
            } else {
                widget = (PDAnnotationWidget)next;
            }
            PDFormFieldAdditionalActions actions = null;
            if (field != null) {
                actions = field.getActions();
            }
            if (actions != null && actions.getF() != null && widget.getDictionary().getDictionaryObject(COSName.AP) == null) continue;
            PDAppearanceDictionary appearance = widget.getAppearance();
            if (appearance == null) {
                appearance = new PDAppearanceDictionary();
                widget.setAppearance(appearance);
            }
            PDAppearanceStream pDAppearanceStream = appearanceStream = (normalAppearance = appearance.getNormalAppearance()).isStream() ? normalAppearance.getAppearanceStream() : null;
            if (appearanceStream == null) {
                COSStream cosStream = this.acroForm.getDocument().getDocument().createCOSStream();
                appearanceStream = new PDAppearanceStream(cosStream);
                appearanceStream.setBBox(widget.getRectangle().createRetranslatedRectangle());
                appearance.setNormalAppearance(appearanceStream);
            }
            List<Object> tokens = this.getStreamTokens(appearanceStream);
            PDFont pdFont = this.getFontAndUpdateResources(appearanceStream);
            if (!this.containsMarkedContent(tokens)) {
                this.createAppearanceContent(tokens, widget, pdFont, appearanceStream);
                continue;
            }
            this.updateAppearanceContent(tokens, widget, pdFont, appearanceStream);
        }
    }

    private void createAppearanceContent(List<Object> tokens, PDAnnotationWidget widget, PDFont pdFont, PDAppearanceStream appearanceStream) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ContentStreamWriter writer = new ContentStreamWriter(output);
        writer.writeTokens(tokens);
        output.write("/Tx BMC\n".getBytes("ISO-8859-1"));
        PDRectangle boundingBox = this.resolveBoundingBox(widget, appearanceStream);
        this.insertGeneratedAppearance(boundingBox, output, pdFont, tokens, appearanceStream);
        output.write("EMC".getBytes("ISO-8859-1"));
        output.close();
        this.writeToStream(output.toByteArray(), appearanceStream);
    }

    private void updateAppearanceContent(List<Object> tokens, PDAnnotationWidget widget, PDFont pdFont, PDAppearanceStream appearanceStream) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ContentStreamWriter writer = new ContentStreamWriter(output);
        PDRectangle boundingBox = this.resolveBoundingBox(widget, appearanceStream);
        int bmcIndex = tokens.indexOf(Operator.getOperator("BMC"));
        int emcIndex = tokens.indexOf(Operator.getOperator("EMC"));
        writer.writeTokens(tokens, 0, bmcIndex + 1);
        output.write("\n".getBytes("ISO-8859-1"));
        this.insertGeneratedAppearance(boundingBox, output, pdFont, tokens, appearanceStream);
        if (emcIndex != -1) {
            writer.writeTokens(tokens, emcIndex, tokens.size());
        }
        output.close();
        this.writeToStream(output.toByteArray(), appearanceStream);
    }

    private void insertGeneratedAppearance(PDRectangle boundingBox, OutputStream output, PDFont font, List<Object> tokens, PDAppearanceStream appearanceStream) throws IOException {
        PDPageContentStream contents = new PDPageContentStream(this.acroForm.getDocument(), appearanceStream, output);
        float lineWidth = this.getLineWidth(tokens);
        PDRectangle paddingEdge = this.applyPadding(boundingBox, Math.max(1.0f, lineWidth));
        PDRectangle contentEdge = this.applyPadding(paddingEdge, Math.max(1.0f, lineWidth));
        contents.saveGraphicsState();
        contents.addRect(paddingEdge.getLowerLeftX(), paddingEdge.getLowerLeftY(), paddingEdge.getWidth(), paddingEdge.getHeight());
        contents.clip();
        contents.beginText();
        float fontSize = this.calculateFontSize(font, contentEdge);
        if (!this.defaultAppearanceHandler.getTokens().isEmpty()) {
            this.defaultAppearanceHandler.setFontSize(fontSize);
            ContentStreamWriter daWriter = new ContentStreamWriter(output);
            contents.setFont(font, fontSize);
            daWriter.writeTokens(this.defaultAppearanceHandler.getTokens().subList(this.defaultAppearanceHandler.getTokens().indexOf(Operator.getOperator("Tf")) + 1, this.defaultAppearanceHandler.getTokens().size()));
        }
        float verticalOffset = this.calculateVerticalOffset(paddingEdge, contentEdge, font, fontSize);
        float leftOffset = 0.0f;
        if (!this.isMultiLine()) {
            leftOffset = this.calculateHorizontalOffset(contentEdge, font, fontSize);
            contents.newLineAtOffset(leftOffset, verticalOffset);
            contents.showText(this.value);
        } else {
            leftOffset = contentEdge.getLowerLeftX();
            PlainText textContent = new PlainText(this.value);
            AppearanceStyle appearanceStyle = new AppearanceStyle();
            appearanceStyle.setFont(font);
            appearanceStyle.setFontSize(fontSize);
            appearanceStyle.setLeading(font.getBoundingBox().getHeight() / 1000.0f * fontSize);
            PlainTextFormatter formatter = new PlainTextFormatter.Builder(contents).style(appearanceStyle).text(textContent).width(contentEdge.getWidth()).wrapLines(true).initialOffset(leftOffset, verticalOffset).textAlign(this.parent.getQ()).build();
            formatter.format();
        }
        contents.endText();
        contents.restoreGraphicsState();
        contents.close();
    }

    private PDFont getFontAndUpdateResources(PDAppearanceStream appearanceStream) throws IOException {
        PDFont font;
        PDResources streamResources = appearanceStream.getResources();
        PDResources formResources = this.acroForm.getDefaultResources();
        if (streamResources == null && formResources == null) {
            throw new IOException("Unable to generate field appearance - missing required resources");
        }
        COSName cosFontName = this.defaultAppearanceHandler.getFontName();
        if (streamResources != null) {
            font = streamResources.getFont(cosFontName);
            if (font != null) {
                return font;
            }
        } else {
            streamResources = new PDResources();
            appearanceStream.setResources(streamResources);
        }
        if (formResources != null && (font = formResources.getFont(cosFontName)) != null) {
            streamResources.put(cosFontName, font);
            return font;
        }
        font = this.resolveFont(streamResources, formResources, cosFontName);
        if (font != null) {
            streamResources.put(cosFontName, font);
            return font;
        }
        throw new IOException("Unable to generate field appearance - missing required font resources: " + cosFontName);
    }

    private PDFont resolveFont(PDResources streamResources, PDResources formResources, COSName cosFontName) throws IOException {
        PDFont font;
        if (streamResources != null) {
            for (COSName fontName : streamResources.getFontNames()) {
                font = streamResources.getFont(fontName);
                if (!font.getName().equals(cosFontName.getName())) continue;
                return font;
            }
        }
        if (formResources != null) {
            for (COSName fontName : formResources.getFontNames()) {
                font = formResources.getFont(fontName);
                if (!font.getName().equals(cosFontName.getName())) continue;
                return font;
            }
        }
        return null;
    }

    private boolean isMultiLine() {
        return this.parent instanceof PDTextField && ((PDTextField)this.parent).isMultiline();
    }

    private void writeToStream(byte[] data, PDAppearanceStream appearanceStream) throws IOException {
        OutputStream out = appearanceStream.getCOSStream().createUnfilteredStream();
        out.write(data);
        out.flush();
    }

    private float getLineWidth(List<Object> tokens) {
        float retval = 0.0f;
        if (tokens != null) {
            int btIndex = tokens.indexOf(Operator.getOperator("BT"));
            int wIndex = tokens.indexOf(Operator.getOperator("w"));
            if (wIndex > 0 && (wIndex < btIndex || btIndex == -1)) {
                retval = ((COSNumber)tokens.get(wIndex - 1)).floatValue();
            }
        }
        return retval;
    }

    private float calculateFontSize(PDFont pdFont, PDRectangle contentEdge) throws IOException {
        float fontSize = 12.0f;
        if (!this.defaultAppearanceHandler.getTokens().isEmpty()) {
            fontSize = this.defaultAppearanceHandler.getFontSize();
        }
        if (fontSize == 0.0f && !this.isMultiLine()) {
            float widthAtFontSize1 = pdFont.getStringWidth(this.value) / 1000.0f;
            float widthBasedFontSize = contentEdge.getWidth() / widthAtFontSize1;
            float height = pdFont.getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f;
            fontSize = Math.min(contentEdge.getHeight() / height, widthBasedFontSize);
        }
        if (fontSize == 0.0f) {
            fontSize = 12.0f;
        }
        return fontSize;
    }

    private float calculateVerticalOffset(PDRectangle paddingEdge, PDRectangle contentEdge, PDFont pdFont, float fontSize) throws IOException {
        float capHeight = this.getCapHeight(pdFont, fontSize);
        float fontHeight = pdFont.getBoundingBox().getHeight() / 1000.0f * fontSize;
        float verticalOffset = this.parent instanceof PDTextField && ((PDTextField)this.parent).isMultiline() ? contentEdge.getUpperRightY() - fontHeight : (capHeight > paddingEdge.getHeight() ? paddingEdge.getLowerLeftX() - pdFont.getFontDescriptor().getDescent() / 1000.0f * fontSize : (paddingEdge.getHeight() - capHeight) / 2.0f + paddingEdge.getLowerLeftX());
        return verticalOffset;
    }

    private float calculateHorizontalOffset(PDRectangle contentEdge, PDFont pdFont, float fontSize) throws IOException {
        float stringWidth = pdFont.getStringWidth(this.value) / 1000.0f * fontSize;
        float leftOffset = 0.0f;
        int q = this.parent.getQ();
        if (q == 0 || stringWidth > contentEdge.getWidth()) {
            leftOffset = contentEdge.getLowerLeftX();
        } else if (q == 1) {
            leftOffset = contentEdge.getLowerLeftX() + (contentEdge.getWidth() - stringWidth) / 2.0f;
        } else if (q == 2) {
            leftOffset = contentEdge.getLowerLeftX() + contentEdge.getWidth() - stringWidth;
        } else {
            leftOffset = contentEdge.getLowerLeftX();
            LOG.debug((Object)("Unknown justification value, defaulting to left: " + q));
        }
        return leftOffset;
    }

    private float getCapHeight(PDFont pdFont, float fontSize) throws IOException {
        PDFontDescriptor fontDescriptor = pdFont.getFontDescriptor();
        if (fontDescriptor == null || fontDescriptor.getCapHeight() == 0.0f) {
            return pdFont.getBoundingBox().getHeight() / 1000.0f * fontSize * 0.7f;
        }
        return pdFont.getFontDescriptor().getCapHeight() / 1000.0f * fontSize;
    }

    private PDRectangle resolveBoundingBox(PDAnnotationWidget fieldWidget, PDAppearanceStream appearanceStream) {
        PDRectangle boundingBox = appearanceStream.getBBox();
        if (boundingBox == null) {
            boundingBox = fieldWidget.getRectangle().createRetranslatedRectangle();
        }
        return boundingBox;
    }

    private PDRectangle applyPadding(PDRectangle box, float padding) {
        return new PDRectangle(box.getLowerLeftX() + padding, box.getLowerLeftY() + padding, box.getWidth() - 2.0f * padding, box.getHeight() - 2.0f * padding);
    }
}

