/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import org.apache.fontbox.ttf.HorizontalHeaderTable;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;

public class HorizontalMetricsTable
extends TTFTable {
    public static final String TAG = "hmtx";
    private int[] advanceWidth;
    private short[] leftSideBearing;
    private short[] nonHorizontalLeftSideBearing;
    private int numHMetrics;

    @Override
    public void read(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        HorizontalHeaderTable hHeader = ttf.getHorizontalHeader();
        this.numHMetrics = hHeader.getNumberOfHMetrics();
        int numGlyphs = ttf.getNumberOfGlyphs();
        int bytesRead = 0;
        this.advanceWidth = new int[this.numHMetrics];
        this.leftSideBearing = new short[this.numHMetrics];
        for (int i = 0; i < this.numHMetrics; ++i) {
            this.advanceWidth[i] = data.readUnsignedShort();
            this.leftSideBearing[i] = data.readSignedShort();
            bytesRead += 4;
        }
        if ((long)bytesRead < this.getLength()) {
            int numberNonHorizontal = numGlyphs - this.numHMetrics;
            if (numberNonHorizontal < 0) {
                numberNonHorizontal = numGlyphs;
            }
            this.nonHorizontalLeftSideBearing = new short[numberNonHorizontal];
            for (int i = 0; i < numberNonHorizontal; ++i) {
                if ((long)bytesRead >= this.getLength()) continue;
                this.nonHorizontalLeftSideBearing[i] = data.readSignedShort();
                bytesRead += 2;
            }
        }
        this.initialized = true;
    }

    public int getAdvanceWidth(int gid) {
        if (gid < this.numHMetrics) {
            return this.advanceWidth[gid];
        }
        return this.advanceWidth[this.advanceWidth.length - 1];
    }
}

