/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.pdfbox.pdfwriter.COSWriter;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.util.Charsets;

class AppearancePrimitivesComposer {
    private final OutputStream outputstream;
    private final NumberFormat formatDecimal = NumberFormat.getNumberInstance(Locale.US);
    private boolean inTextMode = false;

    AppearancePrimitivesComposer(OutputStream outputstream) {
        this.outputstream = outputstream;
    }

    public void addRect(PDRectangle rect) throws IOException {
        this.addRect(rect.getLowerLeftX(), rect.getLowerLeftY(), rect.getWidth(), rect.getHeight());
    }

    public void addRect(float x, float y, float width, float height) throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: addRect is not allowed within a text block.");
        }
        this.writeOperand(x);
        this.writeOperand(y);
        this.writeOperand(width);
        this.writeOperand(height);
        this.writeOperator("re");
    }

    public void beginText() throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: Nested beginText() calls are not allowed.");
        }
        this.writeOperator("BT");
        this.inTextMode = true;
    }

    public void clip() throws IOException {
        if (this.inTextMode) {
            throw new IOException("Error: clip is not allowed within a text block.");
        }
        this.writeOperator("W");
        this.writeOperator("n");
    }

    public void endText() throws IOException {
        if (!this.inTextMode) {
            throw new IOException("Error: You must call beginText() before calling endText.");
        }
        this.writeOperator("ET");
        this.inTextMode = false;
    }

    void newLineAtOffset(float tx, float ty) throws IOException {
        this.writeOperand(tx);
        this.writeOperand(ty);
        this.writeOperator("Td");
    }

    void showText(String text, PDFont font) throws IOException {
        COSWriter.writeString(font.encode(text), this.outputstream);
        this.write(" ");
        this.writeOperator("Tj");
    }

    private void write(String text) throws IOException {
        this.outputstream.write(text.getBytes(Charsets.US_ASCII));
    }

    private void writeOperator(String text) throws IOException {
        this.outputstream.write(text.getBytes(Charsets.US_ASCII));
        this.outputstream.write(10);
    }

    private void writeOperand(float real) throws IOException {
        this.write(this.formatDecimal.format(real));
        this.outputstream.write(32);
    }
}

