/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.graphics.shading.CoonsPatch;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType6;
import org.apache.pdfbox.pdmodel.graphics.shading.Patch;
import org.apache.pdfbox.pdmodel.graphics.shading.PatchMeshesShadingContext;
import org.apache.pdfbox.util.Matrix;

class Type6ShadingContext
extends PatchMeshesShadingContext {
    Type6ShadingContext(PDShadingType6 shading, ColorModel colorModel, AffineTransform xform, Matrix matrix, Rectangle dBounds) throws IOException {
        super(shading, colorModel, xform, matrix, dBounds);
        this.patchList = this.getCoonsPatchList(xform, matrix);
        this.createPixelTable();
    }

    private List<Patch> getCoonsPatchList(AffineTransform xform, Matrix matrix) throws IOException {
        PDShadingType6 coonsShadingType = (PDShadingType6)this.patchMeshesShadingType;
        COSDictionary dict = coonsShadingType.getCOSObject();
        PDRange rangeX = coonsShadingType.getDecodeForParameter(0);
        PDRange rangeY = coonsShadingType.getDecodeForParameter(1);
        PDRange[] colRange = new PDRange[this.numberOfColorComponents];
        for (int i = 0; i < this.numberOfColorComponents; ++i) {
            colRange[i] = coonsShadingType.getDecodeForParameter(2 + i);
        }
        return this.getPatchList(xform, matrix, dict, rangeX, rangeY, colRange, 12);
    }

    @Override
    protected Patch generatePatch(Point2D[] points, float[][] color) {
        return new CoonsPatch(points, color);
    }
}

