/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.cff.CFFCIDFont;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CFFParser;
import org.apache.fontbox.cff.CFFType1Font;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.ttf.Type1Equivalent;
import org.apache.fontbox.type1.Type1Font;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.font.FileSystemFontProvider;
import org.apache.pdfbox.pdmodel.font.FontProvider;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;

public final class ExternalFonts {
    private static final Log log = LogFactory.getLog(ExternalFonts.class);
    private static FontProvider fontProvider;
    private static final TrueTypeFont ttfFallbackFont;
    private static final CFFCIDFont cidFallbackFont;
    private static final Map<String, List<String>> substitutes;

    private ExternalFonts() {
    }

    public static void setProvider(FontProvider fontProvider) {
        ExternalFonts.fontProvider = fontProvider;
    }

    public static FontProvider getProvider() {
        if (fontProvider == null) {
            fontProvider = DefaultFontProvider.INSTANCE;
        }
        return fontProvider;
    }

    private static List<String> copySubstitutes(String postScriptName) {
        return new ArrayList<String>((Collection)substitutes.get(postScriptName));
    }

    public static void addSubstitute(String match, String replace) {
        if (!substitutes.containsKey(match)) {
            substitutes.put(match, new ArrayList());
        }
        substitutes.get(match).add(replace);
    }

    private static List<String> getSubstitutes(String postScriptName) {
        List<String> subs = substitutes.get(postScriptName.replaceAll(" ", ""));
        if (subs != null) {
            return subs;
        }
        return Collections.emptyList();
    }

    private static String windowsToPs(String windowsName) {
        return windowsName.replaceAll(",", "-");
    }

    public static CFFCIDFont getCFFCIDFontFallback(String registryOrdering, PDFontDescriptor fontDescriptor) {
        if (registryOrdering != null) {
            for (String substituteName : ExternalFonts.getSubstitutes("$" + registryOrdering)) {
                CFFFont cff = ExternalFonts.getProvider().getCFFFont(substituteName);
                if (!(cff instanceof CFFCIDFont)) continue;
                return (CFFCIDFont)cff;
            }
        }
        return cidFallbackFont;
    }

    public static Type1Equivalent getType1FallbackFont(PDFontDescriptor fontDescriptor) {
        String fontName = ExternalFonts.getFallbackFontName(fontDescriptor);
        Type1Equivalent type1Equivalent = ExternalFonts.getType1EquivalentFont(fontName);
        if (type1Equivalent == null) {
            log.error((Object)("No fallback font for '" + fontName + "'"));
            return ttfFallbackFont;
        }
        return type1Equivalent;
    }

    public static TrueTypeFont getTrueTypeFallbackFont(PDFontDescriptor fontDescriptor) {
        String fontName = ExternalFonts.getFallbackFontName(fontDescriptor);
        TrueTypeFont ttf = ExternalFonts.getTrueTypeFont(fontName);
        if (ttf == null) {
            log.error((Object)("No TTF fallback font for '" + fontName + "'"));
            return ttfFallbackFont;
        }
        return ttf;
    }

    private static String getFallbackFontName(PDFontDescriptor fontDescriptor) {
        String fontName;
        if (fontDescriptor != null) {
            boolean isBold = false;
            String name = fontDescriptor.getFontName();
            if (name != null) {
                String lower = fontDescriptor.getFontName().toLowerCase();
                boolean bl = isBold = lower.contains("bold") || lower.contains("black") || lower.contains("heavy");
            }
            if (fontDescriptor.isFixedPitch()) {
                fontName = "Courier";
                if (isBold && fontDescriptor.isItalic()) {
                    fontName = fontName + "-BoldOblique";
                } else if (isBold) {
                    fontName = fontName + "-Bold";
                } else if (fontDescriptor.isItalic()) {
                    fontName = fontName + "-Oblique";
                }
            } else if (fontDescriptor.isSerif()) {
                fontName = "Times";
                fontName = isBold && fontDescriptor.isItalic() ? fontName + "-BoldItalic" : (isBold ? fontName + "-Bold" : (fontDescriptor.isItalic() ? fontName + "-Italic" : fontName + "-Roman"));
            } else {
                fontName = "Helvetica";
                if (isBold && fontDescriptor.isItalic()) {
                    fontName = fontName + "-BoldOblique";
                } else if (isBold) {
                    fontName = fontName + "-Bold";
                } else if (fontDescriptor.isItalic()) {
                    fontName = fontName + "-Oblique";
                }
            }
        } else {
            fontName = "Times-Roman";
        }
        return fontName;
    }

    public static TrueTypeFont getTrueTypeFont(String postScriptName) {
        TrueTypeFont ttf = ExternalFonts.getProvider().getTrueTypeFont(postScriptName);
        if (ttf == null) {
            for (String substituteName : ExternalFonts.getSubstitutes(postScriptName)) {
                ttf = ExternalFonts.getProvider().getTrueTypeFont(substituteName);
                if (ttf == null) continue;
                return ttf;
            }
            ttf = ExternalFonts.getProvider().getTrueTypeFont(ExternalFonts.windowsToPs(postScriptName));
        }
        return ttf;
    }

    public static Type1Font getType1Font(String postScriptName) {
        Type1Font t1 = ExternalFonts.getProvider().getType1Font(postScriptName);
        if (t1 == null) {
            for (String substituteName : ExternalFonts.getSubstitutes(postScriptName)) {
                t1 = ExternalFonts.getProvider().getType1Font(substituteName);
                if (t1 == null) continue;
                return t1;
            }
            t1 = ExternalFonts.getProvider().getType1Font(ExternalFonts.windowsToPs(postScriptName));
        }
        return t1;
    }

    public static CFFType1Font getCFFType1Font(String postScriptName) {
        CFFFont cff = ExternalFonts.getCFFFont(postScriptName);
        if (cff instanceof CFFType1Font) {
            return (CFFType1Font)cff;
        }
        return null;
    }

    public static CFFCIDFont getCFFCIDFont(String postScriptName) {
        CFFFont cff = ExternalFonts.getCFFFont(postScriptName);
        if (cff instanceof CFFCIDFont) {
            return (CFFCIDFont)cff;
        }
        return null;
    }

    private static CFFFont getCFFFont(String postScriptName) {
        CFFFont cff = ExternalFonts.getProvider().getCFFFont(postScriptName);
        if (cff == null) {
            for (String substituteName : ExternalFonts.getSubstitutes(postScriptName)) {
                cff = ExternalFonts.getProvider().getCFFFont(substituteName);
                if (cff == null) continue;
                return cff;
            }
            cff = ExternalFonts.getProvider().getCFFFont(ExternalFonts.windowsToPs(postScriptName));
        }
        return cff;
    }

    public static Type1Equivalent getType1EquivalentFont(String postScriptName) {
        Type1Font t1 = ExternalFonts.getType1Font(postScriptName);
        if (t1 != null) {
            return t1;
        }
        CFFType1Font cff = ExternalFonts.getCFFType1Font(postScriptName);
        if (cff != null) {
            return cff;
        }
        TrueTypeFont ttf = ExternalFonts.getTrueTypeFont(postScriptName);
        if (ttf != null) {
            return ttf;
        }
        return null;
    }

    static {
        try {
            String ttfName = "org/apache/pdfbox/resources/ttf/LiberationSans-Regular.ttf";
            URL url = ExternalFonts.class.getClassLoader().getResource(ttfName);
            if (url == null) {
                throw new IOException("Error loading resource: " + ttfName);
            }
            InputStream ttfStream = url.openStream();
            TTFParser ttfParser = new TTFParser();
            ttfFallbackFont = ttfParser.parse(ttfStream);
            String cffName = "org/apache/pdfbox/resources/otf/AdobeBlank.otf";
            url = ExternalFonts.class.getClassLoader().getResource(cffName);
            if (url == null) {
                throw new IOException("Error loading resource: " + ttfName);
            }
            InputStream cffStream = url.openStream();
            byte[] bytes = IOUtils.toByteArray(cffStream);
            CFFParser cffParser = new CFFParser();
            cidFallbackFont = (CFFCIDFont)cffParser.parse(bytes).get(0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        substitutes = new HashMap<String, List<String>>();
        substitutes.put("Courier", Arrays.asList("CourierNew", "CourierNewPSMT", "LiberationMono", "NimbusMonL-Regu"));
        substitutes.put("Courier-Bold", Arrays.asList("CourierNewPS-BoldMT", "CourierNew-Bold", "LiberationMono-Bold", "NimbusMonL-Bold"));
        substitutes.put("Courier-Oblique", Arrays.asList("CourierNewPS-ItalicMT", "CourierNew-Italic", "LiberationMono-Italic", "NimbusMonL-ReguObli"));
        substitutes.put("Courier-BoldOblique", Arrays.asList("CourierNewPS-BoldItalicMT", "CourierNew-BoldItalic", "LiberationMono-BoldItalic", "NimbusMonL-BoldObli"));
        substitutes.put("Helvetica", Arrays.asList("ArialMT", "Arial", "LiberationSans", "NimbusSanL-Regu"));
        substitutes.put("Helvetica-Bold", Arrays.asList("Arial-BoldMT", "Arial-Bold", "LiberationSans-Bold", "NimbusSanL-Bold"));
        substitutes.put("Helvetica-Oblique", Arrays.asList("Arial-ItalicMT", "Arial-Italic", "Helvetica-Italic", "LiberationSans-Italic", "NimbusSanL-ReguItal"));
        substitutes.put("Helvetica-BoldOblique", Arrays.asList("Arial-BoldItalicMT", "Helvetica-BoldItalic", "LiberationSans-BoldItalic", "NimbusSanL-BoldItal"));
        substitutes.put("Times-Roman", Arrays.asList("TimesNewRomanPSMT", "TimesNewRoman", "TimesNewRomanPS", "LiberationSerif", "NimbusRomNo9L-Regu"));
        substitutes.put("Times-Bold", Arrays.asList("TimesNewRomanPS-BoldMT", "TimesNewRomanPS-Bold", "TimesNewRoman-Bold", "LiberationSerif-Bold", "NimbusRomNo9L-Medi"));
        substitutes.put("Times-Italic", Arrays.asList("TimesNewRomanPS-ItalicMT", "TimesNewRomanPS-Italic", "TimesNewRoman-Italic", "LiberationSerif-Italic", "NimbusRomNo9L-ReguItal"));
        substitutes.put("Times-BoldItalic", Arrays.asList("TimesNewRomanPS-BoldItalicMT", "TimesNewRomanPS-BoldItalic", "TimesNewRoman-BoldItalic", "LiberationSerif-BoldItalic", "NimbusRomNo9L-MediItal"));
        substitutes.put("Symbol", Arrays.asList("Symbol", "SymbolMT", "StandardSymL"));
        substitutes.put("ZapfDingbats", Arrays.asList("ZapfDingbatsITC", "Dingbats", "MS-Gothic"));
        substitutes.put("$Adobe-CNS1", Arrays.asList("AdobeMingStd-Light"));
        substitutes.put("$Adobe-Japan1", Arrays.asList("KozMinPr6N-Regular"));
        substitutes.put("$Adobe-Korea1", Arrays.asList("AdobeGothicStd-Bold"));
        substitutes.put("$Adobe-GB1", Arrays.asList("AdobeHeitiStd-Regular"));
        for (String baseName : Standard14Fonts.getNames()) {
            if (substitutes.containsKey(baseName)) continue;
            String mappedName = Standard14Fonts.getMappedFontName(baseName);
            substitutes.put(baseName, ExternalFonts.copySubstitutes(mappedName));
        }
    }

    private static class DefaultFontProvider {
        private static final FontProvider INSTANCE = new FileSystemFontProvider();

        private DefaultFontProvider() {
        }
    }
}

