/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class RootDSE
extends ReadOnlyEntry {
    public static final String ATTR_ALT_SERVER = "altServer";
    public static final String ATTR_CHANGELOG_DN = "changelog";
    public static final String ATTR_FIRST_CHANGE_NUMBER = "firstChangeNumber";
    public static final String ATTR_LAST_CHANGE_NUMBER = "lastChangeNumber";
    public static final String ATTR_LAST_PURGED_CHANGE_NUMBER = "lastPurgedChangeNumber";
    public static final String ATTR_NAMING_CONTEXT = "namingContexts";
    public static final String ATTR_SUBSCHEMA_SUBENTRY = "subschemaSubentry";
    public static final String ATTR_SUPPORTED_AUTH_PASSWORD_STORAGE_SCHEME = "supportedAuthPasswordSchemes";
    public static final String ATTR_SUPPORTED_CONTROL = "supportedControl";
    public static final String ATTR_SUPPORTED_EXTENDED_OPERATION = "supportedExtension";
    public static final String ATTR_SUPPORTED_FEATURE = "supportedFeatures";
    public static final String ATTR_SUPPORTED_LDAP_VERSION = "supportedLDAPVersion";
    public static final String ATTR_SUPPORTED_SASL_MECHANISM = "supportedSASLMechanisms";
    public static final String ATTR_VENDOR_NAME = "vendorName";
    public static final String ATTR_VENDOR_VERSION = "vendorVersion";
    private static final String[] REQUEST_ATTRS = new String[]{"*", "+", "altServer", "changelog", "firstChangeNumber", "lastChangeNumber", "lastPurgedChangeNumber", "namingContexts", "subschemaSubentry", "supportedAuthPasswordSchemes", "supportedControl", "supportedExtension", "supportedFeatures", "supportedLDAPVersion", "supportedSASLMechanisms", "vendorName", "vendorVersion"};
    private static final long serialVersionUID = -1678182563511570981L;

    public RootDSE(Entry rootDSEEntry) {
        super(rootDSEEntry);
    }

    public static RootDSE getRootDSE(LDAPInterface connection) throws LDAPException {
        SearchResultEntry rootDSEEntry = connection.getEntry("", REQUEST_ATTRS);
        if (rootDSEEntry == null) {
            return null;
        }
        return new RootDSE(rootDSEEntry);
    }

    public String[] getAltServerURIs() {
        return this.getAttributeValues(ATTR_ALT_SERVER);
    }

    public String getChangelogDN() {
        return this.getAttributeValue(ATTR_CHANGELOG_DN);
    }

    public Long getFirstChangeNumber() {
        return this.getAttributeValueAsLong(ATTR_FIRST_CHANGE_NUMBER);
    }

    public Long getLastChangeNumber() {
        return this.getAttributeValueAsLong(ATTR_LAST_CHANGE_NUMBER);
    }

    public Long getLastPurgedChangeNumber() {
        return this.getAttributeValueAsLong(ATTR_LAST_PURGED_CHANGE_NUMBER);
    }

    public String[] getNamingContextDNs() {
        return this.getAttributeValues(ATTR_NAMING_CONTEXT);
    }

    public String getSubschemaSubentryDN() {
        return this.getAttributeValue(ATTR_SUBSCHEMA_SUBENTRY);
    }

    public String[] getSupportedAuthPasswordSchemeNames() {
        return this.getAttributeValues(ATTR_SUPPORTED_AUTH_PASSWORD_STORAGE_SCHEME);
    }

    public boolean supportsAuthPasswordScheme(String scheme) {
        return this.hasAttributeValue(ATTR_SUPPORTED_AUTH_PASSWORD_STORAGE_SCHEME, scheme);
    }

    public String[] getSupportedControlOIDs() {
        return this.getAttributeValues(ATTR_SUPPORTED_CONTROL);
    }

    public boolean supportsControl(String controlOID) {
        return this.hasAttributeValue(ATTR_SUPPORTED_CONTROL, controlOID);
    }

    public String[] getSupportedExtendedOperationOIDs() {
        return this.getAttributeValues(ATTR_SUPPORTED_EXTENDED_OPERATION);
    }

    public boolean supportsExtendedOperation(String extendedOperationOID) {
        return this.hasAttributeValue(ATTR_SUPPORTED_EXTENDED_OPERATION, extendedOperationOID);
    }

    public String[] getSupportedFeatureOIDs() {
        return this.getAttributeValues(ATTR_SUPPORTED_FEATURE);
    }

    public boolean supportsFeature(String featureOID) {
        return this.hasAttributeValue(ATTR_SUPPORTED_FEATURE, featureOID);
    }

    public int[] getSupportedLDAPVersions() {
        String[] versionStrs = this.getAttributeValues(ATTR_SUPPORTED_LDAP_VERSION);
        if (versionStrs == null) {
            return null;
        }
        int[] versions = new int[versionStrs.length];
        for (int i = 0; i < versionStrs.length; ++i) {
            try {
                versions[i] = Integer.parseInt(versionStrs[i]);
                continue;
            }
            catch (Exception e) {
                Debug.debugException(e);
                return null;
            }
        }
        return versions;
    }

    public boolean supportsLDAPVersion(int ldapVersion) {
        return this.hasAttributeValue(ATTR_SUPPORTED_LDAP_VERSION, String.valueOf(ldapVersion));
    }

    public String[] getSupportedSASLMechanismNames() {
        return this.getAttributeValues(ATTR_SUPPORTED_SASL_MECHANISM);
    }

    public boolean supportsSASLMechanism(String mechanismName) {
        return this.hasAttributeValue(ATTR_SUPPORTED_SASL_MECHANISM, mechanismName);
    }

    public String getVendorName() {
        return this.getAttributeValue(ATTR_VENDOR_NAME);
    }

    public String getVendorVersion() {
        return this.getAttributeValue(ATTR_VENDOR_VERSION);
    }
}

