/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.validator.bean.simple;

import com.google.common.base.Preconditions;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.beans.BeanUtil;
import org.nuiton.validator.NuitonValidator;
import org.nuiton.validator.NuitonValidatorFactory;
import org.nuiton.validator.NuitonValidatorModel;
import org.nuiton.validator.NuitonValidatorProvider;
import org.nuiton.validator.NuitonValidatorResult;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.AbstractNuitonValidatorContext;
import org.nuiton.validator.bean.AbstractValidator;
import org.nuiton.validator.bean.simple.SimpleBeanValidatorEvent;
import org.nuiton.validator.bean.simple.SimpleBeanValidatorListener;

public class SimpleBeanValidator<O>
extends AbstractValidator<O> {
    public static final String BEAN_PROPERTY = "bean";
    private static final Log log = LogFactory.getLog(SimpleBeanValidator.class);
    protected final NuitonValidatorContext<O> context = new NuitonValidatorContext();
    protected SimpleBeanValidator<?> parentValidator;

    public static <O> SimpleBeanValidator<O> newValidator(Class<O> type, String context, NuitonValidatorScope ... scopes) throws NullPointerException {
        String providerName = NuitonValidatorFactory.getDefaultProviderName();
        SimpleBeanValidator<O> beanValidator = SimpleBeanValidator.newValidator(providerName, type, context, scopes);
        return beanValidator;
    }

    public static <O> SimpleBeanValidator<O> newValidator(String providerName, Class<O> type, String context, NuitonValidatorScope ... scopes) throws NullPointerException {
        Preconditions.checkNotNull(type, (Object)"type parameter can not be null.");
        NuitonValidatorProvider provider = NuitonValidatorFactory.getProvider(providerName);
        Preconditions.checkState((provider != null ? 1 : 0) != 0, (Object)("Could not find provider with name " + providerName));
        SimpleBeanValidator<O> validator = new SimpleBeanValidator<O>(provider, type, context, scopes);
        return validator;
    }

    public SimpleBeanValidator(NuitonValidatorProvider validatorProvider, Class<O> beanClass, String context) {
        this(validatorProvider, beanClass, context, NuitonValidatorScope.values());
    }

    public SimpleBeanValidator(NuitonValidatorProvider validatorProvider, Class<O> beanClass, String context, NuitonValidatorScope ... scopes) {
        super(validatorProvider, beanClass);
        this.rebuildDelegateValidator(beanClass, context, scopes);
        this.firePropertyChange("context", null, context);
        this.firePropertyChange("scopes", null, scopes);
    }

    public O getBean() {
        return this.context.getBean();
    }

    public void setBean(O bean) {
        O oldBean;
        block8: {
            oldBean = this.getBean();
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + " : " + bean));
            }
            if (oldBean != null) {
                try {
                    BeanUtil.removePropertyChangeListener((PropertyChangeListener)this.l, oldBean);
                }
                catch (Exception eee) {
                    if (!log.isInfoEnabled()) break block8;
                    log.info((Object)("Can't unregister as listener for bean " + oldBean.getClass() + " for reason " + eee.getMessage()), (Throwable)eee);
                }
            }
        }
        this.context.setBean(bean);
        if (bean == null) {
            this.mergeMessages(null);
        } else {
            block9: {
                try {
                    BeanUtil.addPropertyChangeListener((PropertyChangeListener)this.l, bean);
                }
                catch (Exception eee) {
                    if (!log.isInfoEnabled()) break block9;
                    log.info((Object)("Can't register as listener for bean " + bean.getClass() + " for reason " + eee.getMessage()), (Throwable)eee);
                }
            }
            this.validate();
        }
        this.setChanged(false);
        this.setValid(this.context.isValid());
        this.firePropertyChange(BEAN_PROPERTY, oldBean, bean);
    }

    public SimpleBeanValidator<?> getParentValidator() {
        return this.parentValidator;
    }

    public void setParentValidator(SimpleBeanValidator<?> parentValidator) {
        this.parentValidator = parentValidator;
    }

    @Override
    public boolean hasFatalErrors() {
        boolean result = this.context.hasFatalErrors();
        return result;
    }

    @Override
    public boolean hasErrors() {
        boolean result = this.context.hasErrors();
        return result;
    }

    @Override
    public boolean hasWarnings() {
        boolean result = this.context.hasWarnings();
        return result;
    }

    @Override
    public boolean hasInfos() {
        boolean result = this.context.hasInfos();
        return result;
    }

    @Override
    public boolean isValid(String fieldName) {
        boolean result = this.context.isValid(fieldName);
        return result;
    }

    @Override
    public NuitonValidatorScope getHighestScope(String field) {
        NuitonValidatorScope scope = this.context.getHighestScope(field);
        return scope;
    }

    @Override
    public <T> T convert(O bean, String fieldName, String value, Class<T> valueClass) {
        Preconditions.checkState((boolean)ObjectUtils.equals(bean, this.getBean()), (Object)("Can not validate the bean [" + bean + "] which is not the one registred [" + bean + "] in this validator."));
        T convert = this.convert(fieldName, value, valueClass);
        return convert;
    }

    @Override
    public void doValidate() {
        this.validate();
        this.setValid(this.context.isValid());
        this.setChanged(true);
    }

    public <T> T convert(String fieldName, String value, Class<T> valueClass) {
        T convert = null;
        try {
            convert = this.context.convert(fieldName, value, valueClass);
        }
        catch (ConversionException e) {
            this.validate();
        }
        return convert;
    }

    public void addSimpleBeanValidatorListener(SimpleBeanValidatorListener listener) {
        this.listenerList.add(SimpleBeanValidatorListener.class, listener);
    }

    public void removeSimpleBeanValidatorListener(SimpleBeanValidatorListener listener) {
        this.listenerList.remove(SimpleBeanValidatorListener.class, listener);
    }

    public SimpleBeanValidatorListener[] getSimpleBeanValidatorListeners() {
        return (SimpleBeanValidatorListener[])this.listenerList.getListeners(SimpleBeanValidatorListener.class);
    }

    @Override
    protected void doValidate(O bean) {
        Preconditions.checkState((boolean)ObjectUtils.equals(bean, this.getBean()), (Object)("Can not validate the bean [" + bean + "] which is not the one registred [" + bean + "] in this validator."));
        this.doValidate();
    }

    @Override
    protected NuitonValidator<O> getDelegate() {
        return this.context.getValidator();
    }

    @Override
    protected void rebuildDelegateValidator(Class<O> beanType, String context, NuitonValidatorScope ... scopes) {
        if (this.getBean() != null) {
            this.setBean(null);
        }
        if (scopes == null || scopes.length == 0) {
            scopes = NuitonValidatorScope.values();
        }
        NuitonValidatorModel<O> validatorModel = this.validatorProvider.getModel(beanType, context, scopes);
        NuitonValidator<O> delegate = this.validatorProvider.newValidator(validatorModel);
        this.context.setValidator(delegate);
    }

    protected void validate() {
        if (this.isCanValidate()) {
            NuitonValidatorResult result = this.context.validate();
            this.mergeMessages(result);
            if (this.parentValidator != null) {
                boolean wasModified = this.parentValidator.isChanged();
                this.parentValidator.doValidate();
                if (!wasModified) {
                    this.parentValidator.setChanged(false);
                }
            }
        }
    }

    protected void fireFieldChanged(SimpleBeanValidatorEvent evt) {
        for (SimpleBeanValidatorListener listener : (SimpleBeanValidatorListener[])this.listenerList.getListeners(SimpleBeanValidatorListener.class)) {
            listener.onFieldChanged(evt);
        }
    }

    protected void mergeMessages(NuitonValidatorResult newMessages) {
        List events = this.context.mergeMessages(this, newMessages);
        if (CollectionUtils.isNotEmpty(events)) {
            for (SimpleBeanValidatorEvent event : events) {
                this.fireFieldChanged(event);
            }
        }
    }

    protected static class NuitonValidatorContext<O>
    extends AbstractNuitonValidatorContext<O, SimpleBeanValidator<O>, SimpleBeanValidatorEvent> {
        protected NuitonValidatorContext() {
        }

        @Override
        protected SimpleBeanValidatorEvent createEvent(SimpleBeanValidator<O> source, O bean, String field, NuitonValidatorScope scope, String[] toAdd, String[] toDelete) {
            SimpleBeanValidatorEvent evt = new SimpleBeanValidatorEvent(source, field, scope, toAdd, toDelete);
            return evt;
        }
    }
}

