/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.ehcache.management.impl;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.openmbean.TabularData;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.hibernate.management.api.EhcacheHibernateMBean;
import net.sf.ehcache.hibernate.management.api.EhcacheStats;
import net.sf.ehcache.hibernate.management.api.HibernateStats;
import org.hibernate.SessionFactory;
import org.hibernate.cache.ehcache.management.impl.AbstractEmitterBean;
import org.hibernate.cache.ehcache.management.impl.EhcacheStatsImpl;
import org.hibernate.cache.ehcache.management.impl.HibernateStatsImpl;
import org.hibernate.cache.ehcache.management.impl.NullHibernateStats;

public class EhcacheHibernate
extends AbstractEmitterBean
implements EhcacheHibernateMBean {
    private static final MBeanNotificationInfo NOTIFICATION_INFO;
    private final AtomicBoolean statsEnabled = new AtomicBoolean(true);
    private EhcacheStats ehcacheStats;
    private volatile HibernateStats hibernateStats = NullHibernateStats.INSTANCE;

    public EhcacheHibernate(CacheManager manager) throws NotCompliantMBeanException {
        super(EhcacheHibernateMBean.class);
        this.ehcacheStats = new EhcacheStatsImpl(manager);
    }

    public void enableHibernateStatistics(SessionFactory sessionFactory) {
        try {
            this.hibernateStats = new HibernateStatsImpl(sessionFactory);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isHibernateStatisticsSupported() {
        return this.hibernateStats instanceof HibernateStatsImpl;
    }

    public void setStatisticsEnabled(boolean flag) {
        if (flag) {
            this.ehcacheStats.enableStats();
            this.hibernateStats.enableStats();
        } else {
            this.ehcacheStats.disableStats();
            this.hibernateStats.disableStats();
        }
        this.statsEnabled.set(flag);
        this.sendNotification("CacheStatisticsEnabled", flag);
    }

    public boolean isStatisticsEnabled() {
        return this.statsEnabled.get();
    }

    public void clearStats() {
        this.ehcacheStats.clearStats();
        this.hibernateStats.clearStats();
    }

    public void disableStats() {
        this.setStatisticsEnabled(false);
    }

    public void enableStats() {
        this.setStatisticsEnabled(true);
    }

    public void flushRegionCache(String region) {
        this.ehcacheStats.flushRegionCache(region);
        this.sendNotification("CacheRegionFlushed", region);
    }

    public void flushRegionCaches() {
        this.ehcacheStats.flushRegionCaches();
        this.sendNotification("CacheFlushed");
    }

    public String generateActiveConfigDeclaration() {
        return this.ehcacheStats.generateActiveConfigDeclaration();
    }

    public String generateActiveConfigDeclaration(String region) {
        return this.ehcacheStats.generateActiveConfigDeclaration(region);
    }

    public long getCacheHitCount() {
        return this.ehcacheStats.getCacheHitCount();
    }

    public double getCacheHitRate() {
        return this.ehcacheStats.getCacheHitRate();
    }

    public long getCacheHitSample() {
        return this.ehcacheStats.getCacheHitSample();
    }

    public long getCacheMissCount() {
        return this.ehcacheStats.getCacheMissCount();
    }

    public double getCacheMissRate() {
        return this.ehcacheStats.getCacheMissRate();
    }

    public long getCacheMissSample() {
        return this.ehcacheStats.getCacheMissSample();
    }

    public long getCachePutCount() {
        return this.ehcacheStats.getCachePutCount();
    }

    public double getCachePutRate() {
        return this.ehcacheStats.getCachePutRate();
    }

    public long getCachePutSample() {
        return this.ehcacheStats.getCachePutSample();
    }

    public TabularData getCacheRegionStats() {
        return this.hibernateStats.getCacheRegionStats();
    }

    public long getCloseStatementCount() {
        return this.hibernateStats.getCloseStatementCount();
    }

    public TabularData getCollectionStats() {
        return this.hibernateStats.getCollectionStats();
    }

    public long getConnectCount() {
        return this.hibernateStats.getConnectCount();
    }

    public TabularData getEntityStats() {
        return this.hibernateStats.getEntityStats();
    }

    public long getFlushCount() {
        return this.hibernateStats.getFlushCount();
    }

    public long getOptimisticFailureCount() {
        return this.hibernateStats.getOptimisticFailureCount();
    }

    public String getOriginalConfigDeclaration() {
        return this.ehcacheStats.getOriginalConfigDeclaration();
    }

    public String getOriginalConfigDeclaration(String region) {
        return this.ehcacheStats.getOriginalConfigDeclaration(region);
    }

    public long getPrepareStatementCount() {
        return this.hibernateStats.getPrepareStatementCount();
    }

    public long getQueryExecutionCount() {
        return this.hibernateStats.getQueryExecutionCount();
    }

    public double getQueryExecutionRate() {
        return this.hibernateStats.getQueryExecutionRate();
    }

    public long getQueryExecutionSample() {
        return this.hibernateStats.getQueryExecutionSample();
    }

    public TabularData getQueryStats() {
        return this.hibernateStats.getQueryStats();
    }

    public Map<String, Map<String, Object>> getRegionCacheAttributes() {
        return this.ehcacheStats.getRegionCacheAttributes();
    }

    public Map<String, Object> getRegionCacheAttributes(String regionName) {
        return this.ehcacheStats.getRegionCacheAttributes(regionName);
    }

    public int getRegionCacheMaxTTISeconds(String region) {
        return this.ehcacheStats.getRegionCacheMaxTTISeconds(region);
    }

    public int getRegionCacheMaxTTLSeconds(String region) {
        return this.ehcacheStats.getRegionCacheMaxTTLSeconds(region);
    }

    public int getRegionCacheOrphanEvictionPeriod(String region) {
        return this.ehcacheStats.getRegionCacheOrphanEvictionPeriod(region);
    }

    public Map<String, int[]> getRegionCacheSamples() {
        return this.ehcacheStats.getRegionCacheSamples();
    }

    public int getRegionCacheTargetMaxInMemoryCount(String region) {
        return this.ehcacheStats.getRegionCacheTargetMaxInMemoryCount(region);
    }

    public int getRegionCacheTargetMaxTotalCount(String region) {
        return this.ehcacheStats.getRegionCacheTargetMaxTotalCount(region);
    }

    public long getSessionCloseCount() {
        return this.hibernateStats.getSessionCloseCount();
    }

    public long getSessionOpenCount() {
        return this.hibernateStats.getSessionOpenCount();
    }

    public long getSuccessfulTransactionCount() {
        return this.hibernateStats.getSuccessfulTransactionCount();
    }

    public String[] getTerracottaHibernateCacheRegionNames() {
        return this.ehcacheStats.getTerracottaHibernateCacheRegionNames();
    }

    public long getTransactionCount() {
        return this.hibernateStats.getTransactionCount();
    }

    public boolean isRegionCacheEnabled(String region) {
        return this.ehcacheStats.isRegionCacheEnabled(region);
    }

    public void setRegionCachesEnabled(boolean enabled) {
        this.ehcacheStats.setRegionCachesEnabled(enabled);
        this.sendNotification("CacheEnabled", enabled);
    }

    public void setRegionCacheEnabled(String region, boolean enabled) {
        this.ehcacheStats.setRegionCacheEnabled(region, enabled);
        this.sendNotification("CacheRegionChanged", this.getRegionCacheAttributes(region), region);
    }

    public boolean isRegionCacheLoggingEnabled(String region) {
        return this.ehcacheStats.isRegionCacheLoggingEnabled(region);
    }

    public boolean isRegionCacheOrphanEvictionEnabled(String region) {
        return this.ehcacheStats.isRegionCacheOrphanEvictionEnabled(region);
    }

    public boolean isRegionCachesEnabled() {
        return this.ehcacheStats.isRegionCachesEnabled();
    }

    public boolean isTerracottaHibernateCache(String region) {
        return this.ehcacheStats.isTerracottaHibernateCache(region);
    }

    public void setRegionCacheLoggingEnabled(String region, boolean loggingEnabled) {
        this.ehcacheStats.setRegionCacheLoggingEnabled(region, loggingEnabled);
        this.sendNotification("CacheRegionChanged", this.getRegionCacheAttributes(region), region);
    }

    public void setRegionCacheMaxTTISeconds(String region, int maxTTISeconds) {
        this.ehcacheStats.setRegionCacheMaxTTISeconds(region, maxTTISeconds);
        this.sendNotification("CacheRegionChanged", this.getRegionCacheAttributes(region), region);
    }

    public void setRegionCacheMaxTTLSeconds(String region, int maxTTLSeconds) {
        this.ehcacheStats.setRegionCacheMaxTTLSeconds(region, maxTTLSeconds);
        this.sendNotification("CacheRegionChanged", this.getRegionCacheAttributes(region), region);
    }

    public void setRegionCacheTargetMaxInMemoryCount(String region, int targetMaxInMemoryCount) {
        this.ehcacheStats.setRegionCacheTargetMaxInMemoryCount(region, targetMaxInMemoryCount);
        this.sendNotification("CacheRegionChanged", this.getRegionCacheAttributes(region), region);
    }

    public void setRegionCacheTargetMaxTotalCount(String region, int targetMaxTotalCount) {
        this.ehcacheStats.setRegionCacheTargetMaxTotalCount(region, targetMaxTotalCount);
        this.sendNotification("CacheRegionChanged", this.getRegionCacheAttributes(region), region);
    }

    public int getNumberOfElementsInMemory(String region) {
        return this.ehcacheStats.getNumberOfElementsInMemory(region);
    }

    public int getNumberOfElementsOffHeap(String region) {
        return this.ehcacheStats.getNumberOfElementsOffHeap(region);
    }

    public int getNumberOfElementsOnDisk(String region) {
        return this.ehcacheStats.getNumberOfElementsOnDisk(region);
    }

    public long getMaxGetTimeMillis() {
        return this.ehcacheStats.getMaxGetTimeMillis();
    }

    public long getMaxGetTimeMillis(String cacheName) {
        return this.ehcacheStats.getMaxGetTimeMillis(cacheName);
    }

    public long getMinGetTimeMillis() {
        return this.ehcacheStats.getMinGetTimeMillis();
    }

    public long getMinGetTimeMillis(String cacheName) {
        return this.ehcacheStats.getMinGetTimeMillis(cacheName);
    }

    public float getAverageGetTimeMillis(String region) {
        return this.ehcacheStats.getAverageGetTimeMillis(region);
    }

    @Override
    protected void doDispose() {
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{NOTIFICATION_INFO};
    }

    static {
        String[] notifTypes = new String[]{};
        String name = Notification.class.getName();
        String description = "Ehcache Hibernate Statistics Event";
        NOTIFICATION_INFO = new MBeanNotificationInfo(notifTypes, name, "Ehcache Hibernate Statistics Event");
    }
}

