package com.franciaflex.faxtomail.ui.swing.content.pdfeditor;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class PDFEditorCrossUI extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJVUz08TQRQelrbQgj8QJRjQrHpBQ7aVxIPBKLSlEaxKICbEXpzuTmFwdmeYmaWLROOf4J+gdy8m3jwZD549eDH+C8Z48Gp8s10phTVoD9vNvPe+ed/3vrevv6GskujCJo4iR4aBpj5xlubX1u43N4mrq0S5kgrNJer8+ixkNdCQt3euNLrUqJvyYlJerHBf8IAE+6pn66ig9A4jaoMQrdG53gpXqeLqXng2EqH8g7rXVBrqyx/frRfe81cWQpGA7iygYh9V1WWSqSOLehqdgpu2cZHhYB3akDRYh36PmbMKw0rdwz7ZQs/QQB3lBJYAptHFf6ccY8T1kdCo4Equ1DIOCNNoweW+05I4cCluMRI5LRxp7mPKnJA6qg2dOC4PNAA7wmsRjwKws1ytLcRvFQP1YFGIGD6n0bAkPt8m5VBrqEKjhkKU4Cx1Tk1mXoBOEz06wQSc7gS6EvU1UFaGcKzReOPw0FYg1BnX+IFxGcA4+mts9PO7r29rf2aUgbvPpKbusxhoJyQXRGpqrj7RGVCoKSvexWK2gfKKMPBn7L/JlMZWkzA0B/eNmHLHlDu3sdoAiOzAl/cfxh596kdWDRUYx14Nm/xFlNcbElTgzIvErbm4o+H2IDxPmt6gFx9H1A/9Fd6u8NB4wZopRaDAZIoCe2008x9/jq6+mdvv1LN/Te8qkX2IcjRgNCCxVxMbpnpzSCgSerxrtzQDIrDgWJngoEaZJhI3Icz9Ji/zKLHReZMybFIOBE7Hz/FDmmQ0ynGBt0LwTbaFmYL/QhO7j9cl6APrNbhrByFj9lNIbHLpwVTRlV27HL92ZN9xXEmwJlWYDvE6kSlTdNlUZRR9AqATgEPadhXUChTlwdS1UmnanimVICkKTXOTRrSERc+qiSM4wO5kNIlgmP32mg38W9wNoZTC7nldWv/P83o6zzoMNGFZ4Qx2ulyfr9yZtq9O2zFyTHskWf15KIFxsW4naWx7dv8ovuDjHMM7HJLR8Rse1thu0sCD78TNQ9h95lkAxN/WE+T0LAYAAA==";
    private static final Log log = LogFactory.getLog(PDFEditorCrossUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected PDFEditorCrossUI crossPanel = this;
    protected JButton removeButton;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void removeCross() {
            JPanel container = getParentContainer(JPanel.class);
            container.remove(this);
            container.updateUI();
        }
    
        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
    
            Graphics2D g2 = (Graphics2D) g.create();
            g2.setStroke(new BasicStroke(3));
            g2.setColor(Color.BLUE);
            g2.drawLine(0, 0, getWidth(), getHeight());
            g2.drawLine(getWidth(), 0, 0, getHeight());
            g2.dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public PDFEditorCrossUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public PDFEditorCrossUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PDFEditorCrossUI() {
        $initialize();
    }

    public PDFEditorCrossUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PDFEditorCrossUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public PDFEditorCrossUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public PDFEditorCrossUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public PDFEditorCrossUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__removeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        removeCross();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getRemoveButton() {
        return removeButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCrossPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(removeButton);
    }

    protected void createRemoveButton() {
        $objectMap.put("removeButton", removeButton = new JButton());
        
        removeButton.setName("removeButton");
        removeButton.setText(t(" X "));
        removeButton.setOpaque(false);
        removeButton.setFocusPainted(false);
        removeButton.setContentAreaFilled(false);
        removeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToCrossPanel();
        
        // apply 6 property setters
        setBackground( null );
        setBorder( BorderFactory.createDashedBorder(null) );
        setSize( new Dimension(500, 200) );
        removeButton.setBackground( null );
        removeButton.setBorder( BorderFactory.createLineBorder(Color.BLACK, 1, false) );
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("crossPanel", crossPanel);
        createRemoveButton();
        // inline creation of crossPanel
        setName("crossPanel");
        setLayout(new FlowLayout(FlowLayout.TRAILING));
        setOpaque(false);
        
        $completeSetup();
    }

}