/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.compound;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.Element;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.compound.AtomicHashEntry;
import net.sf.ehcache.store.compound.ElementSubstitute;
import net.sf.ehcache.store.compound.ElementSubstituteFactory;
import net.sf.ehcache.store.compound.ElementSubstituteFilter;
import net.sf.ehcache.store.compound.HashEntry;
import net.sf.ehcache.store.compound.IdentityElementSubstituteFactory;
import net.sf.ehcache.store.compound.InternalElementSubstituteFactory;
import net.sf.ehcache.store.compound.ReadWriteCopyStrategy;
import net.sf.ehcache.store.compound.SynchronizedHashEntry;
import net.sf.ehcache.util.VmUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Segment
extends ReentrantReadWriteLock {
    private static final float LOAD_FACTOR = 0.75f;
    private static final int MAXIMUM_CAPACITY = Integer.highestOneBit(Integer.MAX_VALUE);
    protected volatile int count;
    protected int modCount;
    private final InternalElementSubstituteFactory primaryFactory;
    private final InternalElementSubstituteFactory identityFactory;
    private volatile HashEntry[] table;
    private int threshold;
    private final boolean copyOnRead;
    private final boolean copyOnWrite;
    private final ReadWriteCopyStrategy<Element> copyStrategy;

    Segment(int initialCapacity, float loadFactor, InternalElementSubstituteFactory primary) {
        this(initialCapacity, loadFactor, primary, primary instanceof IdentityElementSubstituteFactory ? (IdentityElementSubstituteFactory)primary : null);
    }

    Segment(int initialCapacity, float loadFactor, InternalElementSubstituteFactory primary, IdentityElementSubstituteFactory identity) {
        this(initialCapacity, loadFactor, primary, identity, false, false, null);
    }

    Segment(int initialCapacity, float loadFactor, InternalElementSubstituteFactory primary, IdentityElementSubstituteFactory identity, boolean copyOnRead, boolean copyOnWrite, ReadWriteCopyStrategy<Element> copyStrategy) {
        this.table = new HashEntry[initialCapacity];
        this.threshold = (int)((float)this.table.length * loadFactor);
        this.modCount = 0;
        this.primaryFactory = primary;
        this.identityFactory = identity;
        this.copyOnRead = copyOnRead;
        this.copyOnWrite = copyOnWrite;
        if ((copyOnRead || copyOnWrite) && copyStrategy == null) {
            throw new NullPointerException("You need to provide a non-null CopyStrategy if copyOnRead or copyOnWrite is set to true!");
        }
        this.copyStrategy = copyStrategy;
    }

    private HashEntry getFirst(int hash) {
        HashEntry[] tab = this.table;
        return tab[hash & tab.length - 1];
    }

    Element decode(Object key, Object object) {
        Element element;
        if (object instanceof Element) {
            element = this.identityFactory.retrieve(key, object);
        } else {
            ElementSubstituteFactory<ElementSubstitute> factory = ((ElementSubstitute)object).getFactory();
            element = factory.retrieve(key, (ElementSubstitute)object);
        }
        return this.potentiallyCopyForRead(element, this.copyOnRead);
    }

    private Element potentiallyCopyForRead(Element value, boolean copy) {
        Element newValue = copy && this.copyOnRead && this.copyOnWrite ? this.copyStrategy.copyForRead(value) : (copy ? this.copyStrategy.copyForRead(this.copyStrategy.copyForWrite(value)) : value);
        return newValue;
    }

    private Element potentiallyCopyForWrite(Element value, boolean copy) {
        Element newValue = copy && this.copyOnRead && this.copyOnWrite ? this.copyStrategy.copyForWrite(value) : (copy ? this.copyStrategy.copyForRead(this.copyStrategy.copyForWrite(value)) : value);
        return newValue;
    }

    private void free(Object object) {
        if (object instanceof Element) {
            this.identityFactory.free(this.writeLock(), object);
        } else {
            ((ElementSubstitute)object).getFactory().free(this.writeLock(), (ElementSubstitute)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Element get(Object key, int hash) {
        this.readLock().lock();
        try {
            if (this.count != 0) {
                HashEntry e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && key.equals(e.key)) {
                        Element element = this.decode(e.key, e.getElement());
                        return element;
                    }
                    e = e.next;
                }
            }
            Element element = null;
            return element;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object unretrievedGet(Object key, int hash) {
        this.readLock().lock();
        try {
            if (this.count != 0) {
                HashEntry e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && key.equals(e.key)) {
                        Object object = e.getElement();
                        return object;
                    }
                    e = e.next;
                }
            }
        }
        finally {
            this.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsKey(Object key, int hash) {
        this.readLock().lock();
        try {
            if (this.count != 0) {
                HashEntry e = this.getFirst(hash);
                while (e != null) {
                    if (e.hash == hash && key.equals(e.key)) {
                        boolean bl = true;
                        return bl;
                    }
                    e = e.next;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsValue(Element value, ElementValueComparator comparator) {
        this.readLock().lock();
        try {
            if (this.count != 0) {
                for (HashEntry e : this.table) {
                    while (e != null) {
                        Element element = this.decode(e.key, e.getElement());
                        if (comparator.equals(value, element)) {
                            boolean bl = true;
                            return bl;
                        }
                        e = e.next;
                    }
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean replace(Object key, int hash, Element oldElement, Element newElement, ElementValueComparator comparator) {
        boolean installed = false;
        Object encoded = this.create(key, newElement);
        this.writeLock().lock();
        try {
            HashEntry e = this.getFirst(hash);
            while (!(e == null || e.hash == hash && key.equals(e.key))) {
                e = e.next;
            }
            boolean replaced = false;
            if (e != null && comparator.equals(oldElement, this.decode(e.key, e.getElement()))) {
                replaced = true;
                Object old = e.getElement();
                e.setElement(encoded);
                installed = true;
                this.free(old);
            } else {
                this.free(encoded);
            }
            boolean bl = replaced;
            return bl;
        }
        finally {
            this.writeLock().unlock();
            if (installed && encoded instanceof ElementSubstitute) {
                ((ElementSubstitute)encoded).installed();
            }
        }
    }

    private Object create(Object key, Element newElement) {
        return this.primaryFactory.create(key, this.potentiallyCopyForWrite(newElement, this.copyOnWrite));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Element replace(Object key, int hash, Element newElement) {
        boolean installed = false;
        Object encoded = this.create(key, newElement);
        this.writeLock().lock();
        try {
            HashEntry e = this.getFirst(hash);
            while (!(e == null || e.hash == hash && key.equals(e.key))) {
                e = e.next;
            }
            Element oldElement = null;
            if (e != null) {
                Object old = e.getElement();
                e.setElement(encoded);
                installed = true;
                oldElement = this.decode(null, old);
                this.free(old);
            } else {
                this.free(encoded);
            }
            Element element = oldElement;
            return element;
        }
        finally {
            this.writeLock().unlock();
            if (installed && encoded instanceof ElementSubstitute) {
                ((ElementSubstitute)encoded).installed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Element put(Object key, int hash, Element element, boolean onlyIfAbsent) {
        boolean installed = false;
        Object encoded = this.create(key, element);
        this.writeLock().lock();
        try {
            Element oldElement;
            HashEntry first;
            if (this.count + 1 > this.threshold) {
                this.rehash();
            }
            HashEntry[] tab = this.table;
            int index = hash & tab.length - 1;
            HashEntry e = first = tab[index];
            while (!(e == null || e.hash == hash && key.equals(e.key))) {
                e = e.next;
            }
            if (e != null) {
                Object old = e.getElement();
                if (!onlyIfAbsent) {
                    e.setElement(encoded);
                    installed = true;
                    oldElement = this.decode(null, old);
                    this.free(old);
                } else {
                    this.free(encoded);
                    oldElement = this.decode(e.key, old);
                }
            } else {
                oldElement = null;
                ++this.modCount;
                tab[index] = this.newHashEntry(key, hash, first, encoded);
                installed = true;
                ++this.count;
            }
            Element element2 = oldElement;
            return element2;
        }
        finally {
            this.writeLock().unlock();
            if (installed && encoded instanceof ElementSubstitute) {
                ((ElementSubstitute)encoded).installed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean putRawIfAbsent(Object key, int hash, Object encoded) {
        this.writeLock().lock();
        try {
            HashEntry first;
            if (this.count + 1 > this.threshold) {
                this.rehash();
            }
            HashEntry[] tab = this.table;
            int index = hash & tab.length - 1;
            HashEntry e = first = tab[index];
            while (!(e == null || e.hash == hash && key.equals(e.key))) {
                e = e.next;
            }
            if (e == null) {
                Object oldElement = null;
                ++this.modCount;
                tab[index] = this.newHashEntry(key, hash, first, encoded);
                ++this.count;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    private void rehash() {
        HashEntry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity >= MAXIMUM_CAPACITY) {
            return;
        }
        HashEntry[] newTable = new HashEntry[oldCapacity << 1];
        this.threshold = (int)((float)newTable.length * 0.75f);
        int sizeMask = newTable.length - 1;
        for (int i = 0; i < oldCapacity; ++i) {
            int k;
            HashEntry e = oldTable[i];
            if (e == null) continue;
            HashEntry next = e.next;
            int idx = e.hash & sizeMask;
            if (next == null) {
                newTable[idx] = e;
                continue;
            }
            HashEntry lastRun = e;
            int lastIdx = idx;
            HashEntry last = next;
            while (last != null) {
                k = last.hash & sizeMask;
                if (k != lastIdx) {
                    lastIdx = k;
                    lastRun = last;
                }
                last = last.next;
            }
            newTable[lastIdx] = lastRun;
            HashEntry p = e;
            while (p != lastRun) {
                k = p.hash & sizeMask;
                HashEntry n = newTable[k];
                newTable[k] = this.newHashEntry(p.key, p.hash, n, p.getElement());
                p = p.next;
            }
        }
        this.table = newTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Element remove(Object key, int hash, Element value, ElementValueComparator comparator) {
        this.writeLock().lock();
        try {
            HashEntry first;
            HashEntry[] tab = this.table;
            int index = hash & tab.length - 1;
            HashEntry e = first = tab[index];
            while (!(e == null || e.hash == hash && key.equals(e.key))) {
                e = e.next;
            }
            Element oldValue = null;
            if (e != null && (value == null || comparator.equals(value, this.decode(e.key, e.getElement())))) {
                ++this.modCount;
                HashEntry newFirst = e.next;
                HashEntry p = first;
                while (p != e) {
                    newFirst = this.newHashEntry(p.key, p.hash, newFirst, p.getElement());
                    p = p.next;
                }
                tab[index] = newFirst;
                Object v = e.getElement();
                oldValue = this.decode(null, v);
                this.free(v);
                --this.count;
            }
            Element element = oldValue;
            return element;
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        this.writeLock().lock();
        try {
            if (this.count != 0) {
                HashEntry[] tab = this.table;
                for (int i = 0; i < tab.length; ++i) {
                    HashEntry e = tab[i];
                    while (e != null) {
                        this.free(e.getElement());
                        e = e.next;
                    }
                    tab[i] = null;
                }
                ++this.modCount;
                this.count = 0;
            }
        }
        finally {
            this.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tryFault(Object key, int hash, Object expect, Object fault) {
        boolean installed = false;
        if (this.readLock().tryLock()) {
            try {
                installed = this.install(key, hash, expect, fault);
                if (installed) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.readLock().unlock();
                if (installed && fault instanceof ElementSubstitute) {
                    ((ElementSubstitute)fault).installed();
                }
            }
        }
        this.free(fault);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean fault(Object key, int hash, Object expect, Object fault) {
        boolean installed = false;
        this.readLock().lock();
        try {
            installed = this.install(key, hash, expect, fault);
            if (installed) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.readLock().unlock();
            if (installed && fault instanceof ElementSubstitute) {
                ((ElementSubstitute)fault).installed();
            }
        }
        this.free(fault);
        return false;
    }

    private boolean install(Object key, int hash, Object expect, Object fault) {
        if (this.count != 0) {
            HashEntry e = this.getFirst(hash);
            while (e != null) {
                if (e.hash == hash && key.equals(e.key) && e.casElement(expect, fault)) {
                    this.free(expect);
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean evict(Object key, int hash, Object value) {
        if (this.writeLock().tryLock()) {
            try {
                HashEntry first;
                HashEntry[] tab = this.table;
                int index = hash & tab.length - 1;
                HashEntry e = first = tab[index];
                while (!(e == null || e.hash == hash && key.equals(e.key))) {
                    e = e.next;
                }
                if (e != null && (value == null || value == e.getElement())) {
                    ++this.modCount;
                    HashEntry newFirst = e.next;
                    HashEntry p = first;
                    while (p != e) {
                        newFirst = this.newHashEntry(p.key, p.hash, newFirst, p.getElement());
                        p = p.next;
                    }
                    tab[index] = newFirst;
                    Object v = e.getElement();
                    this.free(v);
                    --this.count;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.writeLock().unlock();
            }
        }
        return false;
    }

    <T> void addRandomSample(ElementSubstituteFilter<T> filter, int sampleSize, Collection<T> sampled, int seed) {
        int tableStart;
        HashEntry[] tab = this.table;
        int tableIndex = tableStart = seed & tab.length - 1;
        do {
            HashEntry e = tab[tableIndex];
            while (e != null) {
                Object value = e.getElement();
                if (filter.allows(value)) {
                    sampled.add(value);
                }
                e = e.next;
            }
            if (sampled.size() < sampleSize) continue;
            return;
        } while ((tableIndex = tableIndex + 1 & tab.length - 1) != tableStart);
    }

    Iterator<HashEntry> hashIterator() {
        return new HashIterator();
    }

    private HashEntry newHashEntry(Object key, int hash, HashEntry newFirst, Object element) {
        if (VmUtils.isInGoogleAppEngine()) {
            return new SynchronizedHashEntry(key, hash, newFirst, element);
        }
        return new AtomicHashEntry(key, hash, newFirst, element);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class HashIterator
    implements Iterator<HashEntry> {
        private int nextTableIndex;
        private final HashEntry[] ourTable;
        private HashEntry nextEntry;
        private HashEntry lastReturned;

        private HashIterator() {
            if (Segment.this.count != 0) {
                this.ourTable = Segment.this.table;
                for (int j = this.ourTable.length - 1; j >= 0; --j) {
                    this.nextEntry = this.ourTable[j];
                    if (this.nextEntry == null) continue;
                    this.nextTableIndex = j - 1;
                    return;
                }
            } else {
                this.ourTable = null;
                this.nextTableIndex = -1;
            }
            this.advance();
        }

        private void advance() {
            if (this.nextEntry != null) {
                this.nextEntry = this.nextEntry.next;
                if (this.nextEntry != null) {
                    return;
                }
            }
            while (this.nextTableIndex >= 0) {
                this.nextEntry = this.ourTable[this.nextTableIndex--];
                if (this.nextEntry == null) continue;
                return;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != null;
        }

        @Override
        public HashEntry next() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextEntry;
            this.advance();
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            Segment.this.remove(this.lastReturned.key, this.lastReturned.hash, null, null);
            this.lastReturned = null;
        }
    }
}

