/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.actions;

import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.FaxToMailUser;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.services.FaxToMailServiceContext;
import com.franciaflex.faxtomail.services.service.EmailService;
import com.franciaflex.faxtomail.services.service.exceptions.AlreadyLockedMailException;
import com.franciaflex.faxtomail.services.service.exceptions.FolderNotReadableException;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.MainUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandesUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.demandgroup.DemandGroupUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.demandgroup.DemandGroupUIHandler;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;

public class OpenGroupedDemandAction
extends AbstractFaxToMailAction<DemandeUIModel, DemandGroupUI, DemandGroupUIHandler> {
    protected DemandeUIModel demandToOpen;
    protected boolean takeEmail;

    public OpenGroupedDemandAction(DemandGroupUIHandler handler, DemandeUIModel demandToOpen) {
        super(handler, false);
        this.demandToOpen = demandToOpen;
        this.setActionDescription(I18n.t((String)"faxtomail.action.goto.demand.tip", (Object[])new Object[0]));
    }

    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        MainUIHandler mainUIHandler = this.getContext().getMainUI().getHandler();
        DemandesUI parentContainer = (DemandesUI)mainUIHandler.getCurrentBody();
        if (parentContainer.getModel().containsDemand(this.demandToOpen)) {
            this.openDemandScreen();
            result = false;
        } else {
            String topiaId = this.demandToOpen.getTopiaId();
            if (StringUtils.isNotBlank((CharSequence)topiaId)) {
                FaxToMailUser currentUser = this.getContext().getCurrentUser();
                int answer = -1;
                try {
                    FaxToMailServiceContext serviceContext = this.getContext().newServiceContext();
                    EmailService emailService = serviceContext.getEmailService();
                    Email email = emailService.lockEmail(topiaId, currentUser);
                    FaxToMailUser takenBy = email.getTakenBy();
                    if (takenBy != null && !currentUser.equals(takenBy)) {
                        String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"faxtomail.alert.alreadyTakenBy.message", (Object[])new Object[]{this.decorate(takenBy)}), I18n.t((String)"faxtomail.alert.alreadyTakenBy.help", (Object[])new Object[0]));
                        answer = JOptionPane.showConfirmDialog(((DemandGroupUIHandler)this.getHandler()).getTopestUI(), htmlMessage, I18n.t((String)"faxtomail.alert.alreadyTakenBy.title", (Object[])new Object[0]), 1, 3);
                    }
                    if (answer == 2) {
                        result = false;
                        emailService.unlockEmail(topiaId);
                    } else if (answer == 1) {
                        this.demandToOpen.setEditable(false);
                        this.takeEmail = false;
                    } else if (answer == 0) {
                        this.takeEmail = true;
                        this.demandToOpen.setEditable(true);
                    }
                }
                catch (AlreadyLockedMailException ex) {
                    result = false;
                    String htmlMessage = I18n.t((String)"faxtomail.alert.alreadyLockedBy.message", (Object[])new Object[]{this.decorate(ex.getLockedBy())});
                    JOptionPane.showMessageDialog(((DemandGroupUIHandler)this.getHandler()).getTopestUI(), htmlMessage, I18n.t((String)"faxtomail.alert.alreadyLockedBy.title", (Object[])new Object[0]), 0);
                }
                catch (FolderNotReadableException e) {
                    result = false;
                    String htmlMessage = I18n.t((String)"faxtomail.alert.userNotAuthorizedToReadEmail.message", (Object[])new Object[]{e.getForbiddenFolder().getName()});
                    JOptionPane.showMessageDialog(((DemandGroupUIHandler)this.getHandler()).getTopestUI(), htmlMessage, I18n.t((String)"faxtomail.alert.userNotAuthorizedToReadEmail.title", (Object[])new Object[0]), 0);
                }
            }
        }
        return result;
    }

    @Override
    public void doAction() throws Exception {
        if (StringUtils.isNotBlank((CharSequence)this.demandToOpen.getTopiaId())) {
            FaxToMailServiceContext serviceContext = this.getContext().newServiceContext();
            Email email = serviceContext.getEmailService().openEmail(this.demandToOpen.getTopiaId(), this.getContext().getCurrentUser(), this.takeEmail);
            this.demandToOpen.fromEntity(email);
            this.demandToOpen.recomputeValidRangeRows();
            MailFolder folder = this.demandToOpen.getMailFolder();
            if (this.demandToOpen.getArchiveDate() != null || !folder.isFolderWritable() || !this.demandToOpen.getDemandStatus().isEditableStatus()) {
                this.demandToOpen.setEditable(false);
            }
            this.demandToOpen.setCloseable(true);
        }
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        this.openDemandScreen();
    }

    protected void openDemandScreen() {
        MainUIHandler mainUIHandler = this.getContext().getMainUI().getHandler();
        DemandesUI parentContainer = (DemandesUI)mainUIHandler.getCurrentBody();
        parentContainer.getModel().addDemand(this.demandToOpen);
    }
}

