/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.actions;

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.ui.swing.actions.AbstractFaxToMailAction;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentEditorUI;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentEditorUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentEditorUIModel;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import org.nuiton.i18n.I18n;

public class OpenAttachmentAction
extends AbstractFaxToMailAction<AttachmentEditorUIModel, AttachmentEditorUI, AttachmentEditorUIHandler> {
    protected Attachment attachment;
    protected boolean original;

    public OpenAttachmentAction(AttachmentEditorUIHandler handler) {
        super(handler, false);
    }

    public void setAttachment(Attachment attachment, boolean original) {
        this.attachment = attachment;
        this.original = original;
        String attachmentName = original ? attachment.getOriginalFileName() : attachment.getEditedFileName();
        this.setActionDescription(I18n.t((String)"faxtomail.action.attachment.open.tip", (Object[])new Object[]{attachmentName}));
    }

    @Override
    public void doAction() throws Exception {
        ((AttachmentEditorUIModel)this.getModel()).fireAttachmentOpened(this.attachment, this.original);
        FaxToMailUIUtil.forceAttachmentFileLoading(this.getContext(), this.attachment);
        AttachmentFile attachmentFile = this.original ? this.attachment.getOriginalFile() : this.attachment.getEditedFile();
        FaxToMailUIUtil.openFile(this.getContext(), attachmentFile);
    }
}

