/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.fdf.FDFField;
import org.apache.pdfbox.pdmodel.interactive.action.PDFormFieldAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDNonTerminalField;

public abstract class PDTerminalField
extends PDField {
    protected PDTerminalField(PDAcroForm acroForm) {
        super(acroForm);
    }

    PDTerminalField(PDAcroForm acroForm, COSDictionary field, PDNonTerminalField parent) {
        super(acroForm, field, parent);
    }

    public void setActions(PDFormFieldAdditionalActions actions) {
        this.dictionary.setItem(COSName.AA, (COSObjectable)actions);
    }

    @Override
    public int getFieldFlags() {
        int retval = 0;
        COSInteger ff = (COSInteger)this.dictionary.getDictionaryObject(COSName.FF);
        if (ff != null) {
            retval = ff.intValue();
        } else if (this.parent != null) {
            retval = this.parent.getFieldFlags();
        }
        return retval;
    }

    @Override
    public String getFieldType() {
        String fieldType = this.dictionary.getNameAsString(COSName.FT);
        if (fieldType == null && this.parent != null) {
            fieldType = this.parent.getFieldType();
        }
        return fieldType;
    }

    @Override
    public void importFDF(FDFField fdfField) throws IOException {
        super.importFDF(fdfField);
        PDAnnotationWidget widget = this.getWidgets().get(0);
        if (widget != null) {
            int annotFlags = widget.getAnnotationFlags();
            Integer f = fdfField.getWidgetFieldFlags();
            if (f != null) {
                widget.setAnnotationFlags(f);
            } else {
                Integer clrF;
                Integer setF = fdfField.getSetWidgetFieldFlags();
                if (setF != null) {
                    widget.setAnnotationFlags(annotFlags |= setF.intValue());
                }
                if ((clrF = fdfField.getClearWidgetFieldFlags()) != null) {
                    int clrFValue = clrF;
                    clrFValue = (int)((long)clrFValue ^ 0xFFFFFFFFL);
                    widget.setAnnotationFlags(annotFlags &= clrFValue);
                }
            }
        }
    }

    @Override
    FDFField exportFDF() throws IOException {
        FDFField fdfField = new FDFField();
        fdfField.setPartialFieldName(this.getPartialName());
        fdfField.setValue(this.dictionary.getDictionaryObject(COSName.V));
        return fdfField;
    }

    public List<PDAnnotationWidget> getWidgets() {
        ArrayList<PDAnnotationWidget> widgets = new ArrayList<PDAnnotationWidget>();
        COSArray kids = (COSArray)this.dictionary.getDictionaryObject(COSName.KIDS);
        if (kids == null) {
            widgets.add(new PDAnnotationWidget(this.dictionary));
        } else if (kids.size() > 0) {
            for (int i = 0; i < kids.size(); ++i) {
                COSBase kid = kids.getObject(i);
                if (!(kid instanceof COSDictionary)) continue;
                widgets.add(new PDAnnotationWidget((COSDictionary)kid));
            }
        }
        return widgets;
    }

    public void setWidgets(List<PDAnnotationWidget> children) {
        COSArray kidsArray = COSArrayList.converterToCOSArray(children);
        this.dictionary.setItem(COSName.KIDS, (COSBase)kidsArray);
    }

    @Deprecated
    public PDAnnotationWidget getWidget() {
        return this.getWidgets().get(0);
    }

    protected final void applyChange() throws IOException {
        if (!this.acroForm.getNeedAppearances()) {
            this.constructAppearances();
        }
    }

    abstract void constructAppearances() throws IOException;
}

