package com.franciaflex.faxtomail.ui.swing.content.demande;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.DemandType;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.Priority;
import com.franciaflex.faxtomail.persistence.entities.Range;
import com.franciaflex.faxtomail.persistence.entities.WaitingState;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.content.attachment.ButtonAttachment;
import com.franciaflex.faxtomail.ui.swing.content.demande.history.ButtonHistory;
import com.franciaflex.faxtomail.ui.swing.content.demande.replies.ButtonDemandReplies;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n.t;

public class DemandeUI extends JPanel implements FaxToMailUI<DemandeUIModel, DemandeUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ATTACHMENTS_BUTTON_EDITABLE = "attachmentsButton.editable";
    public static final String BINDING_BRAND_FIELD_TEXT = "brandField.text";
    public static final String BINDING_CC_RECIPIENTS_FIELD_TEXT = "ccRecipientsField.text";
    public static final String BINDING_CLIENT_FIELD_EDITABLE = "clientField.editable";
    public static final String BINDING_CLIENT_FIELD_TEXT = "clientField.text";
    public static final String BINDING_COMMENT_FIELD_EDITABLE = "commentField.editable";
    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_COMPANY_REFERENCE_FIELD_EDITABLE = "companyReferenceField.editable";
    public static final String BINDING_COMPANY_REFERENCE_FIELD_TEXT = "companyReferenceField.text";
    public static final String BINDING_DEMAND_REPLIES_BUTTON_EDITABLE = "demandRepliesButton.editable";
    public static final String BINDING_DOC_TYPE_COMBO_BOX_EDITABLE = "docTypeComboBox.editable";
    public static final String BINDING_DOC_TYPE_COMBO_BOX_ENABLED = "docTypeComboBox.enabled";
    public static final String BINDING_DOC_TYPE_COMBO_BOX_SELECTED_ITEM = "docTypeComboBox.selectedItem";
    public static final String BINDING_EDI_ERROR_FIELD_TEXT = "ediErrorField.text";
    public static final String BINDING_EDI_ERROR_FIELD_VISIBLE = "ediErrorField.visible";
    public static final String BINDING_EDI_ERROR_LABEL_VISIBLE = "ediErrorLabel.visible";
    public static final String BINDING_FIRST_OPENED_BY_FIELD_TEXT = "firstOpenedByField.text";
    public static final String BINDING_FIRST_OPENING_DATE_FIELD_TEXT = "firstOpeningDateField.text";
    public static final String BINDING_LAST_ATTACHMENT_OPENED_BY_FIELD_TEXT = "lastAttachmentOpenedByField.text";
    public static final String BINDING_LAST_ATTACHMENT_OPENING_DATE_FIELD_TEXT = "lastAttachmentOpeningDateField.text";
    public static final String BINDING_LAST_ATTACHMENT_OPENING_PANEL_VISIBLE = "lastAttachmentOpeningPanel.visible";
    public static final String BINDING_LAST_MODIFICATION_DATE_FIELD_TEXT = "lastModificationDateField.text";
    public static final String BINDING_LAST_MODIFIED_BY_FIELD_TEXT = "lastModifiedByField.text";
    public static final String BINDING_LEFT_VERTICAL_SPLIT_PANEL_DIVIDER_SIZE = "leftVerticalSplitPanel.dividerSize";
    public static final String BINDING_OBJECT_FIELD_EDITABLE = "objectField.editable";
    public static final String BINDING_OBJECT_FIELD_TEXT = "objectField.text";
    public static final String BINDING_PF_NB_FIELD_TEXT = "pfNbField.text";
    public static final String BINDING_PRIORITY_COMBO_BOX_EDITABLE = "priorityComboBox.editable";
    public static final String BINDING_PRIORITY_COMBO_BOX_ENABLED = "priorityComboBox.enabled";
    public static final String BINDING_PRIORITY_COMBO_BOX_SELECTED_ITEM = "priorityComboBox.selectedItem";
    public static final String BINDING_PROJECT_REFERENCE_FIELD_EDITABLE = "projectReferenceField.editable";
    public static final String BINDING_PROJECT_REFERENCE_FIELD_TEXT = "projectReferenceField.text";
    public static final String BINDING_QUOTATION_NB_FIELD_TEXT = "quotationNbField.text";
    public static final String BINDING_RANGE_PANEL_VISIBLE = "rangePanel.visible";
    public static final String BINDING_RANGE_TABLE_EDITABLE = "rangeTable.editable";
    public static final String BINDING_RECEIVED_DATE_FIELD_TEXT = "receivedDateField.text";
    public static final String BINDING_SAV_NB_FIELD_TEXT = "savNbField.text";
    public static final String BINDING_SENDER_FIELD_TEXT = "senderField.text";
    public static final String BINDING_STATUS_COMBO_BOX_EDITABLE = "statusComboBox.editable";
    public static final String BINDING_STATUS_COMBO_BOX_ENABLED = "statusComboBox.enabled";
    public static final String BINDING_STATUS_COMBO_BOX_SELECTED_ITEM = "statusComboBox.selectedItem";
    public static final String BINDING_STATUS_COMBO_BOX_VISIBLE = "statusComboBox.visible";
    public static final String BINDING_STATUS_FIELD_TEXT = "statusField.text";
    public static final String BINDING_STATUS_FIELD_VISIBLE = "statusField.visible";
    public static final String BINDING_SUBJECT_FIELD_TEXT = "subjectField.text";
    public static final String BINDING_TAKEN_BY_FIELD_TEXT = "takenByField.text";
    public static final String BINDING_TO_RECIPIENTS_FIELD_TEXT = "toRecipientsField.text";
    public static final String BINDING_WAITING_STATE_COMBO_BOX_EDITABLE = "waitingStateComboBox.editable";
    public static final String BINDING_WAITING_STATE_COMBO_BOX_ENABLED = "waitingStateComboBox.enabled";
    public static final String BINDING_WAITING_STATE_COMBO_BOX_SELECTED_ITEM = "waitingStateComboBox.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(DemandeUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected ButtonAttachment attachmentsButton;
    protected JLabel brandField;
    protected JLabel brandLabel;
    protected JLabel ccRecipientsField;
    protected JLabel ccRecipientsLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "clientCode",  editorName = "clientField")
    protected JTextField clientField;
    protected JLabel clientLabel;
    protected JEditorPane commentField;
    protected JLabel commentLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "comment",  editorName = "commentPane")
    protected JScrollPane commentPane;
    @ValidatorField( validatorId = "validator",  propertyName = "companyReference",  editorName = "companyReferenceField")
    protected JTextField companyReferenceField;
    protected JLabel companyReferenceLabel;
    protected JScrollPane demandForm;
    protected DemandeUI demandPanel = this;
    protected ButtonDemandReplies demandRepliesButton;
    @ValidatorField( validatorId = "validator",  propertyName = "demandType",  editorName = "docTypeComboBox")
    protected BeanFilterableComboBox<DemandType> docTypeComboBox;
    protected JLabel docTypeLabel;
    protected JTextField ediErrorField;
    protected JLabel ediErrorLabel;
    protected JLabel firstOpenedByField;
    protected JLabel firstOpenedByLabel;
    protected JLabel firstOpenedLabel;
    protected JLabel firstOpeningDateField;
    protected JLabel firstOpeningDateLabel;
    protected final DemandeUIHandler handler = createHandler();
    protected ButtonHistory historyButton;
    protected JLabel lastAttachmentOpenedByField;
    protected JLabel lastAttachmentOpenedByLabel;
    protected JLabel lastAttachmentOpeningDateField;
    protected JLabel lastAttachmentOpeningDateLabel;
    protected JLabel lastAttachmentOpeningLabel;
    protected JPanel lastAttachmentOpeningPanel;
    protected JLabel lastModificationDateField;
    protected JLabel lastModificationDateLabel;
    protected JLabel lastModifiedByField;
    protected JLabel lastModifiedByLabel;
    protected JLabel lastModifiedLabel;
    protected JSplitPane leftVerticalSplitPanel;
    protected JTextPane mailBodyField;
    protected JScrollPane mailBodyPane;
    protected DemandeUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "object",  editorName = "objectField")
    protected JTextField objectField;
    protected JLabel objectLabel;
    protected JLabel pfNbField;
    protected JLabel pfNbLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "priority",  editorName = "priorityComboBox")
    protected BeanFilterableComboBox<Priority> priorityComboBox;
    protected JLabel priorityLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "projectReference",  editorName = "projectReferenceField")
    protected JTextField projectReferenceField;
    protected JLabel projectReferenceLabel;
    protected JLabel quotationNbField;
    protected JLabel quotationNbLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "validRangeRowModels",  editorName = "rangePanel")
    protected JPanel rangePanel;
    protected JXTable rangeTable;
    protected JLabel receivedDateField;
    protected JLabel receivedDateLabel;
    protected JSplitPane rightVerticalSplitPanel;
    protected JLabel savNbField;
    protected JLabel savNbLabel;
    protected JLabel senderField;
    protected JLabel senderLabel;
    protected BeanFilterableComboBox<DemandStatus> statusComboBox;
    protected JLabel statusField;
    protected JLabel statusLabel;
    protected JLabel subjectField;
    protected JLabel subjectLabel;
    protected JLabel takenByField;
    protected JLabel takenByLabel;
    protected JLabel toRecipientsField;
    protected JLabel toRecipientsLabel;
    protected JXTitledPanel toolbarContainer;
    protected JToolBar topToolBar;
    @Validator( validatorId = "validator")
    protected SwingValidator<DemandeUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    @ValidatorField( validatorId = "validator",  propertyName = "waitingState",  editorName = "waitingStateComboBox")
    protected BeanFilterableComboBox<WaitingState> waitingStateComboBox;
    protected JLabel waitingStateLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JPanel $JPanel3;
    private JPanel $JPanel4;
    private JPanel $JPanel5;
    private JScrollPane $JScrollPane0;
    private JSeparator $JSeparator0;
    private JSplitPane $JSplitPane0;
    private Table $Table0;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DemandeUI(FaxToMailUI parentUI, DemandeUIModel demand) {
        FaxToMailUIUtil.setParentUI(this, parentUI);
                setContextValue(demand);
            $initialize();
    }

    public DemandeUI() {
        $initialize();
    }

    public DemandeUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemandeUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandeUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemandeUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DemandeUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemandeUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public DemandeUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doKeyReleased__on__clientField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "clientCode");
    }

    public void doKeyReleased__on__commentField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "comment");
    }

    public void doKeyReleased__on__companyReferenceField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "companyReference");
    }

    public void doKeyReleased__on__objectField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "object");
    }

    public void doKeyReleased__on__projectReferenceField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "projectReference");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public ButtonAttachment getAttachmentsButton() {
        return attachmentsButton;
    }

    public JLabel getBrandField() {
        return brandField;
    }

    public JLabel getBrandLabel() {
        return brandLabel;
    }

    public JLabel getCcRecipientsField() {
        return ccRecipientsField;
    }

    public JLabel getCcRecipientsLabel() {
        return ccRecipientsLabel;
    }

    public JTextField getClientField() {
        return clientField;
    }

    public JLabel getClientLabel() {
        return clientLabel;
    }

    public JEditorPane getCommentField() {
        return commentField;
    }

    public JLabel getCommentLabel() {
        return commentLabel;
    }

    public JScrollPane getCommentPane() {
        return commentPane;
    }

    public JTextField getCompanyReferenceField() {
        return companyReferenceField;
    }

    public JLabel getCompanyReferenceLabel() {
        return companyReferenceLabel;
    }

    public JScrollPane getDemandForm() {
        return demandForm;
    }

    public ButtonDemandReplies getDemandRepliesButton() {
        return demandRepliesButton;
    }

    public BeanFilterableComboBox<DemandType> getDocTypeComboBox() {
        return docTypeComboBox;
    }

    public JLabel getDocTypeLabel() {
        return docTypeLabel;
    }

    public JTextField getEdiErrorField() {
        return ediErrorField;
    }

    public JLabel getEdiErrorLabel() {
        return ediErrorLabel;
    }

    public JLabel getFirstOpenedByField() {
        return firstOpenedByField;
    }

    public JLabel getFirstOpenedByLabel() {
        return firstOpenedByLabel;
    }

    public JLabel getFirstOpenedLabel() {
        return firstOpenedLabel;
    }

    public JLabel getFirstOpeningDateField() {
        return firstOpeningDateField;
    }

    public JLabel getFirstOpeningDateLabel() {
        return firstOpeningDateLabel;
    }

    public DemandeUIHandler getHandler() {
        return handler;
    }

    public ButtonHistory getHistoryButton() {
        return historyButton;
    }

    public JLabel getLastAttachmentOpenedByField() {
        return lastAttachmentOpenedByField;
    }

    public JLabel getLastAttachmentOpenedByLabel() {
        return lastAttachmentOpenedByLabel;
    }

    public JLabel getLastAttachmentOpeningDateField() {
        return lastAttachmentOpeningDateField;
    }

    public JLabel getLastAttachmentOpeningDateLabel() {
        return lastAttachmentOpeningDateLabel;
    }

    public JLabel getLastAttachmentOpeningLabel() {
        return lastAttachmentOpeningLabel;
    }

    public JPanel getLastAttachmentOpeningPanel() {
        return lastAttachmentOpeningPanel;
    }

    public JLabel getLastModificationDateField() {
        return lastModificationDateField;
    }

    public JLabel getLastModificationDateLabel() {
        return lastModificationDateLabel;
    }

    public JLabel getLastModifiedByField() {
        return lastModifiedByField;
    }

    public JLabel getLastModifiedByLabel() {
        return lastModifiedByLabel;
    }

    public JLabel getLastModifiedLabel() {
        return lastModifiedLabel;
    }

    public JSplitPane getLeftVerticalSplitPanel() {
        return leftVerticalSplitPanel;
    }

    public JTextPane getMailBodyField() {
        return mailBodyField;
    }

    public JScrollPane getMailBodyPane() {
        return mailBodyPane;
    }

    public DemandeUIModel getModel() {
        return model;
    }

    public JTextField getObjectField() {
        return objectField;
    }

    public JLabel getObjectLabel() {
        return objectLabel;
    }

    public JLabel getPfNbField() {
        return pfNbField;
    }

    public JLabel getPfNbLabel() {
        return pfNbLabel;
    }

    public BeanFilterableComboBox<Priority> getPriorityComboBox() {
        return priorityComboBox;
    }

    public JLabel getPriorityLabel() {
        return priorityLabel;
    }

    public JTextField getProjectReferenceField() {
        return projectReferenceField;
    }

    public JLabel getProjectReferenceLabel() {
        return projectReferenceLabel;
    }

    public JLabel getQuotationNbField() {
        return quotationNbField;
    }

    public JLabel getQuotationNbLabel() {
        return quotationNbLabel;
    }

    public JPanel getRangePanel() {
        return rangePanel;
    }

    public JXTable getRangeTable() {
        return rangeTable;
    }

    public JLabel getReceivedDateField() {
        return receivedDateField;
    }

    public JLabel getReceivedDateLabel() {
        return receivedDateLabel;
    }

    public JSplitPane getRightVerticalSplitPanel() {
        return rightVerticalSplitPanel;
    }

    public JLabel getSavNbField() {
        return savNbField;
    }

    public JLabel getSavNbLabel() {
        return savNbLabel;
    }

    public JLabel getSenderField() {
        return senderField;
    }

    public JLabel getSenderLabel() {
        return senderLabel;
    }

    public BeanFilterableComboBox<DemandStatus> getStatusComboBox() {
        return statusComboBox;
    }

    public JLabel getStatusField() {
        return statusField;
    }

    public JLabel getStatusLabel() {
        return statusLabel;
    }

    public JLabel getSubjectField() {
        return subjectField;
    }

    public JLabel getSubjectLabel() {
        return subjectLabel;
    }

    public JLabel getTakenByField() {
        return takenByField;
    }

    public JLabel getTakenByLabel() {
        return takenByLabel;
    }

    public JLabel getToRecipientsField() {
        return toRecipientsField;
    }

    public JLabel getToRecipientsLabel() {
        return toRecipientsLabel;
    }

    public JXTitledPanel getToolbarContainer() {
        return toolbarContainer;
    }

    public JToolBar getTopToolBar() {
        return topToolBar;
    }

    public SwingValidator<DemandeUIModel> getValidator() {
        return validator;
    }

    public BeanFilterableComboBox<WaitingState> getWaitingStateComboBox() {
        return waitingStateComboBox;
    }

    public JLabel getWaitingStateLabel() {
        return waitingStateLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected JPanel get$JPanel4() {
        return $JPanel4;
    }

    protected JPanel get$JPanel5() {
        return $JPanel5;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JSplitPane get$JSplitPane0() {
        return $JSplitPane0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCommentPane() {
        if (!allComponentsCreated) {
            return;
        }
        commentPane.getViewport().add(commentField);
    }

    protected void addChildrenToDemandForm() {
        if (!allComponentsCreated) {
            return;
        }
        demandForm.getViewport().add($Table0);
    }

    protected void addChildrenToDemandPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(topToolBar);
        add($JSplitPane0, BorderLayout.CENTER);
    }

    protected void addChildrenToLastAttachmentOpeningPanel() {
        if (!allComponentsCreated) {
            return;
        }
        lastAttachmentOpeningPanel.add(lastAttachmentOpeningLabel);
        lastAttachmentOpeningPanel.add(lastAttachmentOpenedByLabel);
        lastAttachmentOpeningPanel.add(lastAttachmentOpenedByField);
        lastAttachmentOpeningPanel.add(lastAttachmentOpeningDateLabel);
        lastAttachmentOpeningPanel.add(lastAttachmentOpeningDateField);
    }

    protected void addChildrenToLeftVerticalSplitPanel() {
        if (!allComponentsCreated) {
            return;
        }
        leftVerticalSplitPanel.add(demandForm, JSplitPane.LEFT);
        leftVerticalSplitPanel.add(SwingUtil.boxComponentWithJxLayer(rangePanel), JSplitPane.RIGHT);
    }

    protected void addChildrenToMailBodyPane() {
        if (!allComponentsCreated) {
            return;
        }
        mailBodyPane.getViewport().add(mailBodyField);
    }

    protected void addChildrenToRangePanel() {
        if (!allComponentsCreated) {
            return;
        }
        rangePanel.add($JPanel3, BorderLayout.NORTH);
        rangePanel.add($JScrollPane0, BorderLayout.CENTER);
        rangePanel.add($JPanel4, BorderLayout.SOUTH);
    }

    protected void addChildrenToRightVerticalSplitPanel() {
        if (!allComponentsCreated) {
            return;
        }
        rightVerticalSplitPanel.add($Table1, JSplitPane.LEFT);
        rightVerticalSplitPanel.add($JPanel5, JSplitPane.RIGHT);
    }

    protected void addChildrenToToolbarContainer() {
        if (!allComponentsCreated) {
            return;
        }
        toolbarContainer.add(rightVerticalSplitPanel);
    }

    protected void addChildrenToTopToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        topToolBar.add(demandRepliesButton);
        topToolBar.add(historyButton);
        topToolBar.add(attachmentsButton);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAttachmentsButton() {
        $objectMap.put("attachmentsButton", attachmentsButton = new ButtonAttachment(model));
        
        attachmentsButton.setName("attachmentsButton");
    }

    protected void createBrandField() {
        $objectMap.put("brandField", brandField = new JLabel());
        
        brandField.setName("brandField");
    }

    protected void createBrandLabel() {
        $objectMap.put("brandLabel", brandLabel = new JLabel());
        
        brandLabel.setName("brandLabel");
        brandLabel.setText(t("faxtomail.demande.clientBrand.label"));
    }

    protected void createCcRecipientsField() {
        $objectMap.put("ccRecipientsField", ccRecipientsField = new JLabel());
        
        ccRecipientsField.setName("ccRecipientsField");
    }

    protected void createCcRecipientsLabel() {
        $objectMap.put("ccRecipientsLabel", ccRecipientsLabel = new JLabel());
        
        ccRecipientsLabel.setName("ccRecipientsLabel");
        ccRecipientsLabel.setText(t("faxtomail.demande.ccRecipients.label"));
    }

    protected void createClientField() {
        $objectMap.put("clientField", clientField = new JTextField());
        
        clientField.setName("clientField");
        clientField.setColumns(15);
        clientField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__clientField"));
        clientField.putClientProperty("validatorLabel",  t("faxtomail.demande.clientCode.label") );
    }

    protected void createClientLabel() {
        $objectMap.put("clientLabel", clientLabel = new JLabel());
        
        clientLabel.setName("clientLabel");
        clientLabel.setText(t("faxtomail.demande.clientCode.label"));
    }

    protected void createCommentField() {
        $objectMap.put("commentField", commentField = new JEditorPane());
        
        commentField.setName("commentField");
        commentField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commentField"));
        commentField.putClientProperty("validatorLabel",  t("faxtomail.demande.comment.label") );
    }

    protected void createCommentLabel() {
        $objectMap.put("commentLabel", commentLabel = new JLabel());
        
        commentLabel.setName("commentLabel");
        commentLabel.setText(t("faxtomail.demande.comment.label"));
    }

    protected void createCommentPane() {
        $objectMap.put("commentPane", commentPane = new JScrollPane());
        
        commentPane.setName("commentPane");
    }

    protected void createCompanyReferenceField() {
        $objectMap.put("companyReferenceField", companyReferenceField = new JTextField());
        
        companyReferenceField.setName("companyReferenceField");
        companyReferenceField.setColumns(15);
        companyReferenceField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__companyReferenceField"));
        companyReferenceField.putClientProperty("validatorLabel",  t("faxtomail.demande.companyReference.label") );
    }

    protected void createCompanyReferenceLabel() {
        $objectMap.put("companyReferenceLabel", companyReferenceLabel = new JLabel());
        
        companyReferenceLabel.setName("companyReferenceLabel");
        companyReferenceLabel.setText(t("faxtomail.demande.companyReference.label"));
    }

    protected void createDemandForm() {
        $objectMap.put("demandForm", demandForm = new JScrollPane());
        
        demandForm.setName("demandForm");
    }

    protected void createDemandRepliesButton() {
        $objectMap.put("demandRepliesButton", demandRepliesButton = new ButtonDemandReplies(model));
        
        demandRepliesButton.setName("demandRepliesButton");
    }

    protected void createDocTypeComboBox() {
        $objectMap.put("docTypeComboBox", docTypeComboBox = new BeanFilterableComboBox<DemandType>(this));
        
        docTypeComboBox.setName("docTypeComboBox");
        docTypeComboBox.setMaximumRowCount(20);
        docTypeComboBox.setShowDecorator(false);
        docTypeComboBox.setProperty("demandType");
        docTypeComboBox.setShowReset(false);
        docTypeComboBox.putClientProperty("validatorLabel",  t("faxtomail.demande.demandType.label") );
    }

    protected void createDocTypeLabel() {
        $objectMap.put("docTypeLabel", docTypeLabel = new JLabel());
        
        docTypeLabel.setName("docTypeLabel");
        docTypeLabel.setText(t("faxtomail.demande.demandType.label"));
    }

    protected void createEdiErrorField() {
        $objectMap.put("ediErrorField", ediErrorField = new JTextField());
        
        ediErrorField.setName("ediErrorField");
        ediErrorField.setColumns(15);
        ediErrorField.setEditable(false);
    }

    protected void createEdiErrorLabel() {
        $objectMap.put("ediErrorLabel", ediErrorLabel = new JLabel());
        
        ediErrorLabel.setName("ediErrorLabel");
        ediErrorLabel.setText(t("faxtomail.demande.ediError.label"));
    }

    protected void createFirstOpenedByField() {
        $objectMap.put("firstOpenedByField", firstOpenedByField = new JLabel());
        
        firstOpenedByField.setName("firstOpenedByField");
    }

    protected void createFirstOpenedByLabel() {
        $objectMap.put("firstOpenedByLabel", firstOpenedByLabel = new JLabel());
        
        firstOpenedByLabel.setName("firstOpenedByLabel");
        firstOpenedByLabel.setText(t("faxtomail.common.by.label"));
    }

    protected void createFirstOpenedLabel() {
        $objectMap.put("firstOpenedLabel", firstOpenedLabel = new JLabel());
        
        firstOpenedLabel.setName("firstOpenedLabel");
        firstOpenedLabel.setText(t("faxtomail.demande.firstOpened.label"));
    }

    protected void createFirstOpeningDateField() {
        $objectMap.put("firstOpeningDateField", firstOpeningDateField = new JLabel());
        
        firstOpeningDateField.setName("firstOpeningDateField");
    }

    protected void createFirstOpeningDateLabel() {
        $objectMap.put("firstOpeningDateLabel", firstOpeningDateLabel = new JLabel());
        
        firstOpeningDateLabel.setName("firstOpeningDateLabel");
        firstOpeningDateLabel.setText(t("faxtomail.common.on.label"));
    }

    protected DemandeUIHandler createHandler() {
        return new DemandeUIHandler();
    }

    protected void createHistoryButton() {
        $objectMap.put("historyButton", historyButton = new ButtonHistory(model));
        
        historyButton.setName("historyButton");
    }

    protected void createLastAttachmentOpenedByField() {
        $objectMap.put("lastAttachmentOpenedByField", lastAttachmentOpenedByField = new JLabel());
        
        lastAttachmentOpenedByField.setName("lastAttachmentOpenedByField");
    }

    protected void createLastAttachmentOpenedByLabel() {
        $objectMap.put("lastAttachmentOpenedByLabel", lastAttachmentOpenedByLabel = new JLabel());
        
        lastAttachmentOpenedByLabel.setName("lastAttachmentOpenedByLabel");
        lastAttachmentOpenedByLabel.setText(t("faxtomail.common.by.label"));
    }

    protected void createLastAttachmentOpeningDateField() {
        $objectMap.put("lastAttachmentOpeningDateField", lastAttachmentOpeningDateField = new JLabel());
        
        lastAttachmentOpeningDateField.setName("lastAttachmentOpeningDateField");
    }

    protected void createLastAttachmentOpeningDateLabel() {
        $objectMap.put("lastAttachmentOpeningDateLabel", lastAttachmentOpeningDateLabel = new JLabel());
        
        lastAttachmentOpeningDateLabel.setName("lastAttachmentOpeningDateLabel");
        lastAttachmentOpeningDateLabel.setText(t("faxtomail.common.on.label"));
    }

    protected void createLastAttachmentOpeningLabel() {
        $objectMap.put("lastAttachmentOpeningLabel", lastAttachmentOpeningLabel = new JLabel());
        
        lastAttachmentOpeningLabel.setName("lastAttachmentOpeningLabel");
        lastAttachmentOpeningLabel.setText(t("faxtomail.demande.lastAttachmentOpening.label"));
    }

    protected void createLastAttachmentOpeningPanel() {
        $objectMap.put("lastAttachmentOpeningPanel", lastAttachmentOpeningPanel = new JPanel());
        
        lastAttachmentOpeningPanel.setName("lastAttachmentOpeningPanel");
        lastAttachmentOpeningPanel.setLayout( new FlowLayout(FlowLayout.LEADING) );
    }

    protected void createLastModificationDateField() {
        $objectMap.put("lastModificationDateField", lastModificationDateField = new JLabel());
        
        lastModificationDateField.setName("lastModificationDateField");
    }

    protected void createLastModificationDateLabel() {
        $objectMap.put("lastModificationDateLabel", lastModificationDateLabel = new JLabel());
        
        lastModificationDateLabel.setName("lastModificationDateLabel");
        lastModificationDateLabel.setText(t("faxtomail.common.on.label"));
    }

    protected void createLastModifiedByField() {
        $objectMap.put("lastModifiedByField", lastModifiedByField = new JLabel());
        
        lastModifiedByField.setName("lastModifiedByField");
    }

    protected void createLastModifiedByLabel() {
        $objectMap.put("lastModifiedByLabel", lastModifiedByLabel = new JLabel());
        
        lastModifiedByLabel.setName("lastModifiedByLabel");
        lastModifiedByLabel.setText(t("faxtomail.common.by.label"));
    }

    protected void createLastModifiedLabel() {
        $objectMap.put("lastModifiedLabel", lastModifiedLabel = new JLabel());
        
        lastModifiedLabel.setName("lastModifiedLabel");
        lastModifiedLabel.setText(t("faxtomail.demande.lastModified.label"));
    }

    protected void createLeftVerticalSplitPanel() {
        $objectMap.put("leftVerticalSplitPanel", leftVerticalSplitPanel = new JSplitPane());
        
        leftVerticalSplitPanel.setName("leftVerticalSplitPanel");
        leftVerticalSplitPanel.setResizeWeight(0.8);
    }

    protected void createMailBodyField() {
        $objectMap.put("mailBodyField", mailBodyField = new JTextPane());
        
        mailBodyField.setName("mailBodyField");
        mailBodyField.setEditable(false);
    }

    protected void createMailBodyPane() {
        $objectMap.put("mailBodyPane", mailBodyPane = new JScrollPane());
        
        mailBodyPane.setName("mailBodyPane");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(DemandeUIModel.class));
    }

    protected void createObjectField() {
        $objectMap.put("objectField", objectField = new JTextField());
        
        objectField.setName("objectField");
        objectField.setColumns(15);
        objectField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__objectField"));
        objectField.putClientProperty("validatorLabel",  t("faxtomail.demande.object.label") );
    }

    protected void createObjectLabel() {
        $objectMap.put("objectLabel", objectLabel = new JLabel());
        
        objectLabel.setName("objectLabel");
        objectLabel.setText(t("faxtomail.demande.object.label"));
    }

    protected void createPfNbField() {
        $objectMap.put("pfNbField", pfNbField = new JLabel());
        
        pfNbField.setName("pfNbField");
    }

    protected void createPfNbLabel() {
        $objectMap.put("pfNbLabel", pfNbLabel = new JLabel());
        
        pfNbLabel.setName("pfNbLabel");
        pfNbLabel.setText(t("faxtomail.demandeList.pfNbLabel"));
        if (pfNbLabel.getFont() != null) {
            pfNbLabel.setFont(pfNbLabel.getFont().deriveFont(pfNbLabel.getFont().getStyle() | Font.ITALIC));
        }
    }

    protected void createPriorityComboBox() {
        $objectMap.put("priorityComboBox", priorityComboBox = new BeanFilterableComboBox<Priority>(this));
        
        priorityComboBox.setName("priorityComboBox");
        priorityComboBox.setMaximumRowCount(20);
        priorityComboBox.setShowDecorator(false);
        priorityComboBox.setProperty("priority");
        priorityComboBox.setShowReset(true);
        priorityComboBox.putClientProperty("validatorLabel",  t("faxtomail.demande.priority.label") );
    }

    protected void createPriorityLabel() {
        $objectMap.put("priorityLabel", priorityLabel = new JLabel());
        
        priorityLabel.setName("priorityLabel");
        priorityLabel.setText(t("faxtomail.demande.priority.label"));
    }

    protected void createProjectReferenceField() {
        $objectMap.put("projectReferenceField", projectReferenceField = new JTextField());
        
        projectReferenceField.setName("projectReferenceField");
        projectReferenceField.setColumns(15);
        projectReferenceField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__projectReferenceField"));
        projectReferenceField.putClientProperty("validatorLabel",  t("faxtomail.demande.projectReference.label") );
    }

    protected void createProjectReferenceLabel() {
        $objectMap.put("projectReferenceLabel", projectReferenceLabel = new JLabel());
        
        projectReferenceLabel.setName("projectReferenceLabel");
        projectReferenceLabel.setText(t("faxtomail.demande.projectReference.label"));
    }

    protected void createQuotationNbField() {
        $objectMap.put("quotationNbField", quotationNbField = new JLabel());
        
        quotationNbField.setName("quotationNbField");
    }

    protected void createQuotationNbLabel() {
        $objectMap.put("quotationNbLabel", quotationNbLabel = new JLabel());
        
        quotationNbLabel.setName("quotationNbLabel");
        quotationNbLabel.setText(t("faxtomail.demandeList.quotationNbLabel"));
        if (quotationNbLabel.getFont() != null) {
            quotationNbLabel.setFont(quotationNbLabel.getFont().deriveFont(quotationNbLabel.getFont().getStyle() | Font.ITALIC));
        }
    }

    protected void createRangePanel() {
        $objectMap.put("rangePanel", rangePanel = new JPanel());
        
        rangePanel.setName("rangePanel");
        rangePanel.setLayout(new BorderLayout());
        rangePanel.putClientProperty("validatorLabel",  t("faxtomail.demande.rangeRow.label") );
    }

    protected void createRangeTable() {
        $objectMap.put("rangeTable", rangeTable = new JXTable());
        
        rangeTable.setName("rangeTable");
    }

    protected void createReceivedDateField() {
        $objectMap.put("receivedDateField", receivedDateField = new JLabel());
        
        receivedDateField.setName("receivedDateField");
    }

    protected void createReceivedDateLabel() {
        $objectMap.put("receivedDateLabel", receivedDateLabel = new JLabel());
        
        receivedDateLabel.setName("receivedDateLabel");
        receivedDateLabel.setText(t("faxtomail.demande.receivedDate.label"));
    }

    protected void createRightVerticalSplitPanel() {
        $objectMap.put("rightVerticalSplitPanel", rightVerticalSplitPanel = new JSplitPane());
        
        rightVerticalSplitPanel.setName("rightVerticalSplitPanel");
        rightVerticalSplitPanel.setResizeWeight(0.8);
    }

    protected void createSavNbField() {
        $objectMap.put("savNbField", savNbField = new JLabel());
        
        savNbField.setName("savNbField");
    }

    protected void createSavNbLabel() {
        $objectMap.put("savNbLabel", savNbLabel = new JLabel());
        
        savNbLabel.setName("savNbLabel");
        savNbLabel.setText(t("faxtomail.demandeList.savNbLabel"));
        if (savNbLabel.getFont() != null) {
            savNbLabel.setFont(savNbLabel.getFont().deriveFont(savNbLabel.getFont().getStyle() | Font.ITALIC));
        }
    }

    protected void createSenderField() {
        $objectMap.put("senderField", senderField = new JLabel());
        
        senderField.setName("senderField");
    }

    protected void createSenderLabel() {
        $objectMap.put("senderLabel", senderLabel = new JLabel());
        
        senderLabel.setName("senderLabel");
        senderLabel.setText(t("faxtomail.demande.sender.label"));
    }

    protected void createStatusComboBox() {
        $objectMap.put("statusComboBox", statusComboBox = new BeanFilterableComboBox<DemandStatus>(this));
        
        statusComboBox.setName("statusComboBox");
        statusComboBox.setMaximumRowCount(20);
        statusComboBox.setShowDecorator(false);
        statusComboBox.setProperty("demandStatus");
        statusComboBox.setShowReset(false);
    }

    protected void createStatusField() {
        $objectMap.put("statusField", statusField = new JLabel());
        
        statusField.setName("statusField");
    }

    protected void createStatusLabel() {
        $objectMap.put("statusLabel", statusLabel = new JLabel());
        
        statusLabel.setName("statusLabel");
        statusLabel.setText(t("faxtomail.demande.demandStatus.label"));
    }

    protected void createSubjectField() {
        $objectMap.put("subjectField", subjectField = new JLabel());
        
        subjectField.setName("subjectField");
    }

    protected void createSubjectLabel() {
        $objectMap.put("subjectLabel", subjectLabel = new JLabel());
        
        subjectLabel.setName("subjectLabel");
        subjectLabel.setText(t("faxtomail.demande.subject.label"));
    }

    protected void createTakenByField() {
        $objectMap.put("takenByField", takenByField = new JLabel());
        
        takenByField.setName("takenByField");
    }

    protected void createTakenByLabel() {
        $objectMap.put("takenByLabel", takenByLabel = new JLabel());
        
        takenByLabel.setName("takenByLabel");
        takenByLabel.setText(t("faxtomail.demande.takenBy.label"));
    }

    protected void createToRecipientsField() {
        $objectMap.put("toRecipientsField", toRecipientsField = new JLabel());
        
        toRecipientsField.setName("toRecipientsField");
    }

    protected void createToRecipientsLabel() {
        $objectMap.put("toRecipientsLabel", toRecipientsLabel = new JLabel());
        
        toRecipientsLabel.setName("toRecipientsLabel");
        toRecipientsLabel.setText(t("faxtomail.demande.toRecipients.label"));
    }

    protected void createToolbarContainer() {
        $objectMap.put("toolbarContainer", toolbarContainer = new JXTitledPanel());
        
        toolbarContainer.setName("toolbarContainer");
    }

    protected void createTopToolBar() {
        $objectMap.put("topToolBar", topToolBar = new JToolBar());
        
        topToolBar.setName("topToolBar");
        topToolBar.setFloatable(false);
        topToolBar.setOpaque(false);
        topToolBar.setBorderPainted(false);
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(DemandeUIModel.class, null));
    }

    protected void createWaitingStateComboBox() {
        $objectMap.put("waitingStateComboBox", waitingStateComboBox = new BeanFilterableComboBox<WaitingState>(this));
        
        waitingStateComboBox.setName("waitingStateComboBox");
        waitingStateComboBox.setMaximumRowCount(20);
        waitingStateComboBox.setShowDecorator(false);
        waitingStateComboBox.setProperty("waitingState");
        waitingStateComboBox.setShowReset(true);
        waitingStateComboBox.putClientProperty("validatorLabel",  t("faxtomail.demande.waitingState.label") );
    }

    protected void createWaitingStateLabel() {
        $objectMap.put("waitingStateLabel", waitingStateLabel = new JLabel());
        
        waitingStateLabel.setName("waitingStateLabel");
        waitingStateLabel.setText(t("faxtomail.demande.waitingState.label"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToDemandPanel();
        addChildrenToValidator();
        addChildrenToTopToolBar();
        // inline complete setup of $JSplitPane0
        $JSplitPane0.add(leftVerticalSplitPanel, JSplitPane.LEFT);
        $JSplitPane0.add(toolbarContainer, JSplitPane.RIGHT);
        addChildrenToLeftVerticalSplitPanel();
        addChildrenToDemandForm();
        // inline complete setup of $Table0
        $Table0.add(receivedDateLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(receivedDateField, new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(senderLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(senderField, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(objectLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(objectField), new GridBagConstraints(1, 2, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(clientLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(clientField), new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(brandLabel, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(brandField, new GridBagConstraints(3, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(docTypeLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(docTypeComboBox), new GridBagConstraints(1, 4, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(priorityLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(priorityComboBox), new GridBagConstraints(1, 5, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(projectReferenceLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(projectReferenceField), new GridBagConstraints(1, 6, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(companyReferenceLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(companyReferenceField), new GridBagConstraints(1, 7, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(waitingStateLabel, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(waitingStateComboBox), new GridBagConstraints(1, 8, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(statusLabel, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(1, 9, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(takenByLabel, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(takenByField, new GridBagConstraints(1, 10, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JSeparator0, new GridBagConstraints(0, 11, 4, 1, 0.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(0, 12, 4, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(0, 13, 4, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(lastAttachmentOpeningPanel, new GridBagConstraints(0, 14, 4, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(statusField, BorderLayout.NORTH);
        $JPanel0.add(statusComboBox, BorderLayout.SOUTH);
        // inline complete setup of $JPanel1
        $JPanel1.add(firstOpenedLabel);
        $JPanel1.add(firstOpenedByLabel);
        $JPanel1.add(firstOpenedByField);
        $JPanel1.add(firstOpeningDateLabel);
        $JPanel1.add(firstOpeningDateField);
        // inline complete setup of $JPanel2
        $JPanel2.add(lastModifiedLabel);
        $JPanel2.add(lastModifiedByLabel);
        $JPanel2.add(lastModifiedByField);
        $JPanel2.add(lastModificationDateLabel);
        $JPanel2.add(lastModificationDateField);
        addChildrenToLastAttachmentOpeningPanel();
        addChildrenToRangePanel();
        // inline complete setup of $JPanel3
        $JPanel3.add(ediErrorLabel);
        $JPanel3.add(ediErrorField);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(rangeTable);
        // inline complete setup of $JPanel4
        $JPanel4.add(quotationNbLabel);
        $JPanel4.add(quotationNbField);
        $JPanel4.add($JLabel0);
        $JPanel4.add(pfNbLabel);
        $JPanel4.add(pfNbField);
        $JPanel4.add($JLabel1);
        $JPanel4.add(savNbLabel);
        $JPanel4.add(savNbField);
        addChildrenToToolbarContainer();
        addChildrenToRightVerticalSplitPanel();
        // inline complete setup of $Table1
        $Table1.add(toRecipientsLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(toRecipientsField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(ccRecipientsLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(ccRecipientsField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(subjectLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(subjectField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(mailBodyPane, new GridBagConstraints(0, 3, 2, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToMailBodyPane();
        // inline complete setup of $JPanel5
        $JPanel5.add(commentLabel, BorderLayout.NORTH);
        $JPanel5.add(SwingUtil.boxComponentWithJxLayer(commentPane), BorderLayout.CENTER);
        addChildrenToCommentPane();
        
        // apply 50 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 25 property setters
        $JSplitPane0.setOrientation(JSplitPane.HORIZONTAL_SPLIT);
        leftVerticalSplitPanel.setOrientation(JSplitPane.VERTICAL_SPLIT);
        docTypeComboBox.setBeanType(DemandType.class);
        priorityComboBox.setBeanType(Priority.class);
        waitingStateComboBox.setBeanType(WaitingState.class);
        statusComboBox.setBeanType(DemandStatus.class);
        rightVerticalSplitPanel.setOrientation(JSplitPane.VERTICAL_SPLIT);
        docTypeComboBox.setBean(model);
        priorityComboBox.setBean(model);
        waitingStateComboBox.setBean(model);
        statusComboBox.setBean(model);
        ediErrorLabel.setForeground( Color.RED );
        ediErrorField.setForeground( Color.RED );
        rangeTable.setSelectionMode( ListSelectionModel.SINGLE_SELECTION );
        toolbarContainer.setRightDecoration( topToolBar );
        commentLabel.setVerticalAlignment( SwingConstants.TOP );
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("demandPanel", demandPanel);
        createModel();
        createValidator();
        createTopToolBar();
        createDemandRepliesButton();
        createHistoryButton();
        createAttachmentsButton();
        // inline creation of $JSplitPane0
        $objectMap.put("$JSplitPane0", $JSplitPane0 = new JSplitPane());
        
        $JSplitPane0.setName("$JSplitPane0");
        createLeftVerticalSplitPanel();
        createDemandForm();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createReceivedDateLabel();
        createReceivedDateField();
        createSenderLabel();
        createSenderField();
        createObjectLabel();
        createObjectField();
        createClientLabel();
        createClientField();
        createBrandLabel();
        createBrandField();
        createDocTypeLabel();
        createDocTypeComboBox();
        createPriorityLabel();
        createPriorityComboBox();
        createProjectReferenceLabel();
        createProjectReferenceField();
        createCompanyReferenceLabel();
        createCompanyReferenceField();
        createWaitingStateLabel();
        createWaitingStateComboBox();
        createStatusLabel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createStatusField();
        createStatusComboBox();
        createTakenByLabel();
        createTakenByField();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout( new FlowLayout(FlowLayout.LEADING) );
        createFirstOpenedLabel();
        createFirstOpenedByLabel();
        createFirstOpenedByField();
        createFirstOpeningDateLabel();
        createFirstOpeningDateField();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout( new FlowLayout(FlowLayout.LEADING) );
        createLastModifiedLabel();
        createLastModifiedByLabel();
        createLastModifiedByField();
        createLastModificationDateLabel();
        createLastModificationDateField();
        createLastAttachmentOpeningPanel();
        createLastAttachmentOpeningLabel();
        createLastAttachmentOpenedByLabel();
        createLastAttachmentOpenedByField();
        createLastAttachmentOpeningDateLabel();
        createLastAttachmentOpeningDateField();
        createRangePanel();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        $JPanel3.setLayout(new FlowLayout(FlowLayout.LEADING));
        createEdiErrorLabel();
        createEdiErrorField();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createRangeTable();
        // inline creation of $JPanel4
        $objectMap.put("$JPanel4", $JPanel4 = new JPanel());
        
        $JPanel4.setName("$JPanel4");
        $JPanel4.setLayout(new FlowLayout(FlowLayout.LEADING));
        createQuotationNbLabel();
        createQuotationNbField();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(t(" | "));
        createPfNbLabel();
        createPfNbField();
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(t(" | "));
        createSavNbLabel();
        createSavNbField();
        createToolbarContainer();
        createRightVerticalSplitPanel();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createToRecipientsLabel();
        createToRecipientsField();
        createCcRecipientsLabel();
        createCcRecipientsField();
        createSubjectLabel();
        createSubjectField();
        createMailBodyPane();
        createMailBodyField();
        // inline creation of $JPanel5
        $objectMap.put("$JPanel5", $JPanel5 = new JPanel());
        
        $JPanel5.setName("$JPanel5");
        $JPanel5.setLayout(new BorderLayout());
        createCommentLabel();
        createCommentPane();
        createCommentField();
        // inline creation of demandPanel
        setName("demandPanel");
        setLayout(new BorderLayout());
        
        // registers 50 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 50 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DEMAND_REPLIES_BUTTON_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    demandRepliesButton.setEditable( model.isEditable()  );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ATTACHMENTS_BUTTON_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    attachmentsButton.setEditable( model.isEditable()  );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LEFT_VERTICAL_SPLIT_PANEL_DIVIDER_SIZE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("demandType", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    leftVerticalSplitPanel.setDividerSize( FaxToMailUIUtil.isRangePanelVisible(model.getDemandType()) ? 10 : 0 );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("demandType", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RECEIVED_DATE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("receptionDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    receivedDateField.setText(t( handler.decorate(model.getReceptionDate()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("receptionDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SENDER_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("sender", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    senderField.setText(t( model.getSender() ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("sender", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_OBJECT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("object", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(objectField, model.getObject());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("object", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_OBJECT_FIELD_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    objectField.setEditable( model.isEditable()  );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLIENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("clientCode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(clientField,  model.getClientCode() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("clientCode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CLIENT_FIELD_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    clientField.setEditable( model.isEditable()  );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BRAND_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("clientBrand", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    brandField.setText(t(model.getClientBrand()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("clientBrand", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOC_TYPE_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    docTypeComboBox.setEnabled( model.isEditable() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOC_TYPE_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("demandType", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    docTypeComboBox.setSelectedItem( model.getDemandType() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("demandType", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOC_TYPE_COMBO_BOX_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    docTypeComboBox.setEditable( model.isEditable()  );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PRIORITY_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    priorityComboBox.setEnabled( model.isEditable() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PRIORITY_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("priority", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    priorityComboBox.setSelectedItem( model.getPriority() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("priority", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PRIORITY_COMBO_BOX_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    priorityComboBox.setEditable( model.isEditable()  );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROJECT_REFERENCE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("projectReference", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(projectReferenceField,  model.getProjectReference() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("projectReference", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROJECT_REFERENCE_FIELD_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    projectReferenceField.setEditable( model.isEditable()  );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMPANY_REFERENCE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("companyReference", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(companyReferenceField,  model.getCompanyReference() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("companyReference", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMPANY_REFERENCE_FIELD_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    companyReferenceField.setEditable( model.isEditable()  );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_WAITING_STATE_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    waitingStateComboBox.setEnabled( model.isEditable() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_WAITING_STATE_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("waitingState", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    waitingStateComboBox.setSelectedItem( model.getWaitingState() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("waitingState", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_WAITING_STATE_COMBO_BOX_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    waitingStateComboBox.setEditable( model.isEditable()  );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STATUS_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("demandStatus", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getDemandStatus() != null) {
                    statusField.setText(t( model.getDemandStatus().getLabel() ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("demandStatus", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STATUS_FIELD_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("topiaId", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    statusField.setVisible( model.getTopiaId() != null );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("topiaId", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STATUS_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    statusComboBox.setEnabled( model.isEditable() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STATUS_COMBO_BOX_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("topiaId", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    statusComboBox.setVisible( model.getTopiaId() == null );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("topiaId", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STATUS_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("demandStatus", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    statusComboBox.setSelectedItem( model.getDemandStatus() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("demandStatus", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STATUS_COMBO_BOX_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    statusComboBox.setEditable( model.isEditable()  );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TAKEN_BY_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("takenBy", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    takenByField.setText(t( handler.decorateUser(model.getTakenBy(), false) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("takenBy", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIRST_OPENED_BY_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("firstOpeningUser", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    firstOpenedByField.setText(t( handler.decorateUser(model.getFirstOpeningUser(), false) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("firstOpeningUser", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FIRST_OPENING_DATE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("firstOpeningDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    firstOpeningDateField.setText(t( handler.decorate(model.getFirstOpeningDate()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("firstOpeningDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LAST_MODIFIED_BY_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lastModificationUser", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lastModifiedByField.setText(t( handler.decorateUser(model.getLastModificationUser(), true) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lastModificationUser", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LAST_MODIFICATION_DATE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lastModificationDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lastModificationDateField.setText(t( handler.decorate(model.getLastModificationDate()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lastModificationDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LAST_ATTACHMENT_OPENING_PANEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lastAttachmentOpeningInFolderUser", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lastAttachmentOpeningPanel.setVisible( model.getLastAttachmentOpeningInFolderUser() != null );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lastAttachmentOpeningInFolderUser", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LAST_ATTACHMENT_OPENED_BY_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lastAttachmentOpeningInFolderUser", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lastAttachmentOpenedByField.setText(t( handler.decorateUser(model.getLastAttachmentOpeningInFolderUser(), true) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lastAttachmentOpeningInFolderUser", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LAST_ATTACHMENT_OPENING_DATE_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lastAttachmentOpeningInFolderDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lastAttachmentOpeningDateField.setText(t( handler.decorate(model.getLastAttachmentOpeningInFolderDate()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lastAttachmentOpeningInFolderDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RANGE_PANEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("demandType", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    rangePanel.setVisible( FaxToMailUIUtil.isRangePanelVisible(model.getDemandType()) );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("demandType", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDI_ERROR_LABEL_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("ediError", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    ediErrorLabel.setVisible( model.getEdiError() != null );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("ediError", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDI_ERROR_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("ediError", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(ediErrorField,  model.getEdiError() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("ediError", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDI_ERROR_FIELD_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("ediError", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    ediErrorField.setVisible( model.getEdiError() != null );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("ediError", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RANGE_TABLE_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    rangeTable.setEditable( model.isEditable()  );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_QUOTATION_NB_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("quotationNb", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    quotationNbField.setText(t( String.valueOf(model.getQuotationNb()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("quotationNb", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PF_NB_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("pfNb", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    pfNbField.setText(t( String.valueOf(model.getPfNb()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("pfNb", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAV_NB_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("savNb", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    savNbField.setText(t( String.valueOf(model.getSavNb()) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("savNb", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TO_RECIPIENTS_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("toRecipients", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    toRecipientsField.setText(t(model.getToRecipients()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("toRecipients", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CC_RECIPIENTS_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("ccRecipients", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    ccRecipientsField.setText(t(model.getCcRecipients()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("ccRecipients", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SUBJECT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("subject", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    subjectField.setText(t(model.getSubject()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("subject", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(commentField,  model.getComment() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_EDITABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("editable", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    commentField.setEditable( model.isEditable()  );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("editable", this);
                }
            }
        });
    }

}