/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDNameTreeNode
implements COSObjectable {
    private static final Log LOG = LogFactory.getLog(PDNameTreeNode.class);
    private COSDictionary node;
    private Class<? extends COSObjectable> valueType = null;
    private PDNameTreeNode parent = null;

    public PDNameTreeNode(Class<? extends COSObjectable> valueClass) {
        this.node = new COSDictionary();
        this.valueType = valueClass;
    }

    public PDNameTreeNode(COSDictionary dict, Class<? extends COSObjectable> valueClass) {
        this.node = dict;
        this.valueType = valueClass;
    }

    @Override
    public COSBase getCOSObject() {
        return this.node;
    }

    public COSDictionary getCOSDictionary() {
        return this.node;
    }

    public PDNameTreeNode getParent() {
        return this.parent;
    }

    public void setParent(PDNameTreeNode parentNode) {
        this.parent = parentNode;
        this.calculateLimits();
    }

    public boolean isRootNode() {
        return this.parent == null;
    }

    public List<PDNameTreeNode> getKids() {
        COSArrayList retval = null;
        COSArray kids = (COSArray)this.node.getDictionaryObject(COSName.KIDS);
        if (kids != null) {
            ArrayList<PDNameTreeNode> pdObjects = new ArrayList<PDNameTreeNode>();
            for (int i = 0; i < kids.size(); ++i) {
                pdObjects.add(this.createChildNode((COSDictionary)kids.getObject(i)));
            }
            retval = new COSArrayList(pdObjects, kids);
        }
        return retval;
    }

    public void setKids(List<? extends PDNameTreeNode> kids) {
        if (kids != null && kids.size() > 0) {
            for (PDNameTreeNode pDNameTreeNode : kids) {
                pDNameTreeNode.setParent(this);
            }
            this.node.setItem(COSName.KIDS, (COSBase)COSArrayList.converterToCOSArray(kids));
            if (this.isRootNode()) {
                this.node.setItem(COSName.NAMES, null);
            }
        } else {
            this.node.setItem(COSName.KIDS, null);
            this.node.setItem(COSName.LIMITS, null);
        }
        this.calculateLimits();
    }

    private void calculateLimits() {
        if (this.isRootNode()) {
            this.node.setItem(COSName.LIMITS, null);
        } else {
            List<PDNameTreeNode> kids = this.getKids();
            if (kids != null && kids.size() > 0) {
                PDNameTreeNode firstKid = kids.get(0);
                PDNameTreeNode lastKid = kids.get(kids.size() - 1);
                String lowerLimit = firstKid.getLowerLimit();
                this.setLowerLimit(lowerLimit);
                String upperLimit = lastKid.getUpperLimit();
                this.setUpperLimit(upperLimit);
            } else {
                try {
                    Map<String, COSObjectable> names = this.getNames();
                    if (names != null && names.size() > 0) {
                        Object[] keys = names.keySet().toArray();
                        String lowerLimit = (String)keys[0];
                        this.setLowerLimit(lowerLimit);
                        String upperLimit = (String)keys[keys.length - 1];
                        this.setUpperLimit(upperLimit);
                    } else {
                        this.node.setItem(COSName.LIMITS, null);
                    }
                }
                catch (IOException exception) {
                    this.node.setItem(COSName.LIMITS, null);
                    LOG.error((Object)"Error while calculating the Limits of a PageNameTreeNode:", (Throwable)exception);
                }
            }
        }
    }

    public Object getValue(String name) throws IOException {
        Object retval = null;
        Map<String, COSObjectable> names = this.getNames();
        if (names != null) {
            retval = names.get(name);
        } else {
            List<PDNameTreeNode> kids = this.getKids();
            if (kids != null) {
                for (int i = 0; i < kids.size() && retval == null; ++i) {
                    PDNameTreeNode childNode = kids.get(i);
                    if (childNode.getLowerLimit().compareTo(name) > 0 || childNode.getUpperLimit().compareTo(name) < 0) continue;
                    retval = childNode.getValue(name);
                }
            } else {
                LOG.warn((Object)"NameTreeNode does not have \"names\" nor \"kids\" objects.");
            }
        }
        return retval;
    }

    public Map<String, COSObjectable> getNames() throws IOException {
        COSArray namesArray = (COSArray)this.node.getDictionaryObject(COSName.NAMES);
        if (namesArray != null) {
            LinkedHashMap<String, COSObjectable> names = new LinkedHashMap<String, COSObjectable>();
            for (int i = 0; i < namesArray.size(); i += 2) {
                COSString key = (COSString)namesArray.getObject(i);
                COSBase cosValue = namesArray.getObject(i + 1);
                names.put(key.getString(), this.convertCOSToPD(cosValue));
            }
            return Collections.unmodifiableMap(names);
        }
        return null;
    }

    protected COSObjectable convertCOSToPD(COSBase base) throws IOException {
        return base;
    }

    protected PDNameTreeNode createChildNode(COSDictionary dic) {
        return new PDNameTreeNode(dic, this.valueType);
    }

    public void setNames(Map<String, ? extends COSObjectable> names) {
        if (names == null) {
            this.node.setItem(COSName.NAMES, (COSObjectable)null);
            this.node.setItem(COSName.LIMITS, (COSObjectable)null);
        } else {
            COSArray array = new COSArray();
            ArrayList<String> keys = new ArrayList<String>(names.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                array.add(new COSString(key));
                array.add(names.get(key));
            }
            this.node.setItem(COSName.NAMES, (COSBase)array);
            this.calculateLimits();
        }
    }

    public String getUpperLimit() {
        String retval = null;
        COSArray arr = (COSArray)this.node.getDictionaryObject(COSName.LIMITS);
        if (arr != null) {
            retval = arr.getString(1);
        }
        return retval;
    }

    private void setUpperLimit(String upper) {
        COSArray arr = (COSArray)this.node.getDictionaryObject(COSName.LIMITS);
        if (arr == null) {
            arr = new COSArray();
            arr.add(null);
            arr.add(null);
            this.node.setItem(COSName.LIMITS, (COSBase)arr);
        }
        arr.setString(1, upper);
    }

    public String getLowerLimit() {
        String retval = null;
        COSArray arr = (COSArray)this.node.getDictionaryObject(COSName.LIMITS);
        if (arr != null) {
            retval = arr.getString(0);
        }
        return retval;
    }

    private void setLowerLimit(String lower) {
        COSArray arr = (COSArray)this.node.getDictionaryObject(COSName.LIMITS);
        if (arr == null) {
            arr = new COSArray();
            arr.add(null);
            arr.add(null);
            this.node.setItem(COSName.LIMITS, (COSBase)arr);
        }
        arr.setString(0, lower);
    }
}

