/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.services.service.imports;

import com.franciaflex.faxtomail.persistence.entities.DemandType;
import com.franciaflex.faxtomail.persistence.entities.MailFolder;
import com.franciaflex.faxtomail.persistence.entities.Priority;
import com.franciaflex.faxtomail.persistence.entities.WaitingState;
import com.franciaflex.faxtomail.services.service.imports.ArchiveImportBean;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.nuiton.csv.Common;
import org.nuiton.csv.ValueParser;
import org.nuiton.csv.ext.AbstractImportModel;

public class ArchiveImportModel
extends AbstractImportModel<ArchiveImportBean> {
    protected ValueParser<Date> dateValueParser = new ValueParser<Date>(){
        protected DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");

        public Date parse(String value) throws ParseException {
            return this.dateFormat.parse(value);
        }
    };
    protected ValueParser<Boolean> yesNoParser = new ValueParser<Boolean>(){

        public Boolean parse(String value) throws ParseException {
            return "oui".equalsIgnoreCase(value);
        }
    };

    public ArchiveImportModel(char separator, final Map<String, WaitingState> waitingStates, final Map<String, DemandType> demandTypes, final Map<String, Priority> priorities, final Map<String, MailFolder> mailFolderMap) {
        super(separator);
        this.newMandatoryColumn("receptionDate", "receptionDate", this.dateValueParser);
        this.newMandatoryColumn("projectReference", "projectReference");
        this.newMandatoryColumn("sender", "sender", (ValueParser)new ValueParser<Object>(){

            public Object parse(String value) throws ParseException {
                value = value.replaceFirst("^.*<(.*)>$", "$1");
                value = value.toLowerCase();
                return value;
            }
        });
        this.newMandatoryColumn("fax", "fax", (ValueParser)Common.PRIMITIVE_BOOLEAN);
        this.newMandatoryColumn("recipient", "recipient");
        this.newMandatoryColumn("object", "object");
        this.newMandatoryColumn("archiveDate", "archiveDate", this.dateValueParser);
        this.newMandatoryColumn("companyReference", "companyReference");
        this.newMandatoryColumn("originalEmail", "originalEmail");
        this.newMandatoryColumn("comment", "comment");
        this.newMandatoryColumn("etatAttente", "waitingState", (ValueParser)new ValueParser<WaitingState>(){

            public WaitingState parse(String value) throws ParseException {
                return (WaitingState)waitingStates.get(value);
            }
        });
        this.newMandatoryColumn("demandType", "demandType", (ValueParser)new ValueParser<DemandType>(){

            public DemandType parse(String value) throws ParseException {
                return (DemandType)demandTypes.get(value);
            }
        });
        this.newMandatoryColumn("priority", "priority", (ValueParser)new ValueParser<Priority>(){

            public Priority parse(String value) throws ParseException {
                return (Priority)priorities.get(value);
            }
        });
        this.newMandatoryColumn("mailFolder", "mailFolder", (ValueParser)new ValueParser<MailFolder>(){

            public MailFolder parse(String value) throws ParseException {
                return (MailFolder)mailFolderMap.get(value);
            }
        });
        this.newMandatoryColumn("client-code", "clientCode");
        this.newMandatoryColumn("client-brand", "clientBrand");
        this.newMandatoryColumn("attachments", "attachmentPaths");
    }

    public ArchiveImportBean newEmptyInstance() {
        return new ArchiveImportBean();
    }
}

