/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.demande.replies;

import com.franciaflex.faxtomail.persistence.entities.Reply;
import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.replies.DemandRepliesUI;
import com.franciaflex.faxtomail.ui.swing.util.AbstractToolbarPopupButton;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.nuiton.i18n.I18n;

public class ButtonDemandReplies
extends AbstractToolbarPopupButton<DemandRepliesUI> {
    protected String textKey;
    private PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Collection replies = (Collection)evt.getNewValue();
            ButtonDemandReplies.this.setText(ButtonDemandReplies.this.getButtonText(replies));
        }
    };

    public ButtonDemandReplies(DemandeUIModel model) {
        this(I18n.n((String)"faxtomail.demandReplies.text", (Object[])new Object[0]), model);
    }

    public ButtonDemandReplies(String textKey, DemandeUIModel model) {
        this.textKey = textKey;
        this.setToolTipText(I18n.t((String)"faxtomail.demandReplies.action.tip", (Object[])new Object[0]));
        this.init(model);
    }

    public String getButtonText(Collection<Reply> replies) {
        int replyNb = CollectionUtils.size(replies);
        return I18n.t((String)this.textKey, (Object[])new Object[]{replyNb});
    }

    public void init(DemandeUIModel model) {
        if (((DemandRepliesUI)this.popup).getModel() != null) {
            ((DemandRepliesUI)this.popup).getModel().removePropertyChangeListener("replies", this.listener);
        }
        ((DemandRepliesUI)this.popup).setModel(model);
        if (model != null) {
            ((DemandRepliesUI)this.popup).getModel().addPropertyChangeListener("replies", this.listener);
            this.setText(this.getButtonText(model.getReplies()));
        }
    }

    @Override
    protected String getActionIcon() {
        return "reply";
    }

    @Override
    protected DemandRepliesUI createNewPopup() {
        DemandRepliesUI ui = new DemandRepliesUI(FaxToMailUIContext.getApplicationContext());
        return ui;
    }

    public DemandeUIModel getBean() {
        return ((DemandRepliesUI)this.popup).getModel();
    }

    public void setEditable(boolean editable) {
        ((DemandRepliesUI)this.popup).setEditable(editable);
    }
}

