/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.demande.demandgroup;

import com.franciaflex.faxtomail.ui.swing.actions.OpenGroupedDemandAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.demandgroup.DemandGroupItem;
import com.franciaflex.faxtomail.ui.swing.content.demande.demandgroup.DemandGroupUI;
import com.franciaflex.faxtomail.ui.swing.util.AbstractToolbarPopupHandler;
import com.google.common.collect.Iterables;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.validator.swing.SwingValidator;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;

public class DemandGroupUIHandler
extends AbstractToolbarPopupHandler<DemandeUIModel, DemandGroupUI> {
    public void beforeInit(DemandGroupUI ui) {
        super.beforeInit((ApplicationUI)ui);
        DemandeUIModel currentEmail = this.getContext().getCurrentEmail();
        ((DemandGroupUI)this.ui).setContextValue(currentEmail);
    }

    @Override
    public void afterInit(DemandGroupUI ui) {
        super.afterInit(ui);
        this.initTable(ui.getDemandGroup());
        ((DemandeUIModel)this.getModel()).addPropertyChangeListener("groupedDemandes", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AbstractTableModel tableModel = (AbstractTableModel)((DemandGroupUI)DemandGroupUIHandler.this.getUI()).getDemandGroup().getModel();
                tableModel.fireTableDataChanged();
            }
        });
    }

    protected void initTable(JXTable table) {
        AbstractTableModel demandGroupTableModel = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return ((DemandeUIModel)DemandGroupUIHandler.this.getModel()).sizeGroupedDemandes();
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                return Iterables.get(((DemandeUIModel)DemandGroupUIHandler.this.getModel()).getGroupedDemandes(), (int)rowIndex);
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }
        };
        demandGroupTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ((DemandGroupUI)DemandGroupUIHandler.this.getUI()).pack();
            }
        });
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        TableColumn column = new TableColumn();
        column.setCellRenderer(new DemandGroupItemRenderer());
        column.setCellEditor(new DemandGroupItemEditor());
        columnModel.addColumn(column);
        table.setModel((TableModel)demandGroupTableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        table.addHighlighter(HighlighterFactory.createAlternateStriping());
    }

    public void onCloseUI() {
    }

    public SwingValidator<DemandeUIModel> getValidator() {
        return null;
    }

    protected JComponent getComponentToFocus() {
        return null;
    }

    public void openDemande(DemandeUIModel demande) {
        this.closeEditor();
        OpenGroupedDemandAction openAction = new OpenGroupedDemandAction(this, demande);
        this.getContext().getActionEngine().runAction((AbstractApplicationAction)openAction);
    }

    protected class DemandGroupItemEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        protected DemandGroupItem demandGroupItem;

        public DemandGroupItemEditor() {
            this.demandGroupItem = new DemandGroupItem(DemandGroupUIHandler.this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            DemandeUIModel demand = (DemandeUIModel)value;
            this.demandGroupItem.setDemande(demand);
            return this.demandGroupItem;
        }

        @Override
        public Object getCellEditorValue() {
            return this.demandGroupItem.getDemande();
        }
    }

    protected class DemandGroupItemRenderer
    extends DemandGroupItem
    implements TableCellRenderer {
        public DemandGroupItemRenderer() {
            super(DemandGroupUIHandler.this);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            DemandeUIModel demand = (DemandeUIModel)value;
            this.setDemande(demand);
            return this;
        }
    }
}

