package com.franciaflex.faxtomail.ui.swing.content.demande.demandgroup;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.JAXXUtil.getStringValue;
import static org.nuiton.i18n.I18n.t;

public class DemandGroupItem extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DEMANDE = "demande";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DEMANDE_SUBJECT_LABEL_TEXT = "demandeSubjectLabel.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Uy27TQBS9NU1KyrMUKhAghceioGqCYFnEI4VCUHiIFAmRDZN40gwae4bxNXWFQHwCnwB7NkjsWCEWrFmwQfwCQizYIu7YbtO0Rq0QWdiT+zz3+Nx58x1KkYVjj3iSMBuHKAPBbly+f/9255Ho4hURda00qC1kvxEPvDbs8FftEcKJdtOl1/L02pwOjA5FuCZ7tgnjES4rEfWFQISjwxndKKq1Vt2ziYntStVVUEVVX/384b30X7z2ABJD6Mo0SnWzrMEko03wpI+wjzo94TXFw0WCYWW4SHh3Oduc4lF0iwfiMTyHsSaUDbdUDOH41kdOa6T5iUFHXcBD/w4PhUK41dUB61kediXvKZGwHk9QB1wqFksWLREU1tUhUmWWJYr8vWh1bNiV9HzNnRsoAmPSRmWEsTwa4fI/tMjKinuNm9oXak3VPpmVsAit/wf8XuN6VnXQZzJPacWpCpu848ja575Ikhe/kRpdfGUAD7VWHU7w9g+FLpC5zu1w8IQ2IswHrceIBBYmh9Iyqws/YEhYh4eERZJlA8kONDXShpKNyYxwsL1R5XfJlen74Dp9u4Kp9/fU5Jf3397NrxX1gcLQNTtJYjOWJrIoXes9maJjlKp2k5vZNlQioYjKdGGPFABr5W4CR/0mXDpz6ew6j/pUojT29cPHqYeft4E3D+NKc3+eu/gGVLBviQWt/MRcvJQi2rm0nZ57HTbCEvBEBnFwVy/N6dgtj3f2TEIMHClgYBVGp/Lp12Tr7aUVFjxCdeiv4QMmSg+gLEMlQ5Eud763hcu8w0Qi9vVgP4s2Fmhnp+qCh/NSobC8Q24ddHRdJ7leT7uQnS5knaOaPk8WcVLuaOu7Pao9rdbTY8bmMutawVFcDQwuZ47pszPVczNV9zxVfZbErua0q5I3H75SzOa9R1Ek9BEOP60uCswXYPoUoz8LEhUdi7sU7eRm3TyESo+0go42hFKPq4jeu7Lp73BJF4S/Yi9qurLRW2g0TgRKHTbcrQOjbrmJGZe+IM1COvHpwR3FEXm3H1DMVV8S7yxLZi6NoTRFWDZeGFsgu6z4sqZg2H3eJxqqHRn6dLlc2NBgxD3HqeIf651KY5IHAAA=";
    private static final Log log = LogFactory.getLog(DemandGroupItem.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected DemandGroupItem demandPanel = this;
    protected DemandeUIModel demande;
    protected JLabel demandeSubjectLabel;
    protected DemandGroupUIHandler handler;
    protected JButton openDemandeButton;
    protected JToolBar toolbar;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DemandGroupItem(DemandGroupUIHandler handler) {
        setContextValue(handler);
            $initialize();
    }

    public DemandGroupItem(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DemandGroupItem(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemandGroupItem(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandGroupItem(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemandGroupItem() {
        $initialize();
    }

    public DemandGroupItem(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemandGroupItem(boolean param0) {
        super(param0);
        $initialize();
    }

    public DemandGroupItem(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__openDemandeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openDemande(demande);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public DemandeUIModel getDemande() {
        return demande;
    }

    public JLabel getDemandeSubjectLabel() {
        return demandeSubjectLabel;
    }

    public DemandGroupUIHandler getHandler() {
        return handler;
    }

    public JButton getOpenDemandeButton() {
        return openDemandeButton;
    }

    public JToolBar getToolbar() {
        return toolbar;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setDemande(DemandeUIModel demande) {
        DemandeUIModel oldValue = this.demande;
        this.demande = demande;
        firePropertyChange(PROPERTY_DEMANDE, oldValue, demande);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDemandPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(demandeSubjectLabel, BorderLayout.CENTER);
        add(toolbar, BorderLayout.EAST);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(openDemandeButton);
    }

    protected void createDemande() {
        $objectMap.put("demande", demande = null);
    }

    protected void createDemandeSubjectLabel() {
        $objectMap.put("demandeSubjectLabel", demandeSubjectLabel = new JLabel());
        
        demandeSubjectLabel.setName("demandeSubjectLabel");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(DemandGroupUIHandler.class));
    }

    protected void createOpenDemandeButton() {
        $objectMap.put("openDemandeButton", openDemandeButton = new JButton());
        
        openDemandeButton.setName("openDemandeButton");
        openDemandeButton.setToolTipText(t("faxtomail.attachmentEditor.action.open.tip"));
        openDemandeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__openDemandeButton"));
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new JToolBar());
        
        toolbar.setName("toolbar");
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToDemandPanel();
        addChildrenToToolbar();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 3 property setters
        setBorder( BorderFactory.createEmptyBorder(2, 3, 2, 3) );
        openDemandeButton.setIcon(SwingUtil.createActionIcon("open"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("demandPanel", demandPanel);
        createDemande();
        createHandler();
        createDemandeSubjectLabel();
        createToolbar();
        createOpenDemandeButton();
        // inline creation of demandPanel
        setName("demandPanel");
        setLayout(new BorderLayout());
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DEMANDE_SUBJECT_LABEL_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("demande", this);
                if (getDemande() != null) {
                    getDemande().addPropertyChangeListener("title", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getDemande() != null) {
                    demandeSubjectLabel.setText(t( getDemande().getTitle() ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("demande", this);
                if (getDemande() != null) {
                    getDemande().removePropertyChangeListener("title", this);
                }
            }
        });
    }

}