package com.franciaflex.faxtomail.ui.swing.content.demande;

/*
 * #%L
 * FaxToMail :: UI
 * $Id: QuantitiesByRangeUIHandler.java 660 2014-10-02 11:30:33Z kmorin $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-1.0/faxtomail-ui-swing/src/main/java/com/franciaflex/faxtomail/ui/swing/content/demande/QuantitiesByRangeUIHandler.java $
 * %%
 * Copyright (C) 2014 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.Range;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailUIHandler;
import jaxx.runtime.validator.swing.SwingValidator;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.jaxx.application.swing.util.Cancelable;

import javax.swing.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;

/**
 * @author Kevin Morin (Code Lutin)
 *
 */
public class QuantitiesByRangeUIHandler extends AbstractFaxToMailUIHandler<QuantitiesByRangeUIModel, QuantitiesByRangeUI> implements Cancelable {

    protected RangeTableModel rangeTableModel;

    @Override
    public void beforeInit(QuantitiesByRangeUI ui) {
        super.beforeInit(ui);

        QuantitiesByRangeUIModel dialogModel = new QuantitiesByRangeUIModel();
        dialogModel.setRootFolder(getContext().getCurrentMailFolder());
        this.ui.setContextValue(dialogModel);
    }

    @Override
    public void afterInit(QuantitiesByRangeUI quantitiesByRangeUI) {
        initUI(quantitiesByRangeUI);

        final JXTable table = ui.getRangeTable();

        TableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        addColumnToModel(columnModel,
                         null,
                         newTableCellRender(Range.class),
                         RangeTableModel.RANGE_COLUMN);
        addIntegerColumnToModel(columnModel,
                                RangeTableModel.QUOTATION_QUANTITY_COLUMN,
                                null,
                                table);
        addIntegerColumnToModel(columnModel,
                                RangeTableModel.PRODUCT_QUANTITY_COLUMN,
                                null,
                                table);
        addIntegerColumnToModel(columnModel,
                                RangeTableModel.SAV_QUANTITY_COLUMN,
                                null,
                                table);

        rangeTableModel = new RangeTableModel(columnModel);
        rangeTableModel.setRows(getModel().getRangeRows());
        table.setModel(rangeTableModel);
        table.setColumnModel(columnModel);
        table.getTableHeader().setReorderingAllowed(false);

        getModel().addPropertyChangeListener(QuantitiesByRangeUIModel.PROPERTY_RANGE_ROWS,
                                             new PropertyChangeListener() {
                                                 @Override
                                                 public void propertyChange(PropertyChangeEvent evt) {
                                                     setRangeRows((List<RangeRowModel>) evt.getNewValue());
                                                 }
                                             });
    }

    @Override
    public SwingValidator<QuantitiesByRangeUIModel> getValidator() {
        return null;
    }

    @Override
    protected JComponent getComponentToFocus() {
        return null;
    }

    @Override
    public void onCloseUI() {

    }

    @Override
    public void cancel() {
        closeDialog();
    }

    public void setRangeRows(List<RangeRowModel> rows) {
        rangeTableModel.setRows(rows);
    }
}
