/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.search;

import com.franciaflex.faxtomail.persistence.entities.DemandStatus;
import com.franciaflex.faxtomail.persistence.entities.MailField;
import com.franciaflex.faxtomail.services.service.ReferentielService;
import com.franciaflex.faxtomail.ui.swing.actions.GroupAction;
import com.franciaflex.faxtomail.ui.swing.actions.SearchToGroupAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI;
import com.franciaflex.faxtomail.ui.swing.content.search.SearchUIModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailDemandListHandler;
import com.franciaflex.faxtomail.ui.swing.util.Cancelable;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;
import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;

public class SearchToGroupUIHandler
extends AbstractFaxToMailDemandListHandler<SearchUIModel, SearchToGroupUI>
implements Cancelable {
    private static final Log log = LogFactory.getLog(SearchToGroupUIHandler.class);

    public void beforeInit(SearchToGroupUI ui) {
        super.beforeInit((ApplicationUI)ui);
        SearchUIModel searchUIModel = this.getContext().getSearch();
        if (searchUIModel == null) {
            searchUIModel = new SearchUIModel();
            Date now = new Date();
            Calendar cal = Calendar.getInstance();
            cal.add(2, -2);
            Date twoMonthsAgo = cal.getTime();
            searchUIModel.setMaxReceptionDate(now);
            searchUIModel.setMinReceptionDate(twoMonthsAgo);
        }
        ((SearchToGroupUI)this.getUI()).setContextValue(searchUIModel);
    }

    protected JComponent getComponentToFocus() {
        return null;
    }

    public void afterInit(SearchToGroupUI ui) {
        this.initUI(ui);
        ReferentielService referentielService = this.getContext().getReferentielService();
        SearchUIModel model = (SearchUIModel)((Object)this.getModel());
        this.initBeanFilterableComboBox(ui.getTakenByComboBox(), this.getContext().getUserService().getAllUsers(), model.getTakenBy());
        this.initBeanFilterableComboBox(ui.getModifiedByComboBox(), this.getContext().getUserService().getAllUsers(), model.getModifiedBy());
        this.initBeanFilterableComboBox(ui.getArchivedByComboBox(), this.getContext().getUserService().getAllUsers(), model.getArchivedBy());
        this.initBeanFilterableComboBox(ui.getTransferByComboBox(), this.getContext().getUserService().getAllUsers(), model.getTransferBy());
        this.initBeanFilterableComboBox(ui.getPrintedByComboBox(), this.getContext().getUserService().getAllUsers(), model.getPrintingBy());
        this.initBeanFilterableComboBox(ui.getRepliedByComboBox(), this.getContext().getUserService().getAllUsers(), model.getReplyBy());
        this.initCheckBoxComboBox(ui.getDocTypeComboBox(), referentielService.getAllDemandType(), model.getDemandType(), "demandType", true);
        this.initCheckBoxComboBox(ui.getPriorityComboBox(), referentielService.getAllPriority(), model.getPriority(), "priority", true);
        this.initCheckBoxComboBox(ui.getEtatAttenteComboBox(), referentielService.getAllEtatAttente(), model.getEtatAttente(), "etatAttente", true);
        this.initCheckBoxComboBox(ui.getStatusComboBox(), Arrays.asList(DemandStatus.values()), model.getDemandStatus(), "demandStatus", false);
        this.initCheckBoxComboBox(ui.getGammeComboBox(), referentielService.getAllRange(), model.getGamme(), "gamme", false);
        final JXTable dataTable = ((SearchToGroupUI)this.getUI()).getDataTable();
        dataTable.setSelectionMode(0);
        this.initDemandeTable(dataTable, true);
        model.addPropertyChangeListener("results", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                int row;
                List emails = (List)evt.getNewValue();
                AbstractApplicationTableModel dataTableModel = (AbstractApplicationTableModel)dataTable.getModel();
                dataTableModel.setRows(emails);
                SearchToGroupUIHandler.this.showInformationMessage(I18n.t((String)"faxtomail.search.resultNb", (Object[])new Object[]{emails.size()}));
                DemandeUIModel currentEmail = SearchToGroupUIHandler.this.getContext().getCurrentEmail();
                if (currentEmail != null && (row = dataTableModel.getRowIndex((Serializable)currentEmail)) > 0) {
                    dataTable.setRowSelectionInterval(row, row);
                }
            }
        });
        if (this.getContext().getSearch() != null) {
            try {
                SearchToGroupAction searchAction = (SearchToGroupAction)this.getContext().getActionFactory().createLogicAction((AbstractApplicationUIHandler)this, SearchToGroupAction.class);
                searchAction.doAction();
            }
            catch (Exception e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"error while searching", (Throwable)e);
                }
                this.getContext().getErrorHelper().showErrorDialog(I18n.t((String)"faxtomail.search.action.error", (Object[])new Object[0]));
            }
        }
        dataTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ListSelectionModel selectionModel = (ListSelectionModel)e.getSource();
                    SearchUIModel model = (SearchUIModel)((Object)SearchToGroupUIHandler.this.getModel());
                    int selectedIndex = selectionModel.getLeadSelectionIndex();
                    AbstractApplicationTableModel dataTableModel = (AbstractApplicationTableModel)dataTable.getModel();
                    DemandeUIModel selectedModel = selectedIndex < 0 ? null : (DemandeUIModel)dataTableModel.getEntry(selectedIndex);
                    model.setGroupEnabled(!selectionModel.isSelectionEmpty() && SearchToGroupUIHandler.this.isDemandSelectable(selectedModel));
                }
            }
        });
        HighlightPredicate rowAlreadyInGroupPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                int viewRow = adapter.row;
                int modelRow = adapter.convertRowIndexToModel(viewRow);
                AbstractApplicationTableModel dataTableModel = (AbstractApplicationTableModel)dataTable.getModel();
                DemandeUIModel row = (DemandeUIModel)dataTableModel.getEntry(modelRow);
                return !SearchToGroupUIHandler.this.isDemandSelectable(row);
            }
        };
        dataTable.addHighlighter((Highlighter)new ColorHighlighter(rowAlreadyInGroupPredicate, null, Color.GRAY, Color.GRAY, Color.WHITE));
    }

    @Override
    protected List<MailField> getColumns() {
        List tableColumns = this.getContext().getFaxToMailConfiguration().getSearchDisplayColumns();
        return tableColumns;
    }

    protected boolean isDemandSelectable(DemandeUIModel demand) {
        DemandeUIModel currentDemand = this.getContext().getCurrentEmail();
        return !currentDemand.equals(demand) && !currentDemand.getGroupedDemandes().contains(demand);
    }

    @Override
    protected MouseListener getDataTableMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    SearchToGroupUIHandler.this.group();
                }
            }
        };
    }

    @Override
    protected MailField[] getEditableTableProperties() {
        return new MailField[0];
    }

    public void onCloseUI() {
    }

    public SwingValidator<SearchUIModel> getValidator() {
        return null;
    }

    @Override
    public void cancel() {
        this.closeFrame();
    }

    public void group(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.group();
        }
    }

    public void group() {
        if (((SearchUIModel)((Object)this.getModel())).isGroupEnabled()) {
            this.getContext().getActionEngine().runAction((AbstractApplicationAction)new GroupAction(this));
        }
    }
}

