/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.demande;

import com.franciaflex.faxtomail.persistence.entities.EtatAttente;
import com.franciaflex.faxtomail.persistence.entities.MailAction;
import com.franciaflex.faxtomail.ui.swing.actions.ArchiveAction;
import com.franciaflex.faxtomail.ui.swing.actions.SaveAndOpenDialogAction;
import com.franciaflex.faxtomail.ui.swing.actions.SaveDemandeAndExitAction;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandesUI;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandesUIModel;
import com.franciaflex.faxtomail.ui.swing.content.print.AttachmentToPrintChooserUI;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUI;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUIModel;
import com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI;
import com.franciaflex.faxtomail.ui.swing.content.transmit.MailFolderChooserUI;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailUIHandler;
import com.franciaflex.faxtomail.ui.swing.util.CloseableUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;
import org.nuiton.jaxx.application.swing.tab.CustomTab;
import org.nuiton.jaxx.application.swing.tab.DelegateTabContainerHandler;
import org.nuiton.jaxx.application.swing.tab.TabContainerHandler;
import org.nuiton.jaxx.application.swing.tab.TabContentModel;
import org.nuiton.jaxx.application.swing.tab.TabHandler;

public class DemandesUIHandler
extends AbstractFaxToMailUIHandler<DemandesUIModel, DemandesUI>
implements TabContainerHandler,
CloseableUI {
    private static final Log log = LogFactory.getLog(DemandesUIHandler.class);
    protected DelegateTabContainerHandler delegateTabHandler;

    public void beforeInit(DemandesUI ui) {
        super.beforeInit((ApplicationUI)ui);
        DemandeUIModel currentEmail = this.getContext().getCurrentEmail();
        currentEmail.setCloseable(false);
        DemandesUIModel model = new DemandesUIModel();
        ((DemandesUI)this.ui).setContextValue(model);
    }

    public void afterInit(DemandesUI demandesUI) {
        this.initUI((DemandesUI)this.ui);
        DemandesUIModel model = (DemandesUIModel)((Object)this.getModel());
        final PropertyChangeListener demandEnabledAndValidListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("valid") || evt.getPropertyName().equals("editable") || evt.getPropertyName().equals("archiveDate")) {
                    DemandesUI ui = (DemandesUI)DemandesUIHandler.this.getUI();
                    ui.processDataBinding("archiveButton.enabled");
                    ui.processDataBinding("groupButton.enabled");
                    ui.processDataBinding("replyButton.enabled");
                    ui.processDataBinding("saveButton.enabled");
                    ui.processDataBinding("transmitButton.enabled");
                }
                if (evt.getPropertyName().equals("valid") || evt.getPropertyName().equals("etatAttente")) {
                    DemandeUIModel model = (DemandeUIModel)evt.getSource();
                    EtatAttente etatAttente = model.getEtatAttente();
                    boolean transmitEnabled = model.isEditable() && (etatAttente == null || model.isValid() && !etatAttente.containsValidFormDisabledActions(MailAction.TRANSMIT) || !model.isValid() && !etatAttente.containsInvalidFormDisabledActions(MailAction.TRANSMIT));
                    ((DemandesUIModel)((Object)DemandesUIHandler.this.getModel())).setTransmitEnabled(transmitEnabled);
                }
            }
        };
        model.addDemandsListener(new DemandesUIModel.DemandsListener(){

            @Override
            public void onDemandAdded(DemandeUIModel demand, int index, boolean added) {
                JTabbedPane tabPanel = DemandesUIHandler.this.getTabPanel();
                if (added) {
                    DemandeUI demandeUI = new DemandeUI((FaxToMailUI)DemandesUIHandler.this.getUI(), demand);
                    demandeUI.setName("demandPanel" + index);
                    DemandesUIHandler.this.getContext().getSwingSession().add((Component)demandeUI, true);
                    demand.addPropertyChangeListener(demandEnabledAndValidListener);
                    tabPanel.add(demandeUI);
                    DemandesUIHandler.this.setCustomTab(index, demand);
                }
                tabPanel.setSelectedIndex(index);
            }

            @Override
            public void onDemandRemoved(DemandeUIModel demand, int index) {
                demand.removePropertyChangeListener(demandEnabledAndValidListener);
            }
        });
        DemandeUIModel currentEmail = this.getContext().getCurrentEmail();
        model.addDemand(currentEmail);
    }

    @Override
    public boolean quitUI() {
        this.closeButtonPopups();
        JTabbedPane tabPanel = this.getTabPanel();
        int tabCount = tabPanel.getTabCount();
        boolean quit = true;
        int i = 0;
        while (quit && i < tabCount) {
            tabPanel.setSelectedIndex(i);
            DemandeUIHandler tabHandler = (DemandeUIHandler)this.getTabHandler(i++);
            quit = tabHandler.quitUI();
        }
        return quit;
    }

    public void onCloseUI() {
        int tabCount = this.getTabPanel().getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            DemandeUIHandler tabHandler = (DemandeUIHandler)this.getTabHandler(i);
            tabHandler.onCloseUI();
        }
    }

    public SwingValidator<DemandesUIModel> getValidator() {
        return null;
    }

    protected JComponent getComponentToFocus() {
        return null;
    }

    public TabHandler getTabHandler(int index) {
        ApplicationUI tuttiTab;
        AbstractApplicationUIHandler handler;
        Component tab;
        TabHandler tabHandler = null;
        JTabbedPane tabPanel = this.getTabPanel();
        if (index >= 0 && index < tabPanel.getTabCount() && ApplicationUI.class.isInstance(tab = tabPanel.getComponentAt(index)) && TabHandler.class.isInstance(handler = (tuttiTab = (ApplicationUI)tabPanel.getComponentAt(index)).getHandler())) {
            tabHandler = (TabHandler)handler;
        }
        return tabHandler;
    }

    public void setCustomTab(int index, TabContentModel model) {
        JTabbedPane tabPanel = this.getTabPanel();
        tabPanel.setTabComponentAt(index, (Component)new CustomTab(model, (TabContainerHandler)this));
    }

    public boolean removeTab(int i) {
        TabHandler tabHandler = this.getTabHandler(i);
        boolean remove = tabHandler.onRemoveTab();
        if (remove) {
            this.getTabPanel().removeTabAt(i);
            ((DemandesUIModel)((Object)this.getModel())).removeDemand(i);
        }
        return remove;
    }

    protected void initUI(DemandesUI ui) {
        super.initUI((ApplicationUI)ui);
        this.init();
    }

    public JTabbedPane getTabPanel() {
        return ((DemandesUI)this.getUI()).getDemandsTabPane();
    }

    public void init() {
        this.getTabPanel().setModel(new DefaultSingleSelectionModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void setSelectedIndex(int index) {
                int currentIndex = DemandesUIHandler.this.getTabPanel().getSelectedIndex();
                boolean mustChangeTab = DemandesUIHandler.this.onTabChanged(currentIndex, index);
                if (mustChangeTab) {
                    super.setSelectedIndex(index);
                }
            }
        });
    }

    public boolean onTabChanged(int currentIndex, int newIndex) {
        boolean change = true;
        if (currentIndex != newIndex) {
            TabHandler handler = this.getTabHandler(currentIndex);
            if (handler != null) {
                change = handler.onHideTab(currentIndex, newIndex);
            }
            if ((handler = this.getTabHandler(newIndex)) != null) {
                handler.onShowTab(currentIndex, newIndex);
            }
        }
        if (change) {
            ((DemandesUIModel)((Object)this.getModel())).setCurrentIndex(newIndex);
        }
        return change;
    }

    protected void closeButtonPopups() {
        DemandeUI demandeUI = (DemandeUI)this.getTabPanel().getSelectedComponent();
        demandeUI.getHandler().closeButtonPopups();
        ((DemandesUI)this.ui).getDemandGroupButton().setSelected(false);
    }

    public void save() {
        this.closeButtonPopups();
        DemandeUI demandeUI = (DemandeUI)this.getTabPanel().getSelectedComponent();
        SaveDemandeAndExitAction action = new SaveDemandeAndExitAction(demandeUI.getHandler());
        this.getContext().getActionFactory().createUIAction(null, (AbstractApplicationAction)action).actionPerformed(null);
    }

    public void transmitDemande() {
        this.closeButtonPopups();
        DemandeUI demandeUI = (DemandeUI)this.getTabPanel().getSelectedComponent();
        MailFolderChooserUI dialogContent = new MailFolderChooserUI((FaxToMailUI)this.ui, demandeUI.getModel());
        SaveAndOpenDialogAction action = new SaveAndOpenDialogAction(demandeUI.getHandler(), true, dialogContent, I18n.t((String)"faxtomail.chooseMailFolder.title", (Object[])new Object[0]), new Dimension(350, 500));
        this.getContext().getActionFactory().createUIAction(null, (AbstractApplicationAction)action).actionPerformed(null);
    }

    public void print() {
        this.closeButtonPopups();
        DemandeUI demandeUI = (DemandeUI)this.getTabPanel().getSelectedComponent();
        AttachmentToPrintChooserUI dialogContent = new AttachmentToPrintChooserUI((FaxToMailUI)this.ui, demandeUI.getModel());
        SaveAndOpenDialogAction action = new SaveAndOpenDialogAction(demandeUI.getHandler(), true, dialogContent, I18n.t((String)"faxtomail.chooseAttachmentToPrint.title", (Object[])new Object[0]), new Dimension(350, 500));
        this.getContext().getActionFactory().createUIAction(null, (AbstractApplicationAction)action).actionPerformed(null);
    }

    public void archive() {
        this.closeButtonPopups();
        DemandeUI demandeUI = (DemandeUI)this.getTabPanel().getSelectedComponent();
        ArchiveAction action = new ArchiveAction(demandeUI.getHandler());
        this.getContext().getActionFactory().createUIAction(null, (AbstractApplicationAction)action).actionPerformed(null);
    }

    public void reply() {
        this.closeButtonPopups();
        ReplyFormUI dialogContent = new ReplyFormUI((FaxToMailUI)this.ui);
        ReplyFormUIModel model = dialogContent.getModel();
        DemandeUIModel currentDemand = ((DemandesUIModel)((Object)this.getModel())).getCurrentDemand();
        model.setOriginalDemand(currentDemand);
        model.setTo(currentDemand.getSender());
        DemandeUI demandeUI = (DemandeUI)this.getTabPanel().getSelectedComponent();
        SaveAndOpenDialogAction action = new SaveAndOpenDialogAction(demandeUI.getHandler(), false, dialogContent, I18n.t((String)"faxtomail.reply.title", (Object[])new Object[]{currentDemand.getObject()}), new Dimension(800, 600));
        this.getContext().getActionFactory().createUIAction(null, (AbstractApplicationAction)action).actionPerformed(null);
    }

    public void group() {
        this.closeButtonPopups();
        SearchToGroupUI dialogContent = new SearchToGroupUI((FaxToMailUI)this.ui);
        DemandeUI demandeUI = (DemandeUI)this.getTabPanel().getSelectedComponent();
        SaveAndOpenDialogAction action = new SaveAndOpenDialogAction(demandeUI.getHandler(), false, dialogContent, I18n.t((String)"faxtomail.searchToGroup.title", (Object[])new Object[]{demandeUI.getModel().getObject()}), this.getContext().getMainUI().getSize());
        this.getContext().getActionFactory().createUIAction(null, (AbstractApplicationAction)action).actionPerformed(null);
    }
}

