/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.persistence.entities;

import com.franciaflex.faxtomail.persistence.entities.AttachmentFileAbstract;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;

public class AttachmentFileImpl
extends AttachmentFileAbstract {
    private static final Log log = LogFactory.getLog(AttachmentFileImpl.class);
    protected transient File tmpLocalFile;

    @Override
    public File getFile() {
        if (this.tmpLocalFile == null && this.getContent() != null) {
            try {
                File tempFolder = new File(FileUtils.getTempDirectory(), "faxtomail");
                tempFolder.mkdir();
                String fileName = this.getFilename();
                this.tmpLocalFile = new File(tempFolder, fileName);
                int i = 1;
                String extension = "." + FileUtil.extension((String)fileName, (String[])new String[0]);
                String name = FileUtil.basename((String)extension, (String[])new String[0]);
                while (this.tmpLocalFile.exists()) {
                    this.tmpLocalFile = new File(tempFolder, name + "-" + i + extension);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Copy blob content to file : %s", this.tmpLocalFile.getAbsolutePath()));
                }
                this.tmpLocalFile.deleteOnExit();
                ByteArrayInputStream is = new ByteArrayInputStream(this.getContent());
                FileOutputStream fos = new FileOutputStream(this.tmpLocalFile);
                IOUtils.copy((InputStream)is, (OutputStream)fos);
                fos.close();
            }
            catch (IOException ex) {
                throw new RuntimeException("Can't create file on local file system", ex);
            }
        }
        return this.tmpLocalFile;
    }

    @Override
    public long getLength() {
        long result = 0L;
        if (this.getFile() != null) {
            result = this.getFile().length();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.tmpLocalFile != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Deleting file : %s", this.tmpLocalFile.getAbsolutePath()));
                }
                this.tmpLocalFile.delete();
            }
        }
        finally {
            super.finalize();
        }
    }
}

