package com.franciaflex.faxtomail.ui.swing.content.reply;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.JAXXUtil.getStringValue;
import static org.nuiton.i18n.I18n.t;

public class AttachmentItem extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ATTACHMENT_FILE = "attachmentFile";
    public static final String PROPERTY_HANDLER = "handler";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ATTACHMENT_NAME_LABEL_TEXT = "attachmentNameLabel.text";
    public static final String BINDING_REMOVE_ATTACHMENT_BUTTON_VISIBLE = "removeAttachmentButton.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJVUz28bRRR+cWsbJ7SUpo0KFGkbJGRXYcyP3gK0SagbVy5USSoVfIDx7jieanZnmH1O14pA/An8CXDngsSNE+LAmQMXxL+AEAeuiDe7tjeu10qwrPX6zfu++d7P7/6EcmzhxhOeJMwOI5ShYPe3Hj/+qPdE+PiBiH0rDWoL2WepBKUurARTe4zwWrfj4M0xvLmjQ6MjEZ1Ab3ZgOcaREvFACER4dRbhx3Fzf3q8mZihnbBORRWxfvP3X6Wvg6++LQEkhtRVKRTvNFQeyfkOlGSAcJluOuJNxaNDkmFldEh6LzjbjuJx/CEPxefwJVQ7UDHcEhnC+tlDTjlSfGIQXuCI3B+E5PuQR0Ih3PZ1yPqWR77kfSUS1ucJ6pBLxYaSxU9JDvN1hIRgVhg1YltTijaK0JiUvYJwMeduSSUQ3ltMbYSNZUykvmDkL1GK+ASxw+fE1QGPAiUsws7/Frvnni1tw0ft3Ywl513NBbskd3jPJeSyy3wyJrufGp1/LZeDWqseJzlXZlwPyLzN7azzFW1ElAe2PUQkfbA6g8ysDnF1ClyzItRH4lmoO3157GnhlZluoz5meR/njbbUhbIdkhnhWne+9ffoKGv6a880vSNMT/9dW/3txz9+aE06vUJ3Xy10PTGo1IHGUvjWFZdaL2vzIUrVfMDNZhdqsVA05ekUXy8Qtj8+JnF034sOzhyc7fJ4QBTl6u8//bz22a/noNSCZaV50OLOvw01HFjKglZBYm7fSRU9//Q5el5y2hAqPW0D11C3jr3t9DVDjphvBUfRkZHI7PUdrbRlnfa93YNP7+1tfdzwvkgoVdcLUjXV26v98s/q/vd3JulaIvkvLXTPU1b+BCoyUnR5uhrGU1+4ClZMLIaBzqe7aN5hfuDNuP3X0+frc8k5h3AeRUI7Bo89rK/nA5bNU07HlBuN9Q3vUODs5NYbjGzuLSLB9cZCl46IDnFQb3hN7603375FqUVYpkJIHbXdGNOfKepE0ZrFRbsbGhyNq/bOhjf+pvVysd5MC+HeNqB49k/LTQmh1qc2Q95z663c5yqm3wuZrodc0uIJJvaiSyeb4wwXzaSh5pbIG/10qa44jgNpDtIi3czrkwd0N5CUFpYxMIdlKE2RoMLtdIYWqR7JWKZJaBx7N6iS492alfWBDoSiVxnvCR7oSI3q86WtkI/AuYA2Tg8oW4yLQlqwN08Lyi0FxUeanOHiuwHV2OvJKKD1/P7cLUvuuUyM/wEN9ANjvwgAAA==";
    private static final Log log = LogFactory.getLog(AttachmentItem.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AttachmentFile attachmentFile;
    protected JLabel attachmentNameLabel;
    protected AttachmentItem attachmentPanel = this;
    protected ReplyFormUIHandler handler;
    protected JButton openAttachmentButton;
    protected JButton removeAttachmentButton;
    protected JToolBar toolbar;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AttachmentItem(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentItem(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentItem() {
        $initialize();
    }

    public AttachmentItem(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentItem(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public AttachmentItem(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentItem(boolean param0) {
        super(param0);
        $initialize();
    }

    public AttachmentItem(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__openAttachmentButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.openAttachment(attachmentFile);
    }

    public void doActionPerformed__on__removeAttachmentButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeAttachment(attachmentFile);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public AttachmentFile getAttachmentFile() {
        return attachmentFile;
    }

    public JLabel getAttachmentNameLabel() {
        return attachmentNameLabel;
    }

    public ReplyFormUIHandler getHandler() {
        return handler;
    }

    public JButton getOpenAttachmentButton() {
        return openAttachmentButton;
    }

    public JButton getRemoveAttachmentButton() {
        return removeAttachmentButton;
    }

    public JToolBar getToolbar() {
        return toolbar;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAttachmentFile(AttachmentFile attachmentFile) {
        AttachmentFile oldValue = this.attachmentFile;
        this.attachmentFile = attachmentFile;
        firePropertyChange(PROPERTY_ATTACHMENT_FILE, oldValue, attachmentFile);
    }

    public void setHandler(ReplyFormUIHandler handler) {
        ReplyFormUIHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAttachmentPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(attachmentNameLabel, BorderLayout.CENTER);
        add(toolbar, BorderLayout.EAST);
    }

    protected void addChildrenToToolbar() {
        if (!allComponentsCreated) {
            return;
        }
        toolbar.add(openAttachmentButton);
        toolbar.add(removeAttachmentButton);
    }

    protected void createAttachmentFile() {
        $objectMap.put("attachmentFile", attachmentFile = null);
    }

    protected void createAttachmentNameLabel() {
        $objectMap.put("attachmentNameLabel", attachmentNameLabel = new JLabel());
        
        attachmentNameLabel.setName("attachmentNameLabel");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = null);
    }

    protected void createOpenAttachmentButton() {
        $objectMap.put("openAttachmentButton", openAttachmentButton = new JButton());
        
        openAttachmentButton.setName("openAttachmentButton");
        openAttachmentButton.setToolTipText(t("faxtomail.attachmentEditor.action.open.tip"));
        openAttachmentButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__openAttachmentButton"));
    }

    protected void createRemoveAttachmentButton() {
        $objectMap.put("removeAttachmentButton", removeAttachmentButton = new JButton());
        
        removeAttachmentButton.setName("removeAttachmentButton");
        removeAttachmentButton.setToolTipText(t("faxtomail.attachmentEditor.action.remove.tip"));
        removeAttachmentButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeAttachmentButton"));
    }

    protected void createToolbar() {
        $objectMap.put("toolbar", toolbar = new JToolBar());
        
        toolbar.setName("toolbar");
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToAttachmentPanel();
        addChildrenToToolbar();
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 6 property setters
        setBorder( BorderFactory.createLineBorder(Color.LIGHT_GRAY) );
        attachmentNameLabel.setIcon(SwingUtil.createActionIcon("attachment"));
        attachmentNameLabel.setBorder( BorderFactory.createEmptyBorder(3, 3, 3, 3) );
        openAttachmentButton.setIcon(SwingUtil.createActionIcon("open-file"));
        removeAttachmentButton.setIcon(SwingUtil.createActionIcon("delete"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("attachmentPanel", attachmentPanel);
        createAttachmentFile();
        createHandler();
        createAttachmentNameLabel();
        createToolbar();
        createOpenAttachmentButton();
        createRemoveAttachmentButton();
        // inline creation of attachmentPanel
        setName("attachmentPanel");
        setLayout(new BorderLayout());
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ATTACHMENT_NAME_LABEL_TEXT, true, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("attachmentFile", this);
                if (getAttachmentFile() != null) {
                    getAttachmentFile().addPropertyChangeListener("filename", this);
                }
                if (getAttachmentFile() != null) {
                    getAttachmentFile().addPropertyChangeListener("length", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getAttachmentFile() != null) {
                    attachmentNameLabel.setText(t( t("faxtomail.reply.attachment.label", getAttachmentFile().getFilename(), getAttachmentFile().getLength() / 1024) ));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("attachmentFile", this);
                if (getAttachmentFile() != null) {
                    getAttachmentFile().removePropertyChangeListener("filename", this);
                }
                if (getAttachmentFile() != null) {
                    getAttachmentFile().removePropertyChangeListener("length", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_ATTACHMENT_BUTTON_VISIBLE, true ,"handler") {
        
            @Override
            public void processDataBinding() {
                if (getHandler() != null && getHandler().getModel() != null) {
                    removeAttachmentButton.setVisible( !getHandler().getModel().isReadonly() );
                }
            }
        });
    }

}