package com.franciaflex.faxtomail.ui.swing.content.demande.demandgroup;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.util.AbstractToolbarPopupUI;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n.t;

public class DemandGroupUI extends AbstractToolbarPopupUI<com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel, DemandGroupUIHandler> {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1UwU5TQRSdVlooqCgEhIBJQRdozJSNK4yCNCikqLGSELtx2hnK4LyZcd48+9Bo/AQ/QfduTNy5Mi5cu3Bj/AVjXLg13pmWviKPSOzi9WXuPeeeuT2nb76jXGjQzA6JY2wiaXnA8NrS5ubt+g5r2DILG4ZrqwxqfzJZlK2hIdo9Dy06V6s4eKkDLy2rQCvJZA96oYIGQ7srWLjNmLXo7H5EIwxL1W55IdaR2WPtikpjffXzR/YlffE6i1CsQV0erlL8Fyq5SV8FZTm1aAQmPSYlQWQTZBgum6D3hDtbFiQMb5GAPULPUX8F5TUxQGbR7NGv7Dk8PtYWjTaNijSjZRYQScucCNW0qNJQAd4yRDY42RIsxlsktiogXOCI47AFknBDSQsTMPVI1vn2dLjNdsO9b6xq7cflLcoFijJh0dJ/0Lcp2cbquuNIOPvqiu5aNKNME++ADx5apdsUMV7bvMetYPQOkb2QSZrIuw7oasMoIVyTRWfcmuOOhrWk4qDDXYYCaJWeFX6tfQh/6LpGus1DPeMsmjpEKKkLP2RMg2mm9pkG7IgTOyZ+ydRQzkRwbNFE7aCD70Kp7d2Jv7zrCH319/jol/ff3q3sGbYPZo+ltvbkDYykjdLMWO5GD7fdGlkuSutEL9RQIWQCwurDOJ0irNopgziYd9rBsYPjmyTcBopc/9cPH8cffD6GsitoUChCV4jrX0UFu21gC0rQWF9b9IqOtwbgecppg1UHXPIgCqr8CSxq9mlRslbR85OWxWUQIEOu5Nzl+flLxfkLxWcxbGc6ZTtdifXCp1+j1beLexvKgOLJQ9uTLeXuozyXgkvmQ93Ja2qIh3TIIqqSXKYlFaVHVXdcXfTP82k7yVmXATBeErIeQ2JfjSMHn/P3c28XUSdYR+AfYJRb516AWBOlcvVG4AiUeUF2VQR/ayevUGJJsc4lhZxcPUCdcc9xYPwDxgJubTgGAAA=";
    private static final Log log = LogFactory.getLog(DemandGroupUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JXTable demandGroup;
    protected JScrollPane demandGroupBodyScrollPane;
    protected DemandGroupUI groupedDemandDialog = this;
    protected final DemandGroupUIHandler handler = new DemandGroupUIHandler();
    protected JPanel mainPanel;
    protected DemandeUIModel model;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DemandGroupUI(FaxToMailUIContext param0) {
        super(param0);
        $initialize();
    }

    public DemandGroupUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Frame param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DemandGroupUI() {
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public DemandGroupUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Frame param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandGroupUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Frame param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DemandGroupUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Dialog param1, String param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public DemandGroupUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public DemandGroupUI(Window param0) {
        super(param0);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Window param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandGroupUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public DemandGroupUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Window param1, String param2, ModalityType param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public DemandGroupUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Window param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DemandGroupUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Frame param1, String param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public DemandGroupUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public DemandGroupUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Window param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DemandGroupUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Dialog param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandGroupUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Dialog param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public DemandGroupUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandGroupUI(JAXXContext param0, Dialog param1, String param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JXTable getDemandGroup() {
        return demandGroup;
    }

    public JScrollPane getDemandGroupBodyScrollPane() {
        return demandGroupBodyScrollPane;
    }

    public DemandGroupUIHandler getHandler() {
        return handler;
    }

    public JPanel getMainPanel() {
        return mainPanel;
    }

    public DemandeUIModel getModel() {
        return model;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(demandGroupBodyScrollPane);
    }

    protected void addChildrenToDemandGroupBodyScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        demandGroupBodyScrollPane.getViewport().add(mainPanel);
    }

    protected void addChildrenToMainPanel() {
        if (!allComponentsCreated) {
            return;
        }
        mainPanel.add(demandGroup, BorderLayout.CENTER);
    }

    @Override
    protected void createBody() {
        super.createBody();
        body.setName("body");
        body.setTitle(t("faxtomail.demandGroup.title"));
    }

    protected void createDemandGroup() {
        $objectMap.put("demandGroup", demandGroup = new JXTable());
        
        demandGroup.setName("demandGroup");
        demandGroup.setEditable(true);
    }

    protected void createDemandGroupBodyScrollPane() {
        $objectMap.put("demandGroupBodyScrollPane", demandGroupBodyScrollPane = new JScrollPane());
        
        demandGroupBodyScrollPane.setName("demandGroupBodyScrollPane");
    }

    protected void createMainPanel() {
        $objectMap.put("mainPanel", mainPanel = new JPanel());
        
        mainPanel.setName("mainPanel");
        mainPanel.setLayout(new BorderLayout());
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(DemandeUIModel.class));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToBody();
        addChildrenToDemandGroupBodyScrollPane();
        addChildrenToMainPanel();
        
        // apply 2 property setters
        setMinimumSize( new java.awt.Dimension(500, 0) );
        // late initializer
        groupedDemandDialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("groupedDemandDialog", groupedDemandDialog);
        createModel();
        createDemandGroupBodyScrollPane();
        createMainPanel();
        createDemandGroup();
        // inline creation of groupedDemandDialog
        setName("groupedDemandDialog");
        
        $completeSetup();
        handler.afterInit(this);
    }

}