package com.franciaflex.faxtomail.ui.swing.content.demande;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.DemandType;
import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.EtatAttente;
import com.franciaflex.faxtomail.persistence.entities.MailAction;
import com.franciaflex.faxtomail.ui.swing.actions.ArchiveAction;
import com.franciaflex.faxtomail.ui.swing.actions.GoToPreviousScreenAction;
import com.franciaflex.faxtomail.ui.swing.actions.SaveAndOpenDialogAction;
import com.franciaflex.faxtomail.ui.swing.actions.SaveDemandeAndExitAction;
import com.franciaflex.faxtomail.ui.swing.content.print.AttachmentToPrintChooserUI;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUI;
import com.franciaflex.faxtomail.ui.swing.content.reply.ReplyFormUIModel;
import com.franciaflex.faxtomail.ui.swing.content.search.SearchToGroupUI;
import com.franciaflex.faxtomail.ui.swing.content.transmit.MailFolderChooserUI;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailUIHandler;
import com.franciaflex.faxtomail.ui.swing.util.CloseableUI;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.tab.CustomTab;
import org.nuiton.jaxx.application.swing.tab.DelegateTabContainerHandler;
import org.nuiton.jaxx.application.swing.tab.TabContainerHandler;
import org.nuiton.jaxx.application.swing.tab.TabContentModel;
import org.nuiton.jaxx.application.swing.tab.TabHandler;
import org.nuiton.util.beans.BeanMonitor;

import javax.swing.*;
import java.awt.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import java.util.Set;

import static org.nuiton.i18n.I18n.t;

/**
 * @author Kevin Morin (Code Lutin)
 * @since x.x
 */
public class DemandesUIHandler extends AbstractFaxToMailUIHandler<DemandesUIModel, DemandesUI> implements TabContainerHandler, CloseableUI {

    private static final Log log = LogFactory.getLog(DemandesUIHandler.class);

    protected DelegateTabContainerHandler delegateTabHandler;

    @Override
    public void beforeInit(DemandesUI ui) {

        super.beforeInit(ui);

        DemandeUIModel currentEmail = getContext().getCurrentEmail();
        currentEmail.setCloseable(false);

        DemandesUIModel model = new DemandesUIModel();
//        model.addDemand(currentEmail);

        this.ui.setContextValue(model);
    }

    @Override
    public void afterInit(DemandesUI demandesUI) {
        initUI(ui);

        DemandesUIModel model = getModel();
//        setCustomTab(0, getModel().getDemands().get(0));

        final PropertyChangeListener demandEnabledAndValidListener = new PropertyChangeListener() {
            @Override
            public void propertyChange(PropertyChangeEvent evt) {

                if (evt.getPropertyName().equals(DemandeUIModel.PROPERTY_VALID)
                        || evt.getPropertyName().equals(DemandeUIModel.PROPERTY_EDITABLE)
                        || evt.getPropertyName().equals(Email.PROPERTY_ARCHIVE_DATE)) {

                    DemandesUI ui = getUI();
                    ui.processDataBinding(DemandesUI.BINDING_ARCHIVE_BUTTON_ENABLED);
                    ui.processDataBinding(DemandesUI.BINDING_GROUP_BUTTON_ENABLED);
                    ui.processDataBinding(DemandesUI.BINDING_REPLY_BUTTON_ENABLED);
                    ui.processDataBinding(DemandesUI.BINDING_SAVE_BUTTON_ENABLED);
                    ui.processDataBinding(DemandesUI.BINDING_TRANSMIT_BUTTON_ENABLED);

                }

                if (evt.getPropertyName().equals(DemandeUIModel.PROPERTY_VALID)
                        || evt.getPropertyName().equals(Email.PROPERTY_ETAT_ATTENTE)) {

                    DemandeUIModel model = (DemandeUIModel) evt.getSource();
                    EtatAttente etatAttente = model.getEtatAttente();
                    boolean transmitEnabled = model.isEditable()
                            && (etatAttente == null
                                || model.isValid() && !etatAttente.containsValidFormDisabledActions(MailAction.TRANSMIT)
                                || !model.isValid() && !etatAttente.containsInvalidFormDisabledActions(MailAction.TRANSMIT));
                    getModel().setTransmitEnabled(transmitEnabled);
                }
            }
        };

        model.addDemandsListener(new DemandesUIModel.DemandsListener() {
            @Override
            public void onDemandAdded(DemandeUIModel demand, int index, boolean added) {

                JTabbedPane tabPanel = getTabPanel();
                if (added) {
                    DemandeUI demandeUI = new DemandeUI(getUI(), demand);
                    demandeUI.setName("demandPanel" + index);
                    getContext().getSwingSession().add(demandeUI, true);
                    demand.addPropertyChangeListener(demandEnabledAndValidListener);
                    tabPanel.add(demandeUI);
                    setCustomTab(index, demand);
                }

                tabPanel.setSelectedIndex(index);
            }

            @Override
            public void onDemandRemoved(DemandeUIModel demand, int index) {
                demand.removePropertyChangeListener(demandEnabledAndValidListener);
            }
        });

        DemandeUIModel currentEmail = getContext().getCurrentEmail();
        model.addDemand(currentEmail);
    }

    @Override
    public boolean quitUI() {
        closeButtonPopups();
        JTabbedPane tabPanel = getTabPanel();
        int tabCount = tabPanel.getTabCount();
        boolean quit = true;
        int i = 0;
        while (quit && i < tabCount) {
            tabPanel.setSelectedIndex(i);
            DemandeUIHandler tabHandler = (DemandeUIHandler) getTabHandler(i++);
            quit = tabHandler.quitUI();
        }
        return quit;
    }

    @Override
    public void onCloseUI() {
//        closeButtonPopups();
        int tabCount = getTabPanel().getTabCount();
        for (int i = 0 ; i < tabCount ; i++) {
            DemandeUIHandler tabHandler = (DemandeUIHandler) getTabHandler(i);
            tabHandler.onCloseUI();
        }
    }

    @Override
    public SwingValidator<DemandesUIModel> getValidator() {
        return null;
    }

    @Override
    protected JComponent getComponentToFocus() {
        return null;
    }

    /**
     * Returns the tab handler of the tab i.
     *
     * @param index the index of the tab
     * @return the tab handler of the index i if the handler implements
     * the {@link org.nuiton.jaxx.application.swing.tab.TabHandler} interface,
     * <code>null</code> otherwise
     */
    @Override
    public TabHandler getTabHandler(int index) {
        TabHandler tabHandler = null;
        JTabbedPane tabPanel = getTabPanel();
        if (index >= 0 && index < tabPanel.getTabCount()) {
            Component tab = tabPanel.getComponentAt(index);
            if (ApplicationUI.class.isInstance(tab)) {
                ApplicationUI tuttiTab = (ApplicationUI) tabPanel.getComponentAt(index);
                AbstractApplicationUIHandler handler = tuttiTab.getHandler();
                if (TabHandler.class.isInstance(handler)) {
                    tabHandler = (TabHandler) handler;
                }
            }
        }
        return tabHandler;
    }

    @Override
    public void setCustomTab(int index, TabContentModel model) {
        JTabbedPane tabPanel = getTabPanel();
        tabPanel.setTabComponentAt(index, new CustomTab(model, this));
    }

    @Override
    public boolean removeTab(int i) {
        TabHandler tabHandler = getTabHandler(i);
        boolean remove = tabHandler.onRemoveTab();
        if (remove) {
            getTabPanel().removeTabAt(i);
            getModel().removeDemand(i);
        }
        return remove;
    }

    @Override
    protected void initUI(DemandesUI ui) {
        super.initUI(ui);
        init();
    }

    @Override
    public JTabbedPane getTabPanel() {
        return getUI().getDemandsTabPane();
    }

    @Override
    public void init() {
        getTabPanel().setModel(new DefaultSingleSelectionModel() {

            private static final long serialVersionUID = 1L;

            @Override
            public void setSelectedIndex(int index) {
                int currentIndex = getTabPanel().getSelectedIndex();
                boolean mustChangeTab = onTabChanged(currentIndex, index);

                if (mustChangeTab) {
                    super.setSelectedIndex(index);
                }
            }

        });
    }

    @Override
    public boolean onTabChanged(int currentIndex, int newIndex) {
        boolean change = true;
        if (currentIndex != newIndex) {
            TabHandler handler = getTabHandler(currentIndex);
            if (handler != null) {
                change = handler.onHideTab(currentIndex, newIndex);
            }

            handler = getTabHandler(newIndex);
            if (handler != null) {
                handler.onShowTab(currentIndex, newIndex);
            }
        }
        if (change) {
            getModel().setCurrentIndex(newIndex);
        }
        return change;
    }

    protected void closeButtonPopups() {
        DemandeUI demandeUI = (DemandeUI) getTabPanel().getSelectedComponent();
        demandeUI.getHandler().closeButtonPopups();
        ui.getDemandGroupButton().setSelected(false);
    }

    public void save() {
        closeButtonPopups();
        DemandeUI demandeUI = (DemandeUI) getTabPanel().getSelectedComponent();
        SaveDemandeAndExitAction action = new SaveDemandeAndExitAction(demandeUI.getHandler());
        getContext().getActionFactory().createUIAction(null, action).actionPerformed(null);
    }

    public void transmitDemande() {
        closeButtonPopups();

        DemandeUI demandeUI = (DemandeUI) getTabPanel().getSelectedComponent();
        MailFolderChooserUI dialogContent = new MailFolderChooserUI(ui, demandeUI.getModel());
        SaveAndOpenDialogAction action = new SaveAndOpenDialogAction(demandeUI.getHandler(),
                                                                     true,
                                                                     dialogContent,
                                                                     t("faxtomail.chooseMailFolder.title"),
                                                                     new Dimension(350, 500));

        getContext().getActionFactory().createUIAction(null, action).actionPerformed(null);
    }

    public void print() {
        closeButtonPopups();

//        for (Attachment attachment : getModel().getAttachment()) {
////            try {
//                File editedFile = attachment.getEditedFile();
//                if (editedFile == null) {
//                    editedFile = attachment.getOriginalFile();
//                }
//                log.info("print " + editedFile.getAbsolutePath());
////                Desktop.getDesktop().print(editedFile);
//
//
////            } catch (IOException e) {
////                if (log.isErrorEnabled()) {
////                    log.error("", e);
////                }
////            }
//        }

        DemandeUI demandeUI = (DemandeUI) getTabPanel().getSelectedComponent();
        AttachmentToPrintChooserUI dialogContent = new AttachmentToPrintChooserUI(ui, demandeUI.getModel());
        SaveAndOpenDialogAction action = new SaveAndOpenDialogAction(demandeUI.getHandler(),
                                                                     true,
                                                                     dialogContent,
                                                                     t("faxtomail.chooseAttachmentToPrint.title"),
                                                                     new Dimension(350, 500));

        getContext().getActionFactory().createUIAction(null, action).actionPerformed(null);
    }

    public void archive() {
        closeButtonPopups();
        DemandeUI demandeUI = (DemandeUI) getTabPanel().getSelectedComponent();
        ArchiveAction action = new ArchiveAction(demandeUI.getHandler());
        getContext().getActionFactory().createUIAction(null, action).actionPerformed(null);
    }

    public void reply() {
        closeButtonPopups();

        ReplyFormUI dialogContent = new ReplyFormUI(ui);
        ReplyFormUIModel model = dialogContent.getModel();
        DemandeUIModel currentDemand = getModel().getCurrentDemand();

        model.setOriginalDemand(currentDemand);

        model.setTo(currentDemand.getSender());
        DemandeUI demandeUI = (DemandeUI) getTabPanel().getSelectedComponent();
        SaveAndOpenDialogAction action = new SaveAndOpenDialogAction(demandeUI.getHandler(),
                                                                     false,
                                                                     dialogContent,
                                                                     t("faxtomail.reply.title", currentDemand.getObject()),
                                                                     new Dimension(800, 600));

        getContext().getActionFactory().createUIAction(null, action).actionPerformed(null);
    }

    public void group() {
        closeButtonPopups();

        SearchToGroupUI dialogContent = new SearchToGroupUI(ui);
        DemandeUI demandeUI = (DemandeUI) getTabPanel().getSelectedComponent();
        SaveAndOpenDialogAction action = new SaveAndOpenDialogAction(demandeUI.getHandler(),
                                                                     false,
                                                                     dialogContent,
                                                                     t("faxtomail.searchToGroup.title", demandeUI.getModel().getObject()),
                                                                     getContext().getMainUI().getSize());

        getContext().getActionFactory().createUIAction(null, action).actionPerformed(null);
    }

}
