package com.franciaflex.faxtomail.ui.swing.actions;

/*
 * #%L
 * FaxToMail :: UI
 * $Id: GenerateAnnotatedAttachmentAction.java 86 2014-05-21 19:30:41Z kmorin $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.2/faxtomail-ui-swing/src/main/java/com/franciaflex/faxtomail/ui/swing/actions/GenerateAnnotatedAttachmentAction.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Insets;
import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;

import javax.swing.JTextArea;

import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;

import com.franciaflex.faxtomail.persistence.entities.AttachmentFile;
import com.franciaflex.faxtomail.ui.swing.content.attachment.AttachmentEditorUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorCrossUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorHighlighterUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorLineUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorNoteUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorUI;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.pdfeditor.PDFEditorUIModel;
import com.franciaflex.faxtomail.ui.swing.util.JImagePanel;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.Image;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfAction;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfGState;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfWriter;
import com.sun.media.jai.codec.ByteArraySeekableStream;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.pdfview.PDFFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.css.Rect;

import static org.nuiton.i18n.I18n.t;

/**
 * @author Kevin Morin (Code Lutin)
 * @since x.x
 */
public class GenerateAnnotatedAttachmentAction extends AbstractFaxToMailAction<PDFEditorUIModel, PDFEditorUI, PDFEditorUIHandler> {

    private static final Log log = LogFactory.getLog(GenerateAnnotatedAttachmentAction.class);

    public GenerateAnnotatedAttachmentAction(PDFEditorUIHandler handler) {
        super(handler, true);
        setActionDescription(t("faxtomail.action.generateAnnotatedAttachment.tip"));
    }

    @Override
    public void doAction() throws Exception {

        AttachmentFile attachmentFile = getModel().getNotNullFile();
        File file = attachmentFile.getFile();

        PDFEditorUIModel model = getModel();

        //File file = model.getNotNullFile();

//        InputStream inputStream;
//        if (FaxToMailUIUtil.isFileAPDF(file)) {
//            inputStream = new FileInputStream(file);

//        } else if (FaxToMailUIUtil.isFileATxt(file)) {
//            File target = handler.convertTextToPdf(file);
//            inputStream = new FileInputStream(target);
//
//        } else {
//
//
        InputStream inputStream = new FileInputStream(file);
//        }

        PdfReader pdfReader = new PdfReader(inputStream);

        //File target = new File(FileUtils.getTempDirectory(), getModel().getOriginalFile().getName() + "-annoté.pdf");
        File target = File.createTempFile("faxtomail-", ".tmp");
        target.deleteOnExit();

        FileOutputStream fos = new FileOutputStream(target);
        PdfStamper pdfStamper = new PdfStamper(pdfReader, fos);

        int pageNb = model.getPages().length;
        float zoom = model.getZoom();
        int rotation = model.getRotation();

        for (int i = 0 ; i < pageNb ; i++) {
            PdfContentByte cb = pdfStamper.getOverContent(i + 1);

            PdfDictionary pageDict;
            pageDict = pdfReader.getPageN(i + 1);
            int pageRotation = pdfReader.getPageRotation(i + 1);
            pageDict.put(PdfName.ROTATE, new PdfNumber((360 + pageRotation + rotation) % 360));

            for (PDFEditorNoteUI note : model.getPages()[i].getNotes()) {

                Point location = note.getLocation();
                int width = (int) (note.getWidth() / zoom);
                int height = (int) (note.getHeight() / zoom);
                int x = (int) (location.x / zoom);
                int y = (int) ((getUI().getContainer().getHeight() - location.y) / zoom) - height;
                Insets insets = note.getInsets();

                cb.saveState();
                cb.setColorFill(BaseColor.YELLOW);
                cb.rectangle(x, y, width, height);
                cb.fill();
                cb.restoreState();

                cb.saveState();
                JTextArea textArea = note.getNoteText();
                float fontSize = textArea.getFont().getSize2D() / zoom;
                cb.setFontAndSize(BaseFont.createFont(BaseFont.HELVETICA_OBLIQUE, BaseFont.WINANSI, BaseFont.NOT_EMBEDDED), fontSize * 1.3f);

                ColumnText ct = new ColumnText(cb);
                ct.setSimpleColumn(x + insets.left, y + insets.bottom, x + insets.left + width - insets.right, y + insets.bottom + height - insets.top);
                ct.setLeading(fontSize + 3);

                ct.addText(new Phrase(note.getTitle()));
                ct.go();

                String text = note.getText();
                String[] rows = text.split("\n");
                for (String s : rows) {
                    if (s.isEmpty()) {
                        s = " ";
                    }
                    ct.addText(new Phrase(s));
                    ct.go();
                }

                cb.restoreState();
            }

            for (PDFEditorCrossUI panel : model.getPages()[i].getCrosses()) {

                Point location = panel.getLocation();
                int width = (int) (panel.getWidth() / zoom);
                int height = (int) (panel.getHeight() / zoom);
                int x = (int) (location.x / zoom);
                int y = (int) ((getUI().getContainer().getHeight() - location.y) / zoom) - height;

                cb.saveState();
                cb.setColorStroke(BaseColor.BLUE);
                cb.moveTo(x, y);
                cb.lineTo(x + width, y + height);
                cb.stroke();
                cb.moveTo(x + width, y);
                cb.lineTo(x, y + height);
                cb.stroke();
                cb.restoreState();
            }

            for (PDFEditorLineUI panel : model.getPages()[i].getLines()) {

                Point location = panel.getLocation();
                int width = (int) (panel.getWidth() / zoom);
                int height = (int) (panel.getHeight() / zoom);
                int x = (int) (location.x / zoom);
                int y = (int) ((getUI().getContainer().getHeight() - location.y) / zoom) - height;

                if (panel.isHorizontal()) {
                    y += height / 2;
                } else {
                    x += width / 2;
                }

                cb.saveState();
                cb.setColorStroke(BaseColor.BLUE);
                cb.moveTo(x, y);
                if (panel.isHorizontal()) {
                    cb.lineTo(x + width, y);
                } else {
                    cb.lineTo(x, y + height);
                }
                cb.stroke();
                cb.restoreState();
            }

            for (PDFEditorHighlighterUI panel : model.getPages()[i].getHighlighters()) {

                Point location = panel.getLocation();
                int width = (int) (panel.getWidth() / zoom);
                int height = (int) (panel.getHeight() / zoom);
                int x = (int) (location.x / zoom);
                int y = (int) ((getUI().getContainer().getHeight() - location.y) / zoom) - height;

                cb.saveState();
                PdfGState gs1 = new PdfGState();
                gs1.setFillOpacity(0.4f);
                cb.setGState(gs1);

                cb.setColorFill(BaseColor.YELLOW);
                cb.rectangle(x, y, width, height);
                cb.fill();
                cb.restoreState();
            }
        }

        pdfStamper.close();
        pdfReader.close();

        Document document = new Document();
        PdfWriter writer = PdfWriter.getInstance(document, fos);
        PdfAction action = new PdfAction(PdfAction.PRINTDIALOG);
        writer.setOpenAction(action);

        // convert content to blob
        InputStream is = new BufferedInputStream(new FileInputStream(target));
        AttachmentFile attachmentFileNew = getContext().getEmailService().getAttachmentFileFromStream(is);
        attachmentFileNew.setFilename(FaxToMailUIUtil.getEditedFileName(getModel().getOriginalFile()));
        getModel().setEditedFile(attachmentFileNew);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();

        AttachmentEditorUI parentUI = (AttachmentEditorUI) getUI().getContextValue(JAXXContext.class, JAXXUtil.PARENT);
        parentUI.getModel().fireAttachmentEdited(getModel().toEntity());
    }
}
