/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.io;

import com.mchange.v2.io.FileIterator;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public final class DirectoryDescentUtils {
    public static FileIterator depthFirstEagerDescent(File root) throws IOException {
        return DirectoryDescentUtils.depthFirstEagerDescent(root, null, false);
    }

    public static FileIterator depthFirstEagerDescent(File root, FileFilter filter, boolean canonical) throws IOException {
        LinkedList list = new LinkedList();
        HashSet seenDirex = new HashSet();
        DirectoryDescentUtils.depthFirstEagerDescend(root, filter, canonical, list, seenDirex);
        return new IteratorFileIterator(list.iterator());
    }

    public static void addSubtree(File root, FileFilter filter, boolean canonical, Collection addToMe) throws IOException {
        HashSet seenDirex = new HashSet();
        DirectoryDescentUtils.depthFirstEagerDescend(root, filter, canonical, addToMe, seenDirex);
    }

    private static void depthFirstEagerDescend(File dir, FileFilter filter, boolean canonical, Collection addToMe, Set seenDirex) throws IOException {
        String canonicalPath = dir.getCanonicalPath();
        if (!seenDirex.contains(canonicalPath)) {
            if (filter == null || filter.accept(dir)) {
                addToMe.add(canonical ? new File(canonicalPath) : dir);
            }
            seenDirex.add(canonicalPath);
            String[] babies = dir.list();
            int len = babies.length;
            for (int i = 0; i < len; ++i) {
                File baby = new File(dir, babies[i]);
                if (baby.isDirectory()) {
                    DirectoryDescentUtils.depthFirstEagerDescend(baby, filter, canonical, addToMe, seenDirex);
                    continue;
                }
                if (filter != null && !filter.accept(baby)) continue;
                addToMe.add(canonical ? baby.getCanonicalFile() : baby);
            }
        }
    }

    private DirectoryDescentUtils() {
    }

    public static void main(String[] argv) {
        try {
            FileIterator fii = DirectoryDescentUtils.depthFirstEagerDescent(new File(argv[0]));
            while (fii.hasNext()) {
                System.err.println(fii.nextFile().getPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class IteratorFileIterator
    implements FileIterator {
        Iterator ii;
        Object last;

        IteratorFileIterator(Iterator ii) {
            this.ii = ii;
        }

        public File nextFile() throws IOException {
            return (File)this.next();
        }

        public boolean hasNext() throws IOException {
            return this.ii.hasNext();
        }

        public Object next() throws IOException {
            this.last = this.ii.next();
            return this.last;
        }

        public void remove() throws IOException {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            ((File)this.last).delete();
            this.last = null;
        }

        public void close() throws IOException {
        }
    }
}

