/*
 * Decompiled with CFR 0.152.
 */
package com.franciaflex.faxtomail.ui.swing.content.demande;

import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractBean;

public class DemandesUIModel
extends AbstractBean {
    private static final Log log = LogFactory.getLog(DemandesUIModel.class);
    public static final String PROPERTY_CURRENT_DEMAND = "currentDemand";
    protected List<DemandeUIModel> demands = new ArrayList<DemandeUIModel>();
    protected List<DemandsListener> listeners = new ArrayList<DemandsListener>();
    protected int currentIndex = -1;

    protected List<DemandeUIModel> getDemands() {
        return this.demands;
    }

    public void addDemand(DemandeUIModel demand) {
        boolean added;
        boolean bl = added = !this.demands.contains(demand);
        if (added) {
            this.demands.add(demand);
        }
        int index = this.demands.indexOf(demand);
        this.fireDemandAdded(demand, index, added);
    }

    public void removeDemand(int i) {
        DemandeUIModel demand = this.demands.get(i);
        this.demands.remove(i);
        this.fireDemandRemoved(demand, i);
    }

    public void addDemandsListener(DemandsListener listener) {
        this.listeners.add(listener);
    }

    public void removeDemandsListener(DemandsListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireDemandAdded(DemandeUIModel demand, int index, boolean added) {
        for (DemandsListener listener : this.listeners) {
            listener.onDemandAdded(demand, index, added);
        }
    }

    protected void fireDemandRemoved(DemandeUIModel demand, int index) {
        for (DemandsListener listener : this.listeners) {
            listener.onDemandRemoved(demand, index);
        }
    }

    public DemandeUIModel getCurrentDemand() {
        int currentIndex = this.getCurrentIndex();
        if (currentIndex < 0 || currentIndex >= this.demands.size()) {
            return null;
        }
        return this.demands.get(currentIndex);
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int currentIndex) {
        DemandeUIModel oldValue = this.getCurrentDemand();
        this.currentIndex = currentIndex;
        DemandeUIModel newValue = this.getCurrentDemand();
        this.firePropertyChange(PROPERTY_CURRENT_DEMAND, oldValue, newValue);
    }

    public static interface DemandsListener {
        public void onDemandAdded(DemandeUIModel var1, int var2, boolean var3);

        public void onDemandRemoved(DemandeUIModel var1, int var2);
    }
}

