package com.franciaflex.faxtomail.ui.swing.content.demande;

/*
 * #%L
 * FaxToMail :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.ui.swing.FaxToMailUIContext;
import com.franciaflex.faxtomail.ui.swing.content.demande.demandgroup.ButtonEmailGroup;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUI;
import com.franciaflex.faxtomail.ui.swing.util.FaxToMailUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class DemandesUI extends JPanel implements FaxToMailUI<DemandesUIModel, DemandesUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ARCHIVE_BUTTON_ENABLED = "archiveButton.enabled";
    public static final String BINDING_GROUP_BUTTON_ENABLED = "groupButton.enabled";
    public static final String BINDING_REPLY_BUTTON_ENABLED = "replyButton.enabled";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_TRANSMIT_BUTTON_ENABLED = "transmitButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAANVWz28bRRQeu7ETO01KGyipaCWXVqG5jCtxDIHmR1MSJSQiaVVhqXR2d+xMGe9MZ2bTjdoi7nDgT4A7FyRunBAHzhy4IP4FhDhwRbyZtb3eeu049FRL3rXej2++92beN/7uT1TSCl19ROIYqyg0rE3x1sr9+7veI+qbdap9xaQRCiWfQhEVG2g66Nm1Qdca2za93kmvr4m2FCEN+7KXtlFVm2NO9SGlxqAr2Qxf6/p+z70Uy0h1UXuk8lC/+fuv4tfBF98WEYolsJuBUmonZaWVTGyjIgsMugArHZE6J2ELaCgWtoDvjLWtcaL1R6RNH6PP0eQ2KkuiAMygt8cv2WG4/FgadDagbRIGeo+ElBu07Is2bioS+ow0OY1xk8RGtAnjOGJYPwEu2BehAWicZFK8nrz13U0pHXDZoFJbBBZv9aXwdixIClo1Qh4IwVeJMuh124+4A7HVMdvASi/+fIJ4R4lIrkbGwDpo938QSt4tC4MTnNs2weHapc71VpztdPOAeLahBr2ZZUk8jwbWkyU6dX3L9f8m7H0mwVmzsVWP+J91q5nLRCdWGzefhmtyRFPHlax31kAndJuZoRHTEs7fcPcMUf4hG7HCtKKSHw93t9LN6Xcr9FZmbmAicTqR6cgUGqikIjAbNN8YHOKPwZWM7/wL42sBnfffi3O//fjHDxvdma3C2m/khvZJDsySVEJSZZhd+lwysJFhvL5D5FIDVTTloFdOjy7nENvvuIEcrHfepmObjj8k+hAgSpO///TzxYe/nkHFDVTlggQbxMZvooo5VNAFwYNYfnDLMTr7ZAqer8H3jEGVJkQb4nFoU6lJuIZ3WUjyOOozzHhCBVTtEdhbGnTtMfTpck6femS9yi//zO1/f6vbqwJwvzQ0PO1X6RNUZiFnIXUK1xGvXEWblppGgUhFKk+2UEYLZEch6u75bl5TJgyNQSWvpcPenW07Tdhz5w9z4lnNqkKnmQg3rQygsg9SYa0XPiVScuYT61txEQbtPK2NoScJnsZ3xIHYU/SIiUjv+4rSDg72bW2153FkC1hyjbW/llFm3Meoc5KGdudhRxef1pwE4xY1a5FS7i6wJd9YxEzfDpg7IjcWa89HdceKx6juTNiAXNqp7JyK9u5I2vcIZ/CrtrBw6uLeGSyuq32jCpzqBuUV+YJ6nlRosUfm+iAZJ7OjmJRcRB6Nfokeg8NLnZGFQeadGyDDPY9m9qo41al4MC7RZ8+GB4JpJWGwTowNvrpcCyPO+6rL2Rd3fY3cFxeRuy99V9+rUm7yJ2dUuS4it9y+q/ykcgsgrJwcCwhGs+8FcF/VPBYGIJbvD0AX7LN6IqI1f2kfX+UjXAKE/wDgfQRXXgwAAA==";
    private static final Log log = LogFactory.getLog(DemandesUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton archiveButton;
    protected JButton backButton;
    protected ButtonEmailGroup demandGroupButton;
    protected DemandesUI demandsPanel = this;
    protected JTabbedPane demandsTabPane;
    protected JButton groupButton;
    protected final DemandesUIHandler handler = new DemandesUIHandler();
    protected DemandesUIModel model;
    protected JButton printButton;
    protected JButton replyButton;
    protected JButton saveButton;
    protected JToolBar topToolBar;
    protected JButton transmitButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public DemandesUI(FaxToMailUI parentUI) {
        FaxToMailUIUtil.setParentUI(this, parentUI);
            $initialize();
    }

    public DemandesUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public DemandesUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemandesUI() {
        $initialize();
    }

    public DemandesUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemandesUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public DemandesUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public DemandesUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public DemandesUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__archiveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.archive();
    }

    public void doActionPerformed__on__groupButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.group();
    }

    public void doActionPerformed__on__printButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.print();
    }

    public void doActionPerformed__on__replyButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.reply();
    }

    public void doActionPerformed__on__saveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.save();
    }

    public void doActionPerformed__on__transmitButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.transmitDemande();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getArchiveButton() {
        return archiveButton;
    }

    public JButton getBackButton() {
        return backButton;
    }

    public ButtonEmailGroup getDemandGroupButton() {
        return demandGroupButton;
    }

    public JTabbedPane getDemandsTabPane() {
        return demandsTabPane;
    }

    public JButton getGroupButton() {
        return groupButton;
    }

    public DemandesUIHandler getHandler() {
        return handler;
    }

    public DemandesUIModel getModel() {
        return model;
    }

    public JButton getPrintButton() {
        return printButton;
    }

    public JButton getReplyButton() {
        return replyButton;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JToolBar getTopToolBar() {
        return topToolBar;
    }

    public JButton getTransmitButton() {
        return transmitButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToDemandsPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(topToolBar);
        add(demandsTabPane, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToTopToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        topToolBar.add(demandGroupButton);
    }

    protected void createArchiveButton() {
        $objectMap.put("archiveButton", archiveButton = new JButton());
        
        archiveButton.setName("archiveButton");
        archiveButton.setText(t("faxtomail.demande.archive.button.label"));
        archiveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__archiveButton"));
    }

    protected void createBackButton() {
        $objectMap.put("backButton", backButton = new JButton());
        
        backButton.setName("backButton");
        backButton.setText(t("faxtomail.demande.back.button.label"));
        backButton.putClientProperty("applicationAction",  com.franciaflex.faxtomail.ui.swing.actions.GoToPreviousScreenAction.class );
    }

    protected void createDemandGroupButton() {
        $objectMap.put("demandGroupButton", demandGroupButton = new ButtonEmailGroup());
        
        demandGroupButton.setName("demandGroupButton");
    }

    protected void createDemandsTabPane() {
        $objectMap.put("demandsTabPane", demandsTabPane = new JTabbedPane());
        
        demandsTabPane.setName("demandsTabPane");
    }

    protected void createGroupButton() {
        $objectMap.put("groupButton", groupButton = new JButton());
        
        groupButton.setName("groupButton");
        groupButton.setText(t("faxtomail.demande.group.button.label"));
        groupButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__groupButton"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(DemandesUIModel.class));
    }

    protected void createPrintButton() {
        $objectMap.put("printButton", printButton = new JButton());
        
        printButton.setName("printButton");
        printButton.setText(t("faxtomail.demande.print.button.label"));
        printButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__printButton"));
    }

    protected void createReplyButton() {
        $objectMap.put("replyButton", replyButton = new JButton());
        
        replyButton.setName("replyButton");
        replyButton.setText(t("faxtomail.demande.reply.button.label"));
        replyButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__replyButton"));
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(t("faxtomail.demande.save.button.label"));
        saveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveButton"));
    }

    protected void createTopToolBar() {
        $objectMap.put("topToolBar", topToolBar = new JToolBar());
        
        topToolBar.setName("topToolBar");
        topToolBar.setFloatable(false);
        topToolBar.setOpaque(false);
        topToolBar.setBorderPainted(false);
    }

    protected void createTransmitButton() {
        $objectMap.put("transmitButton", transmitButton = new JButton());
        
        transmitButton.setName("transmitButton");
        transmitButton.setText(t("faxtomail.demande.transmit.button.label"));
        transmitButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__transmitButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToDemandsPanel();
        addChildrenToTopToolBar();
        // inline complete setup of $JPanel0
        $JPanel0.add(backButton);
        $JPanel0.add(saveButton);
        $JPanel0.add(transmitButton);
        $JPanel0.add(printButton);
        $JPanel0.add(archiveButton);
        $JPanel0.add(replyButton);
        $JPanel0.add(groupButton);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 8 property setters
        backButton.setIcon(SwingUtil.createActionIcon("cancel"));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        transmitButton.setIcon(SwingUtil.createActionIcon("transmit"));
        printButton.setIcon(SwingUtil.createActionIcon("print"));
        replyButton.setIcon(SwingUtil.createActionIcon("reply"));
        groupButton.setIcon(SwingUtil.createActionIcon("group"));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("demandsPanel", demandsPanel);
        createModel();
        createTopToolBar();
        createDemandGroupButton();
        createDemandsTabPane();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createBackButton();
        createSaveButton();
        createTransmitButton();
        createPrintButton();
        createArchiveButton();
        createReplyButton();
        createGroupButton();
        // inline creation of demandsPanel
        setName("demandsPanel");
        setLayout( new BorderLayout() );
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("currentDemand", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getCurrentDemand() != null) {
                    saveButton.setEnabled( model.getCurrentDemand().isEditable() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("currentDemand", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TRANSMIT_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("currentDemand", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getCurrentDemand() != null) {
                    transmitButton.setEnabled( model.getCurrentDemand().isValid() && model.getCurrentDemand().isEditable() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("currentDemand", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ARCHIVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("currentDemand", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getCurrentDemand() != null) {
                    archiveButton.setEnabled( model.getCurrentDemand().isEditable() );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("currentDemand", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REPLY_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("currentDemand", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getCurrentDemand() != null) {
                    replyButton.setEnabled( model.getCurrentDemand().isEditable() || model.getCurrentDemand().getArchiveDate() != null );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("currentDemand", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GROUP_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("currentDemand", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getCurrentDemand() != null) {
                    groupButton.setEnabled( model.getCurrentDemand().isEditable() || model.getCurrentDemand().getArchiveDate() != null );
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("currentDemand", this);
                }
            }
        });
    }

}