package com.franciaflex.faxtomail.ui.swing.content.attachment;

/*
 * #%L
 * FaxToMail :: UI
 * $Id: AttachmentEditorUIModel.java 85 2014-05-21 18:23:57Z kmorin $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.1/faxtomail-ui-swing/src/main/java/com/franciaflex/faxtomail/ui/swing/content/attachment/AttachmentEditorUIModel.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.franciaflex.faxtomail.persistence.entities.Attachment;
import com.franciaflex.faxtomail.ui.swing.util.AbstractFaxToMailBeanUIModel;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * @author Kevin Morin (Code Lutin)
 * @since x.x
 */
public class AttachmentEditorUIModel extends AbstractFaxToMailBeanUIModel<AttachmentModelAware, AttachmentEditorUIModel> {

    //public static final String PROPERTY_FILE = "file";
    public static final String PROPERTY_EDITABLE = "editable";

    //protected File file;
    protected boolean editable = true;

    protected final Collection<Attachment> attachments = new ArrayList<Attachment>();

    protected List<AttachmentListener> openingListeners = new ArrayList<AttachmentListener>();

    protected static Binder<AttachmentEditorUIModel, AttachmentModelAware> toBeanBinder =
            BinderFactory.newBinder(AttachmentEditorUIModel.class,
                                    AttachmentModelAware.class);

    protected static Binder<AttachmentModelAware, AttachmentEditorUIModel> fromBeanBinder =
            BinderFactory.newBinder(AttachmentModelAware.class, AttachmentEditorUIModel.class);

    protected AttachmentEditorUIModel() {
        super(fromBeanBinder, toBeanBinder);
    }

    /*public File getFile() {
        return file;
    }

    public void setFile(File file) {
        Object oldValue = getFile();
        this.file = file;
        firePropertyChange(PROPERTY_FILE, oldValue, file);
    }*/

    public boolean isEditable() {
        return editable;
    }

    public void setEditable(boolean editable) {
        Object oldValue = isEditable();
        this.editable = editable;
        firePropertyChange(PROPERTY_EDITABLE, oldValue, editable);
    }

    public Collection<Attachment> getAttachment() {
        return attachments;
    }

    public void addAllAttachment(Collection<Attachment> attachments) {
        Object oldValue = new ArrayList<Attachment>(getAttachment());
        this.attachments.addAll(attachments);
        firePropertyChange(AttachmentModelAware.PROPERTY_ATTACHMENT, oldValue, this.attachments);
    }

    public void addAttachment(Attachment attachment) {
        Object oldValue = new ArrayList<Attachment>(getAttachment());
        attachments.add(attachment);
        firePropertyChange(AttachmentModelAware.PROPERTY_ATTACHMENT, oldValue, attachments);
    }

    public void removeAttachment(Attachment attachment) {
        Object oldValue = new ArrayList<Attachment>(getAttachment());
        attachments.remove(attachment);
        firePropertyChange(AttachmentModelAware.PROPERTY_ATTACHMENT, oldValue, attachments);
    }

    public void setAttachment(Collection<Attachment> attachments) {
        Object oldValue = new ArrayList<Attachment>(getAttachment());
        this.attachments.clear();
        if (attachments != null) {
            this.attachments.addAll(attachments);
        }
        firePropertyChange(AttachmentModelAware.PROPERTY_ATTACHMENT, oldValue, this.attachments);
    }

    @Override
    protected AttachmentModelAware newEntity() {
        return null;
    }

    public void addAttachmentListener(AttachmentListener listener) {
        openingListeners.add(listener);
    }

    public void removeAttachmentListener(AttachmentListener listener) {
        openingListeners.remove(listener);
    }

    public void fireAttachmentOpened(Attachment attachment, boolean original) {
        for (AttachmentListener listener : openingListeners) {
            listener.onAttachmentOpened(attachment, original);
        }
    }

    public void fireAttachmentEdited(Attachment attachment) {
        for (AttachmentListener listener : openingListeners) {
            listener.onAttachmentEdited(attachment);
        }
    }

    public static interface AttachmentListener {

        public void onAttachmentOpened(Attachment attachment, boolean original);

        public void onAttachmentEdited(Attachment attachment);

    }
}
