package com.franciaflex.faxtomail.ui.swing.actions;

/*
 * #%L
 * FaxToMail :: UI
 * $Id: SearchAction.java 86 2014-05-21 19:30:41Z kmorin $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.1/faxtomail-ui-swing/src/main/java/com/franciaflex/faxtomail/ui/swing/actions/SearchAction.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.ArrayList;
import java.util.List;

import com.franciaflex.faxtomail.persistence.entities.Email;
import com.franciaflex.faxtomail.persistence.entities.EmailFilter;
import com.franciaflex.faxtomail.ui.swing.content.demande.DemandeUIModel;
import com.franciaflex.faxtomail.ui.swing.content.search.SearchUI;
import com.franciaflex.faxtomail.ui.swing.content.search.SearchUIHandler;
import com.franciaflex.faxtomail.ui.swing.content.search.SearchUIModel;

import static org.nuiton.i18n.I18n.t;

/**
 * @author Kevin Morin (Code Lutin)
 * @since x.x
 */
public class SearchAction extends AbstractFaxToMailAction<SearchUIModel, SearchUI, SearchUIHandler> {

    public SearchAction(SearchUIHandler handler) {
        super(handler, false);
        setActionDescription(t("faxtomail.action.search.tip"));
    }

    @Override
    public void doAction() throws Exception {
        SearchUIModel model = getModel();
        getContext().setSearch(model);

        EmailFilter emailFilter = model.toEntity();

        List<Email> emails = getContext().getEmailService().search(emailFilter);
        List<DemandeUIModel> result = new ArrayList<>();
        for (Email email : emails) {
            DemandeUIModel demand = new DemandeUIModel();
            demand.fromEntity(email);
            demand.setValid(handler.isDemandeValid(demand));
            result.add(demand);

            if (model.isShowGroupesDemandsInResults()) {
                demand.setGroupedDemandes(email.getEmailGroup());
                result.addAll(demand.getGroupedDemandes());
            }
        }
        model.setResults(result);
    }
}
