/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.AutoCompletePopupWindow;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ExternalURLHandler;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletionDescriptionToolTip;

public class AutoCompletion {
    private JTextComponent textComponent;
    private Window parentWindow;
    private AutoCompletePopupWindow popupWindow;
    private Dimension preferredChoicesWindowSize;
    private Dimension preferredDescWindowSize;
    private ParameterizedCompletionDescriptionToolTip descToolTip;
    private CompletionProvider provider;
    private ListCellRenderer renderer;
    private ExternalURLHandler externalURLHandler;
    private boolean showDescWindow;
    private boolean autoCompleteEnabled;
    private boolean autoActivationEnabled;
    private boolean autoCompleteSingleChoices;
    private boolean parameterAssistanceEnabled;
    private KeyStroke trigger;
    private Object oldTriggerKey;
    private Action oldTriggerAction;
    private Object oldParenKey;
    private Action oldParenAction;
    private ParentWindowListener parentWindowListener;
    private TextComponentListener textComponentListener;
    private AutoActivationListener autoActivationListener;
    private static final String PARAM_TRIGGER_KEY = "AutoComplete";
    private static final String PARAM_COMPLETE_KEY = "AutoCompletion.FunctionStart";
    private static final boolean DEBUG = AutoCompletion.initDebug();

    public AutoCompletion(CompletionProvider provider) {
        this.setChoicesWindowSize(350, 200);
        this.setDescriptionWindowSize(350, 250);
        this.setCompletionProvider(provider);
        this.setTriggerKey(AutoCompletion.getDefaultTriggerKey());
        this.setAutoCompleteEnabled(true);
        this.setAutoCompleteSingleChoices(true);
        this.setAutoActivationEnabled(false);
        this.setShowDescWindow(false);
        this.parentWindowListener = new ParentWindowListener();
        this.textComponentListener = new TextComponentListener();
        this.autoActivationListener = new AutoActivationListener();
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                String name = e.getPropertyName();
                if (name.equals("lookAndFeel")) {
                    AutoCompletion.this.updateUI();
                }
            }
        });
    }

    private void displayDescriptionToolTip(ParameterizedCompletion pc, boolean addParamListStart) {
        this.hideToolTipWindow();
        if (pc.getParamCount() == 0) {
            String text;
            CompletionProvider p = pc.getProvider();
            char end = p.getParameterListEnd();
            String string = text = end == '\u0000' ? "" : Character.toString(end);
            if (addParamListStart) {
                text = p.getParameterListStart() + text;
            }
            this.textComponent.replaceSelection(text);
            return;
        }
        this.descToolTip = new ParameterizedCompletionDescriptionToolTip(this.parentWindow, this, pc);
        try {
            int dot = this.textComponent.getCaretPosition();
            Rectangle r = this.textComponent.modelToView(dot);
            Point p = new Point(r.x, r.y);
            SwingUtilities.convertPointToScreen(p, this.textComponent);
            r.x = p.x;
            r.y = p.y;
            this.descToolTip.setLocationRelativeTo(r);
            this.descToolTip.setVisible(true, addParamListStart);
        }
        catch (BadLocationException ble) {
            UIManager.getLookAndFeel().provideErrorFeedback(this.textComponent);
            ble.printStackTrace();
        }
    }

    public void doCompletion() {
        this.refreshPopupWindow();
    }

    public int getAutoActivationDelay() {
        return this.autoActivationListener.timer.getDelay();
    }

    public boolean getAutoCompleteSingleChoices() {
        return this.autoCompleteSingleChoices;
    }

    public CompletionProvider getCompletionProvider() {
        return this.provider;
    }

    static boolean getDebug() {
        return DEBUG;
    }

    public static KeyStroke getDefaultTriggerKey() {
        int mask = 2;
        return KeyStroke.getKeyStroke(32, mask);
    }

    public ExternalURLHandler getExternalURLHandler() {
        return this.externalURLHandler;
    }

    int getLineOfCaret() {
        Document doc = this.textComponent.getDocument();
        Element root = doc.getDefaultRootElement();
        return root.getElementIndex(this.textComponent.getCaretPosition());
    }

    public ListCellRenderer getListCellRenderer() {
        return this.renderer;
    }

    protected String getReplacementText(Completion c, Document doc, int start, int len) {
        return c.getReplacementText();
    }

    public boolean getShowDescWindow() {
        return this.showDescWindow;
    }

    public JTextComponent getTextComponent() {
        return this.textComponent;
    }

    ComponentOrientation getTextComponentOrientation() {
        return this.textComponent == null ? null : this.textComponent.getComponentOrientation();
    }

    public KeyStroke getTriggerKey() {
        return this.trigger;
    }

    public boolean hideChildWindows() {
        boolean res = this.hidePopupWindow();
        return res |= this.hideToolTipWindow();
    }

    private boolean hidePopupWindow() {
        if (this.popupWindow != null && this.popupWindow.isVisible()) {
            this.popupWindow.setVisible(false);
            return true;
        }
        return false;
    }

    private boolean hideToolTipWindow() {
        if (this.descToolTip != null) {
            this.descToolTip.setVisible(false, false);
            this.descToolTip = null;
            return true;
        }
        return false;
    }

    private static final boolean initDebug() {
        boolean debug = false;
        try {
            debug = Boolean.getBoolean("AutoCompletion.debug");
        }
        catch (SecurityException se) {
            debug = false;
        }
        return debug;
    }

    protected void insertCompletion(Completion c) {
        JTextComponent textComp = this.getTextComponent();
        String alreadyEntered = c.getAlreadyEntered(textComp);
        this.hidePopupWindow();
        Caret caret = textComp.getCaret();
        int dot = caret.getDot();
        int len = alreadyEntered.length();
        int start = dot - len;
        String replacement = this.getReplacementText(c, textComp.getDocument(), start, len);
        caret.setDot(start);
        caret.moveDot(dot);
        textComp.replaceSelection(replacement);
        if (this.isParameterAssistanceEnabled() && c instanceof ParameterizedCompletion) {
            ParameterizedCompletion pc = (ParameterizedCompletion)c;
            this.displayDescriptionToolTip(pc, true);
        }
    }

    public void install(JTextComponent c) {
        if (this.textComponent != null) {
            this.uninstall();
        }
        this.textComponent = c;
        this.installTriggerKey(this.getTriggerKey());
        char start = this.provider.getParameterListStart();
        if (start != '\u0000' && start != ' ') {
            InputMap im = c.getInputMap();
            ActionMap am = c.getActionMap();
            KeyStroke ks = KeyStroke.getKeyStroke(start);
            this.oldParenKey = im.get(ks);
            im.put(ks, PARAM_COMPLETE_KEY);
            this.oldParenAction = am.get(PARAM_COMPLETE_KEY);
            am.put(PARAM_COMPLETE_KEY, new ParameterizedCompletionStartAction(start));
        }
        this.textComponentListener.addTo(this.textComponent);
        this.textComponentListener.hierarchyChanged(null);
        if (this.isAutoActivationEnabled()) {
            this.autoActivationListener.addTo(this.textComponent);
        }
    }

    private void installTriggerKey(KeyStroke ks) {
        InputMap im = this.textComponent.getInputMap();
        this.oldTriggerKey = im.get(ks);
        im.put(ks, PARAM_TRIGGER_KEY);
        ActionMap am = this.textComponent.getActionMap();
        this.oldTriggerAction = am.get(PARAM_TRIGGER_KEY);
        am.put(PARAM_TRIGGER_KEY, new AutoCompleteAction());
    }

    public boolean isAutoActivationEnabled() {
        return this.autoActivationEnabled;
    }

    public boolean isAutoCompleteEnabled() {
        return this.autoCompleteEnabled;
    }

    public boolean isParameterAssistanceEnabled() {
        return this.parameterAssistanceEnabled;
    }

    private boolean isPopupVisible() {
        return this.popupWindow != null && this.popupWindow.isVisible();
    }

    protected int refreshPopupWindow() {
        int textLen;
        String text = this.provider.getAlreadyEnteredText(this.textComponent);
        int n = textLen = text == null ? 0 : text.length();
        if (textLen == 0 && this.isPopupVisible()) {
            this.hidePopupWindow();
            return this.getLineOfCaret();
        }
        final List completions = this.provider.getCompletions(this.textComponent);
        int count = completions.size();
        if (count > 1 || count == 1 && (this.isPopupVisible() || textLen == 0) || count == 1 && !this.getAutoCompleteSingleChoices()) {
            if (this.popupWindow == null) {
                this.popupWindow = new AutoCompletePopupWindow(this.parentWindow, this);
                this.popupWindow.applyComponentOrientation(this.getTextComponentOrientation());
                if (this.renderer != null) {
                    this.popupWindow.setListCellRenderer(this.renderer);
                }
                if (this.preferredChoicesWindowSize != null) {
                    this.popupWindow.setSize(this.preferredChoicesWindowSize);
                }
                if (this.preferredDescWindowSize != null) {
                    this.popupWindow.setDescriptionWindowSize(this.preferredDescWindowSize);
                }
            }
            this.popupWindow.setCompletions(completions);
            if (!this.popupWindow.isVisible()) {
                Rectangle r = null;
                try {
                    r = this.textComponent.modelToView(this.textComponent.getCaretPosition());
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                    return -1;
                }
                Point p = new Point(r.x, r.y);
                SwingUtilities.convertPointToScreen(p, this.textComponent);
                r.x = p.x;
                r.y = p.y;
                this.popupWindow.setLocationRelativeTo(r);
                this.popupWindow.setVisible(true);
            }
        } else if (count == 1) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AutoCompletion.this.insertCompletion((Completion)completions.get(0));
                }
            });
        } else {
            this.hidePopupWindow();
        }
        return this.getLineOfCaret();
    }

    public void setAutoActivationDelay(int ms) {
        ms = Math.max(0, ms);
        this.autoActivationListener.timer.stop();
        this.autoActivationListener.timer.setInitialDelay(ms);
    }

    public void setAutoActivationEnabled(boolean enabled) {
        if (enabled != this.autoActivationEnabled) {
            this.autoActivationEnabled = enabled;
            if (this.textComponent != null) {
                if (this.autoActivationEnabled) {
                    this.autoActivationListener.addTo(this.textComponent);
                } else {
                    this.autoActivationListener.removeFrom(this.textComponent);
                }
            }
        }
    }

    public void setAutoCompleteEnabled(boolean enabled) {
        if (enabled != this.autoCompleteEnabled) {
            this.autoCompleteEnabled = enabled;
            this.hidePopupWindow();
        }
    }

    public void setAutoCompleteSingleChoices(boolean autoComplete) {
        this.autoCompleteSingleChoices = autoComplete;
    }

    public void setCompletionProvider(CompletionProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider cannot be null");
        }
        this.provider = provider;
        this.hidePopupWindow();
    }

    public void setChoicesWindowSize(int w, int h) {
        this.preferredChoicesWindowSize = new Dimension(w, h);
        if (this.popupWindow != null) {
            this.popupWindow.setSize(this.preferredChoicesWindowSize);
        }
    }

    public void setDescriptionWindowSize(int w, int h) {
        this.preferredDescWindowSize = new Dimension(w, h);
        if (this.popupWindow != null) {
            this.popupWindow.setDescriptionWindowSize(this.preferredDescWindowSize);
        }
    }

    public void setExternalURLHandler(ExternalURLHandler handler) {
        this.externalURLHandler = handler;
    }

    public void setListCellRenderer(ListCellRenderer renderer) {
        this.renderer = renderer;
        if (this.popupWindow != null) {
            this.popupWindow.setListCellRenderer(renderer);
            this.hidePopupWindow();
        }
    }

    public void setParameterAssistanceEnabled(boolean enabled) {
        this.parameterAssistanceEnabled = enabled;
    }

    public void setShowDescWindow(boolean show) {
        this.hidePopupWindow();
        this.showDescWindow = show;
    }

    public void setTriggerKey(KeyStroke ks) {
        if (ks == null) {
            throw new IllegalArgumentException("trigger key cannot be null");
        }
        if (!ks.equals(this.trigger)) {
            if (this.textComponent != null) {
                this.uninstallTriggerKey();
                this.installTriggerKey(ks);
            }
            this.trigger = ks;
        }
    }

    public void uninstall() {
        if (this.textComponent != null) {
            this.hidePopupWindow();
            this.uninstallTriggerKey();
            char start = this.provider.getParameterListStart();
            if (start != '\u0000') {
                KeyStroke ks = KeyStroke.getKeyStroke(start);
                InputMap im = this.textComponent.getInputMap();
                im.put(ks, this.oldParenKey);
                ActionMap am = this.textComponent.getActionMap();
                am.put(PARAM_COMPLETE_KEY, this.oldParenAction);
            }
            this.textComponentListener.removeFrom(this.textComponent);
            if (this.parentWindow != null) {
                this.parentWindowListener.removeFrom(this.parentWindow);
            }
            if (this.isAutoActivationEnabled()) {
                this.autoActivationListener.removeFrom(this.textComponent);
            }
            this.textComponent = null;
            this.popupWindow = null;
        }
    }

    private void uninstallTriggerKey() {
        InputMap im = this.textComponent.getInputMap();
        im.put(this.trigger, this.oldTriggerKey);
        ActionMap am = this.textComponent.getActionMap();
        am.put(PARAM_TRIGGER_KEY, this.oldTriggerAction);
    }

    private void updateUI() {
        if (this.popupWindow != null) {
            this.popupWindow.updateUI();
        }
        if (this.descToolTip != null) {
            this.descToolTip.updateUI();
        }
    }

    private class TextComponentListener
    extends FocusAdapter
    implements HierarchyListener {
        private TextComponentListener() {
        }

        void addTo(JTextComponent tc) {
            tc.addFocusListener(this);
            tc.addHierarchyListener(this);
        }

        public void focusLost(FocusEvent e) {
            AutoCompletion.this.hideChildWindows();
        }

        public void hierarchyChanged(HierarchyEvent e) {
            Window oldParentWindow = AutoCompletion.this.parentWindow;
            AutoCompletion.this.parentWindow = SwingUtilities.getWindowAncestor(AutoCompletion.this.textComponent);
            if (AutoCompletion.this.parentWindow != oldParentWindow) {
                if (oldParentWindow != null) {
                    AutoCompletion.this.parentWindowListener.removeFrom(oldParentWindow);
                }
                if (AutoCompletion.this.parentWindow != null) {
                    AutoCompletion.this.parentWindowListener.addTo(AutoCompletion.this.parentWindow);
                }
            }
        }

        public void removeFrom(JTextComponent tc) {
            tc.removeFocusListener(this);
            tc.removeHierarchyListener(this);
        }
    }

    private class ParentWindowListener
    extends ComponentAdapter
    implements WindowFocusListener {
        private ParentWindowListener() {
        }

        public void addTo(Window w) {
            w.addComponentListener(this);
            w.addWindowFocusListener(this);
        }

        public void componentHidden(ComponentEvent e) {
            AutoCompletion.this.hideChildWindows();
        }

        public void componentMoved(ComponentEvent e) {
            AutoCompletion.this.hideChildWindows();
        }

        public void componentResized(ComponentEvent e) {
            AutoCompletion.this.hideChildWindows();
        }

        public void removeFrom(Window w) {
            w.removeComponentListener(this);
            w.removeWindowFocusListener(this);
        }

        public void windowGainedFocus(WindowEvent e) {
        }

        public void windowLostFocus(WindowEvent e) {
            AutoCompletion.this.hideChildWindows();
        }
    }

    private class ParameterizedCompletionStartAction
    extends AbstractAction {
        private String start;

        public ParameterizedCompletionStartAction(char ch) {
            this.start = Character.toString(ch);
        }

        public void actionPerformed(ActionEvent e) {
            boolean wasVisible = AutoCompletion.this.hidePopupWindow();
            if (!wasVisible || !AutoCompletion.this.isParameterAssistanceEnabled()) {
                AutoCompletion.this.textComponent.replaceSelection(this.start);
                return;
            }
            Completion c = AutoCompletion.this.popupWindow.getSelection();
            if (c instanceof ParameterizedCompletion) {
                AutoCompletion.this.insertCompletion(c);
            }
        }
    }

    class AutoCompleteAction
    extends AbstractAction {
        AutoCompleteAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (AutoCompletion.this.isAutoCompleteEnabled()) {
                AutoCompletion.this.refreshPopupWindow();
            } else if (AutoCompletion.this.oldTriggerAction != null) {
                AutoCompletion.this.oldTriggerAction.actionPerformed(e);
            }
        }
    }

    private class AutoActivationListener
    extends FocusAdapter
    implements DocumentListener,
    CaretListener,
    ActionListener {
        private Timer timer = new Timer(200, this);
        private boolean justInserted;

        public AutoActivationListener() {
            this.timer.setRepeats(false);
        }

        public void actionPerformed(ActionEvent e) {
            AutoCompletion.this.doCompletion();
        }

        public void addTo(JTextComponent tc) {
            tc.addFocusListener(this);
            tc.getDocument().addDocumentListener(this);
            tc.addCaretListener(this);
        }

        public void caretUpdate(CaretEvent e) {
            if (this.justInserted) {
                this.justInserted = false;
            } else {
                this.timer.stop();
            }
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void focusLost(FocusEvent e) {
            this.timer.stop();
        }

        public void insertUpdate(DocumentEvent e) {
            this.justInserted = false;
            if (AutoCompletion.this.isAutoCompleteEnabled() && AutoCompletion.this.isAutoActivationEnabled() && e.getLength() == 1) {
                if (AutoCompletion.this.provider.isAutoActivateOkay(AutoCompletion.this.textComponent)) {
                    this.timer.restart();
                    this.justInserted = true;
                } else {
                    this.timer.stop();
                }
            } else {
                this.timer.stop();
            }
        }

        public void removeFrom(JTextComponent tc) {
            tc.removeFocusListener(this);
            tc.getDocument().removeDocumentListener(this);
            tc.removeCaretListener(this);
            this.timer.stop();
            this.justInserted = false;
        }

        public void removeUpdate(DocumentEvent e) {
            this.timer.stop();
        }
    }
}

