/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.admin.model;

import com.docusign.admin.model.AssetGroupAccountCloneSourceAccount;
import com.docusign.admin.model.AssetGroupAccountCloneTargetAccount;
import com.docusign.admin.model.SubAccountErrorDetails;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;

public class AssetGroupAccountClone
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="sourceAccount")
    private AssetGroupAccountCloneSourceAccount sourceAccount = null;
    @JsonProperty(value="targetAccount")
    private AssetGroupAccountCloneTargetAccount targetAccount = null;
    @JsonProperty(value="assetGroupWorkId")
    private UUID assetGroupWorkId = null;
    @JsonProperty(value="assetGroupId")
    private UUID assetGroupId = null;
    @JsonProperty(value="assetGroupWorkType")
    private AssetGroupWorkTypeEnum assetGroupWorkType = null;
    @JsonProperty(value="status")
    private StatusEnum status = null;
    @JsonProperty(value="cloneRequestId")
    private UUID cloneRequestId = null;
    @JsonProperty(value="orderId")
    private UUID orderId = null;
    @JsonProperty(value="attempts")
    private Integer attempts = null;
    @JsonProperty(value="createdDate")
    private String createdDate = null;
    @JsonProperty(value="createdByName")
    private String createdByName = null;
    @JsonProperty(value="createdByEmail")
    private String createdByEmail = null;
    @JsonProperty(value="message")
    private String message = null;
    @JsonProperty(value="cloneProcessingFailureDetails")
    private SubAccountErrorDetails cloneProcessingFailureDetails = null;

    public AssetGroupAccountClone sourceAccount(AssetGroupAccountCloneSourceAccount sourceAccount) {
        this.sourceAccount = sourceAccount;
        return this;
    }

    @Schema(required=true, description="The source account to be cloned from.")
    public AssetGroupAccountCloneSourceAccount getSourceAccount() {
        return this.sourceAccount;
    }

    public void setSourceAccount(AssetGroupAccountCloneSourceAccount sourceAccount) {
        this.sourceAccount = sourceAccount;
    }

    public AssetGroupAccountClone targetAccount(AssetGroupAccountCloneTargetAccount targetAccount) {
        this.targetAccount = targetAccount;
        return this;
    }

    @Schema(required=true, description="The target account to clone to.")
    public AssetGroupAccountCloneTargetAccount getTargetAccount() {
        return this.targetAccount;
    }

    public void setTargetAccount(AssetGroupAccountCloneTargetAccount targetAccount) {
        this.targetAccount = targetAccount;
    }

    @Schema(example="00000000-0000-0000-0000-000000000000", description="The account clone work id.")
    public UUID getAssetGroupWorkId() {
        return this.assetGroupWorkId;
    }

    @Schema(example="00000000-0000-0000-0000-000000000000", description="The asset group id the accounts belong to.")
    public UUID getAssetGroupId() {
        return this.assetGroupId;
    }

    @Schema(description="The type of asset group work.")
    public AssetGroupWorkTypeEnum getAssetGroupWorkType() {
        return this.assetGroupWorkType;
    }

    @Schema(description="The clone status.")
    public StatusEnum getStatus() {
        return this.status;
    }

    @Schema(example="00000000-0000-0000-0000-000000000000", description="The account entitlement/setting mirror request id created by the clone work.")
    public UUID getCloneRequestId() {
        return this.cloneRequestId;
    }

    @Schema(example="00000000-0000-0000-0000-000000000000", description="The order id created by the clone work.")
    public UUID getOrderId() {
        return this.orderId;
    }

    @Schema(description="The number of times the work has been worked on.")
    public Integer getAttempts() {
        return this.attempts;
    }

    @Schema(description="The date the account clone work is created.")
    public String getCreatedDate() {
        return this.createdDate;
    }

    @Schema(description="The name of the creator of the account clone work.")
    public String getCreatedByName() {
        return this.createdByName;
    }

    @Schema(description="The email of the creator of the account clone work.")
    public String getCreatedByEmail() {
        return this.createdByEmail;
    }

    @Schema(description="The message associated with the account clone work.")
    public String getMessage() {
        return this.message;
    }

    @Schema(description="The processing failures if the work is in PendingError/ProcessingError status.")
    public SubAccountErrorDetails getCloneProcessingFailureDetails() {
        return this.cloneProcessingFailureDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssetGroupAccountClone assetGroupAccountClone = (AssetGroupAccountClone)o;
        return Objects.equals(this.sourceAccount, assetGroupAccountClone.sourceAccount) && Objects.equals(this.targetAccount, assetGroupAccountClone.targetAccount) && Objects.equals(this.assetGroupWorkId, assetGroupAccountClone.assetGroupWorkId) && Objects.equals(this.assetGroupId, assetGroupAccountClone.assetGroupId) && Objects.equals((Object)this.assetGroupWorkType, (Object)assetGroupAccountClone.assetGroupWorkType) && Objects.equals((Object)this.status, (Object)assetGroupAccountClone.status) && Objects.equals(this.cloneRequestId, assetGroupAccountClone.cloneRequestId) && Objects.equals(this.orderId, assetGroupAccountClone.orderId) && Objects.equals(this.attempts, assetGroupAccountClone.attempts) && Objects.equals(this.createdDate, assetGroupAccountClone.createdDate) && Objects.equals(this.createdByName, assetGroupAccountClone.createdByName) && Objects.equals(this.createdByEmail, assetGroupAccountClone.createdByEmail) && Objects.equals(this.message, assetGroupAccountClone.message) && Objects.equals(this.cloneProcessingFailureDetails, assetGroupAccountClone.cloneProcessingFailureDetails);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sourceAccount, this.targetAccount, this.assetGroupWorkId, this.assetGroupId, this.assetGroupWorkType, this.status, this.cloneRequestId, this.orderId, this.attempts, this.createdDate, this.createdByName, this.createdByEmail, this.message, this.cloneProcessingFailureDetails});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssetGroupAccountClone {\n");
        sb.append("    sourceAccount: ").append(this.toIndentedString(this.sourceAccount)).append("\n");
        sb.append("    targetAccount: ").append(this.toIndentedString(this.targetAccount)).append("\n");
        sb.append("    assetGroupWorkId: ").append(this.toIndentedString(this.assetGroupWorkId)).append("\n");
        sb.append("    assetGroupId: ").append(this.toIndentedString(this.assetGroupId)).append("\n");
        sb.append("    assetGroupWorkType: ").append(this.toIndentedString((Object)this.assetGroupWorkType)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    cloneRequestId: ").append(this.toIndentedString(this.cloneRequestId)).append("\n");
        sb.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        sb.append("    attempts: ").append(this.toIndentedString(this.attempts)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    createdByName: ").append(this.toIndentedString(this.createdByName)).append("\n");
        sb.append("    createdByEmail: ").append(this.toIndentedString(this.createdByEmail)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    cloneProcessingFailureDetails: ").append(this.toIndentedString(this.cloneProcessingFailureDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        UNDEFINED("Undefined"),
        PENDING("Pending"),
        PROCESSING("Processing"),
        PROCESSINGONHOLD("ProcessingOnHold"),
        PENDINGERROR("PendingError"),
        PROCESSINGERROR("ProcessingError"),
        COMPLETED("Completed"),
        CANCELED("Canceled"),
        PERMANENTFAILURE("PermanentFailure");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum AssetGroupWorkTypeEnum {
        UNDEFINED("Undefined"),
        GROUPASSETFULFILLMENT("GroupAssetFulfillment"),
        ACCOUNTASSETFULFILLMENT("AccountAssetFulfillment"),
        ACCOUNTASSETCLONE("AccountAssetClone"),
        ACCOUNTASSETCREATE("AccountAssetCreate"),
        SUBSCRIPTIONSYNC("SubscriptionSync");

        private String value;

        private AssetGroupWorkTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AssetGroupWorkTypeEnum fromValue(String value) {
            for (AssetGroupWorkTypeEnum b : AssetGroupWorkTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }
}

