/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.foldermetadata;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.foldermetadata.CreateFolderMetadataByIdHeaders;
import com.box.sdkgen.managers.foldermetadata.CreateFolderMetadataByIdScope;
import com.box.sdkgen.managers.foldermetadata.DeleteFolderMetadataByIdHeaders;
import com.box.sdkgen.managers.foldermetadata.DeleteFolderMetadataByIdScope;
import com.box.sdkgen.managers.foldermetadata.GetFolderMetadataByIdHeaders;
import com.box.sdkgen.managers.foldermetadata.GetFolderMetadataByIdScope;
import com.box.sdkgen.managers.foldermetadata.GetFolderMetadataHeaders;
import com.box.sdkgen.managers.foldermetadata.UpdateFolderMetadataByIdHeaders;
import com.box.sdkgen.managers.foldermetadata.UpdateFolderMetadataByIdRequestBody;
import com.box.sdkgen.managers.foldermetadata.UpdateFolderMetadataByIdScope;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.metadatafull.MetadataFull;
import com.box.sdkgen.schemas.metadatas.Metadatas;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.List;
import java.util.Map;

public class FolderMetadataManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public FolderMetadataManager() {
        this.networkSession = new NetworkSession();
    }

    protected FolderMetadataManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public Metadatas getFolderMetadata(String folderId) {
        return this.getFolderMetadata(folderId, new GetFolderMetadataHeaders());
    }

    public Metadatas getFolderMetadata(String folderId, GetFolderMetadataHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/folders/", UtilsManager.convertToString(folderId), "/metadata"), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), Metadatas.class);
    }

    public MetadataFull getFolderMetadataById(String folderId, GetFolderMetadataByIdScope scope, String templateKey) {
        return this.getFolderMetadataById(folderId, scope, templateKey, new GetFolderMetadataByIdHeaders());
    }

    public MetadataFull getFolderMetadataById(String folderId, GetFolderMetadataByIdScope scope, String templateKey, GetFolderMetadataByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/folders/", UtilsManager.convertToString(folderId), "/metadata/", UtilsManager.convertToString(scope), "/", UtilsManager.convertToString(templateKey)), "GET").headers(headersMap).responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), MetadataFull.class);
    }

    public MetadataFull createFolderMetadataById(String folderId, CreateFolderMetadataByIdScope scope, String templateKey, Map<String, Object> requestBody) {
        return this.createFolderMetadataById(folderId, scope, templateKey, requestBody, new CreateFolderMetadataByIdHeaders());
    }

    public MetadataFull createFolderMetadataById(String folderId, CreateFolderMetadataByIdScope scope, String templateKey, Map<String, Object> requestBody, CreateFolderMetadataByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/folders/", UtilsManager.convertToString(folderId), "/metadata/", UtilsManager.convertToString(scope), "/", UtilsManager.convertToString(templateKey)), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), MetadataFull.class);
    }

    public MetadataFull updateFolderMetadataById(String folderId, UpdateFolderMetadataByIdScope scope, String templateKey, List<UpdateFolderMetadataByIdRequestBody> requestBody) {
        return this.updateFolderMetadataById(folderId, scope, templateKey, requestBody, new UpdateFolderMetadataByIdHeaders());
    }

    public MetadataFull updateFolderMetadataById(String folderId, UpdateFolderMetadataByIdScope scope, String templateKey, List<UpdateFolderMetadataByIdRequestBody> requestBody, UpdateFolderMetadataByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/folders/", UtilsManager.convertToString(folderId), "/metadata/", UtilsManager.convertToString(scope), "/", UtilsManager.convertToString(templateKey)), "PUT").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/json-patch+json").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), MetadataFull.class);
    }

    public void deleteFolderMetadataById(String folderId, DeleteFolderMetadataByIdScope scope, String templateKey) {
        this.deleteFolderMetadataById(folderId, scope, templateKey, new DeleteFolderMetadataByIdHeaders());
    }

    public void deleteFolderMetadataById(String folderId, DeleteFolderMetadataByIdScope scope, String templateKey, DeleteFolderMetadataByIdHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/2.0/folders/", UtilsManager.convertToString(folderId), "/metadata/", UtilsManager.convertToString(scope), "/", UtilsManager.convertToString(templateKey)), "DELETE").headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public FolderMetadataManager build() {
            return new FolderMetadataManager(this);
        }
    }
}

