/*
 * Decompiled with CFR 0.152.
 */
package com.bekk.boss.pluto.embedded.util;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.pluto.driver.PortalDriverFilter;

public class PlutoPortalDriverFilter
implements Filter {
    private PortalDriverFilter portalDriver;
    private FilterConfig filterConfig;
    private String[] portletIds;
    private String[] styles = new String[0];

    public PlutoPortalDriverFilter() {
        this.portalDriver = new PortalDriverFilter();
    }

    public void destroy() {
        this.portalDriver.destroy();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        request.setAttribute("org_apache_pluto_embedded_portletIds", (Object)this.portletIds);
        request.setAttribute("org_apache_pluto_embedded_extraStyles", (Object)this.styles);
        this.portalDriver.doFilter(request, response, chain);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.portalDriver.init(filterConfig);
        this.filterConfig = filterConfig;
        String ids = System.getProperty("org.apache.pluto.embedded.portletIds");
        String extraStyles = System.getProperty("org.apache.pluto.embedded.extraStyles");
        if (extraStyles != null) {
            this.styles = extraStyles.split(",");
        }
        if (ids == null || "".equals(ids.trim())) {
            throw new ServletException("No portlet id specified. Please set the system property \"org.apache.pluto.embedded.portletIds\"");
        }
        this.portletIds = this.encodePortletIds(ids.split(","));
    }

    private String[] encodePortletIds(String[] rawIds) {
        String[] ids = new String[rawIds.length];
        String contextPath = this.filterConfig.getServletContext().getContextPath();
        StringBuffer tempId = new StringBuffer();
        if (!contextPath.startsWith("/")) {
            tempId.append("/");
        }
        for (int i = 0; i < rawIds.length; ++i) {
            ids[i] = contextPath + "." + rawIds[i] + "!";
        }
        return ids;
    }
}

