/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util.wanderer;

import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.wanderer.Wanderer;
import com.bbn.openmap.util.wanderer.WandererCallback;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;

public class SLOC
implements WandererCallback {
    int sloc = 0;
    boolean DETAIL = false;

    public void setSLOC(int num) {
        this.sloc = num;
        this.DETAIL = Debug.debugging("sloc");
    }

    public int getSLOC() {
        return this.sloc;
    }

    public boolean handleDirectory(File directory) {
        return true;
    }

    public boolean handleFile(File file) {
        if (!file.getName().endsWith(".java")) {
            return true;
        }
        if (this.DETAIL) {
            Debug.output("Counting code in " + file.getName());
        }
        int count = 0;
        try {
            BinaryBufferedFile bbf = new BinaryBufferedFile(file);
            try {
                while (true) {
                    char c;
                    if ((c = bbf.readChar()) != ';' && c != '}') {
                        continue;
                    }
                    ++count;
                }
            }
            catch (EOFException eofe) {
            }
            catch (FormatException fe) {
                // empty catch block
            }
            bbf.close();
            if (this.DETAIL) {
                Debug.output(file.getName() + " has " + count + " LOC");
            }
            this.sloc += count;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public static void main(String[] argv) {
        Debug.init();
        ArgParser ap = new ArgParser("SLOC");
        if (argv.length == 0) {
            ap.bail("Counts ';' and '}' to sum up Source Lines Of Code\nUsage: java com.bbn.openmap.util.wanderer.SLOC <dir>", false);
        }
        ap.parse(argv);
        String[] dirs = argv;
        SLOC sloc = new SLOC();
        Wanderer wanderer = new Wanderer(sloc);
        int runningTotal = 0;
        for (int i = 0; i < dirs.length; ++i) {
            sloc.setSLOC(0);
            wanderer.handleEntry(new File(dirs[i]));
            Debug.output("Source Lines of Code in " + dirs[i] + " = " + sloc.getSLOC());
            runningTotal += sloc.getSLOC();
        }
        if (dirs.length > 1) {
            Debug.output("Total Source Lines of Code in all directories = " + runningTotal);
        }
    }
}

