/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util.coordFormatter;

import com.bbn.openmap.util.coordFormatter.BasicCoordInfoFormatter;
import java.awt.geom.Point2D;
import java.text.NumberFormat;

public class DMSCoordInfoFormatter
extends BasicCoordInfoFormatter {
    public String createCoordinateInformationLine(int x, int y, Point2D llp, Object source) {
        if (llp != null) {
            return "Cursor Position (" + DMSCoordInfoFormatter.formatLatitude(llp.getY()) + ", " + DMSCoordInfoFormatter.formatLongitude(llp.getX()) + ")";
        }
        return "Lat, Lon (?, ?)";
    }

    public static String formatLatitude(double latitude) {
        return DMSCoordInfoFormatter.formatDegreesMinutes(latitude, 2, latitude < 0.0 ? "S" : "N");
    }

    public static String formatLongitude(double longitude) {
        return DMSCoordInfoFormatter.formatDegreesMinutes(longitude, 3, longitude < 0.0 ? "W" : "E");
    }

    public static String formatDegreesMinutes(double value, int integerDigits, String semisphere) {
        double valueAbs = Math.abs(value);
        int degrees = (int)valueAbs;
        double minutes = (valueAbs - (double)degrees) * 60.0;
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMinimumIntegerDigits(integerDigits);
        nf.setMaximumIntegerDigits(integerDigits);
        String strDegrees = nf.format(degrees);
        nf.setMinimumIntegerDigits(2);
        nf.setMaximumIntegerDigits(2);
        nf.setMinimumFractionDigits(3);
        nf.setMaximumFractionDigits(3);
        String strMinutes = nf.format(minutes);
        return strDegrees + "\u00b0" + strMinutes + "'" + semisphere;
    }
}

