/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.symbology.milStd2525;

import com.bbn.openmap.event.ListenerSupport;
import com.bbn.openmap.gui.DimensionQueryPanel;
import com.bbn.openmap.image.AcmeGifFormatter;
import com.bbn.openmap.image.BufferedImageHelper;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.tools.symbology.milStd2525.CodeOptions;
import com.bbn.openmap.tools.symbology.milStd2525.CodePosition;
import com.bbn.openmap.tools.symbology.milStd2525.CodeScheme;
import com.bbn.openmap.tools.symbology.milStd2525.SymbolChooserDialog;
import com.bbn.openmap.tools.symbology.milStd2525.SymbolPart;
import com.bbn.openmap.tools.symbology.milStd2525.SymbolReferenceLibrary;
import com.bbn.openmap.tools.symbology.milStd2525.SymbolTracker;
import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.FileUtils;
import com.bbn.openmap.util.PaletteHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SymbolChooser
extends JPanel
implements ActionListener {
    public static final String CREATE_IMAGE_CMD = "CREATE_IMAGE_CMD";
    public static final String NAMEFIELD_CMD = "NAMEFIELD_CMD";
    public static final String EMPTY_FEATURE_LIST = null;
    public static final int DEFAULT_ICON_DIMENSION = 100;
    public static final String EMPTY_CODE = "---------------";
    protected static ImageIcon DEFAULT_SYMBOL_IMAGE;
    protected DrawingAttributes drawingAttributes = new DrawingAttributes();
    protected ImageIcon symbolImage;
    protected DefaultMutableTreeNode currentSymbol = null;
    protected SymbolTreeHolder currentSymbolTreeHolder;
    protected SymbolReferenceLibrary library;
    protected List trees;
    protected DimensionQueryPanel dqp;
    protected JButton clearFeaturesButton;
    protected JButton createImageFileButton;
    protected JTextField nameField;
    protected JLabel symbolImageLabel;
    protected JScrollPane treeView;
    protected JPanel optionPanel;
    protected Dimension iconDimension;
    protected boolean allowCreateImage = true;

    public SymbolChooser(SymbolReferenceLibrary srl) {
        this.library = srl;
        try {
            this.trees = this.createNodes(srl);
        }
        catch (FormatException fe) {
            Debug.output("SymbolChooser(): Caught FormatException reading data: " + fe.getMessage());
        }
        this.init(srl, this.trees);
    }

    public void setSelectedTreeHolder(SymbolTreeHolder sth) {
        this.treeView.setViewportView(sth.getTree());
        this.optionPanel.removeAll();
        this.optionPanel.add(sth.getOptionPanel());
        sth.handleNodeSelection((DefaultMutableTreeNode)sth.tree.getLastSelectedPathComponent());
        this.revalidate();
    }

    public static ImageIcon getNotFoundImageIcon() {
        if (DEFAULT_SYMBOL_IMAGE == null) {
            BufferedImage bi = new BufferedImage(100, 100, 1);
            Graphics g = bi.getGraphics();
            g.setColor(Color.LIGHT_GRAY);
            g.fillRect(0, 0, 100, 100);
            DEFAULT_SYMBOL_IMAGE = new ImageIcon(bi);
        }
        return DEFAULT_SYMBOL_IMAGE;
    }

    protected void init(SymbolReferenceLibrary srl, List trees) {
        GridBagLayout outergridbag = new GridBagLayout();
        GridBagConstraints outerc = new GridBagConstraints();
        JPanel setChoicePanel = new JPanel();
        JLabel setChoiceLabel = new JLabel("Symbol Set:");
        JComboBox<Object> setChoices = new JComboBox<Object>(trees.toArray());
        setChoices.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox jcb = (JComboBox)e.getSource();
                SymbolChooser.this.setSelectedTreeHolder((SymbolTreeHolder)jcb.getSelectedItem());
            }
        });
        this.currentSymbolTreeHolder = (SymbolTreeHolder)setChoices.getSelectedItem();
        setChoicePanel.add(setChoiceLabel);
        setChoicePanel.add(setChoices);
        this.treeView = new JScrollPane(this.currentSymbolTreeHolder.getTree());
        this.setLayout(outergridbag);
        outerc.fill = 1;
        outerc.gridwidth = 0;
        outerc.weighty = 0.0;
        outerc.insets = new Insets(5, 10, 5, 10);
        outergridbag.setConstraints(setChoicePanel, outerc);
        this.add(setChoicePanel);
        outerc.weightx = 1.0;
        outerc.weighty = 1.0;
        outerc.gridwidth = -1;
        outergridbag.setConstraints(this.treeView, outerc);
        this.add(this.treeView);
        JPanel symbolPanel = PaletteHelper.createVerticalPanel(" Current Symbol ");
        this.setImageIcon(SymbolChooser.getNotFoundImageIcon());
        symbolPanel.add(this.symbolImageLabel);
        outerc.weightx = 0.0;
        outerc.gridwidth = 0;
        outergridbag.setConstraints(symbolPanel, outerc);
        this.dqp = new DimensionQueryPanel(this.getDesiredIconDimension());
        outergridbag.setConstraints(this.dqp, outerc);
        symbolPanel.add(this.dqp);
        this.add(symbolPanel);
        this.optionPanel = PaletteHelper.createVerticalPanel(" Symbol Attributes ");
        this.optionPanel.add(((SymbolTreeHolder)setChoices.getSelectedItem()).getOptionPanel());
        outergridbag.setConstraints(this.optionPanel, outerc);
        this.add(this.optionPanel);
        GridBagLayout gridbag2 = new GridBagLayout();
        GridBagConstraints c2 = new GridBagConstraints();
        JPanel namePanel = new JPanel();
        namePanel.setLayout(gridbag2);
        c2.weightx = 0.0;
        c2.anchor = 17;
        JLabel nameLabel = new JLabel("Symbol Code: ");
        gridbag2.setConstraints(nameLabel, c2);
        namePanel.add(nameLabel);
        c2.fill = 2;
        c2.weightx = 1.0;
        if (this.nameField == null) {
            this.nameField = new JTextField(EMPTY_CODE);
        }
        this.nameField.addActionListener(this);
        this.nameField.setActionCommand(NAMEFIELD_CMD);
        gridbag2.setConstraints(this.nameField, c2);
        namePanel.add(this.nameField);
        this.createImageFileButton = new JButton("Create Image File");
        this.createImageFileButton.addActionListener(this);
        this.createImageFileButton.setActionCommand(CREATE_IMAGE_CMD);
        this.createImageFileButton.setEnabled(false);
        this.createImageFileButton.setVisible(this.allowCreateImage);
        c2.weightx = 0.0;
        gridbag2.setConstraints(this.createImageFileButton, c2);
        namePanel.add(this.createImageFileButton);
        outerc.weighty = 0.0;
        outerc.gridwidth = 0;
        outergridbag.setConstraints(namePanel, outerc);
        this.add(namePanel);
        this.setSelectedTreeHolder(this.currentSymbolTreeHolder);
    }

    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command == CREATE_IMAGE_CMD && this.library != null && this.nameField != null) {
            try {
                this.setDesiredIconDimension(this.dqp.getDimension());
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "Width and height must be integers.", "Warning", 2);
                return;
            }
            Dimension d = this.getDesiredIconDimension();
            ImageIcon ii = this.library.getIcon(this.getCode(), d);
            if (ii == null) {
                this.createImageFileButton.setEnabled(false);
                return;
            }
            try {
                BufferedImage bi = BufferedImageHelper.getBufferedImage(ii.getImage(), 0, 0, (int)d.getWidth(), (int)d.getHeight(), 2);
                AcmeGifFormatter formatter = new AcmeGifFormatter();
                byte[] imageBytes = formatter.formatImage(bi);
                String newFileName = FileUtils.getFilePathToSaveFromUser("Create File To Save");
                if (newFileName != null) {
                    FileOutputStream fos = new FileOutputStream(newFileName);
                    fos.write(imageBytes);
                    fos.flush();
                    fos.close();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (command == NAMEFIELD_CMD) {
            this.handleManualNameFieldUpdate(this.getCode());
        }
    }

    protected void handleManualNameFieldUpdate(String text) {
        if (text == null) {
            return;
        }
        if (text.length() > 15) {
            text = text.substring(0, 15);
        }
        text = text.toUpperCase().replace('*', '-');
        for (SymbolTreeHolder sth : this.trees) {
            DefaultMutableTreeNode node;
            if (sth == null || (node = sth.getNodeForCode(text)) == null) continue;
            if (Debug.debugging("symbology")) {
                Debug.output("SymbolChooser: Found node for " + text);
            }
            sth.getTree().setSelectionPath(new TreePath(node.getPath()));
            sth.updateOptionsForCode(text);
            this.setSelectedTreeHolder(sth);
        }
    }

    protected List createNodes(SymbolReferenceLibrary srl) throws FormatException {
        LinkedList<SymbolTreeHolder> treeList = new LinkedList<SymbolTreeHolder>();
        List subs = srl.getHead().getSubs();
        int count = 1;
        if (subs != null) {
            for (SymbolPart schemeSymbolPart : subs) {
                CodeOptions options = ((CodeScheme)srl.positionTree.getFromChoices(count++)).getCodeOptions(null);
                treeList.add(new SymbolTreeHolder(schemeSymbolPart, options));
            }
        }
        return treeList;
    }

    public String getCode() {
        if (this.nameField != null) {
            return this.nameField.getText();
        }
        return EMPTY_CODE;
    }

    public void setCode(String code) {
        if (this.nameField == null) {
            this.nameField = new JTextField(code);
        } else {
            this.nameField.setText(code);
        }
    }

    public ImageIcon getImageIcon() {
        return this.symbolImage;
    }

    public void setImageIcon(ImageIcon ii) {
        this.symbolImage = ii;
        if (this.symbolImageLabel == null) {
            this.symbolImageLabel = new JLabel(this.symbolImage);
        } else {
            this.symbolImageLabel.setIcon(this.symbolImage);
        }
    }

    public void setDesiredIconDimension(Dimension d) {
        this.iconDimension = d;
        this.dqp.setDimension(this.getDesiredIconDimension());
    }

    public Dimension getDesiredIconDimension() {
        if (this.iconDimension == null) {
            this.iconDimension = new Dimension(100, 100);
        }
        return this.iconDimension;
    }

    public boolean isAllowCreateImage() {
        return this.allowCreateImage;
    }

    public void setAllowCreateImage(boolean allowCreateImage) {
        this.allowCreateImage = allowCreateImage;
        if (this.createImageFileButton != null) {
            this.createImageFileButton.setVisible(allowCreateImage);
        }
    }

    public static ImageIcon showDialog(Component component, String title, SymbolReferenceLibrary srl, String defaultSymbolCode) throws HeadlessException {
        SymbolChooser pane = new SymbolChooser(srl);
        SymbolTracker ok = new SymbolTracker(pane);
        JDialog dialog = SymbolChooser.createDialog(component, title, true, pane, ok, null);
        dialog.addWindowListener(new SymbolChooserDialog.Closer());
        dialog.addComponentListener(new SymbolChooserDialog.DisposeOnClose());
        pane.setCode(defaultSymbolCode);
        pane.handleManualNameFieldUpdate(defaultSymbolCode);
        dialog.setVisible(true);
        return ok.getImageIcon();
    }

    public static JDialog createDialog(Component c, String title, boolean modal, SymbolChooser chooserPane, ActionListener okListener, ActionListener cancelListener) throws HeadlessException {
        return new SymbolChooserDialog(c, title, modal, chooserPane, okListener, cancelListener);
    }

    public static void main(String[] args) {
        SymbolReferenceLibrary srl;
        Debug.init();
        ArgParser ap = new ArgParser("SymbolChooser");
        ap.add("type", "Type of symbol image set being used (PNG, GIF or SVG, PNG is default)", 1);
        ap.add("path", "Path to root directory of symbol image set if not in classpath", 1);
        ap.add("default", "15 character code for default icon", 1);
        ap.add("verbose", "Print messages");
        if (!ap.parse(args)) {
            ap.printUsage();
            System.exit(0);
        }
        String[] arg = ap.getArgValues("type");
        String symbolImageMakerClass = "com.bbn.openmap.tools.symbology.milStd2525.PNGSymbolImageMaker";
        if (arg != null) {
            if (arg[0].equalsIgnoreCase("SVG")) {
                symbolImageMakerClass = "com.bbn.openmap.tools.symbology.milStd2525.SVGSymbolImageMaker";
            } else if (arg[0].equalsIgnoreCase("GIF")) {
                symbolImageMakerClass = "com.bbn.openmap.tools.symbology.milStd2525.GIFSymbolImageMaker";
            }
        }
        String defaultSymbolCode = "SFPPV-----*****";
        arg = ap.getArgValues("default");
        if (arg != null) {
            defaultSymbolCode = arg[0];
        }
        if ((arg = ap.getArgValues("verbose")) != null) {
            Debug.put("symbology");
        }
        if ((srl = new SymbolReferenceLibrary()).setSymbolImageMaker(symbolImageMakerClass) != null) {
            arg = ap.getArgValues("path");
            if (arg != null) {
                srl.getSymbolImageMaker().setDataPath(arg[0]);
            }
            SymbolChooser.showDialog(null, "MIL-STD-2525B Symbol Chooser", srl, defaultSymbolCode);
        } else {
            Debug.output("Couldn't create SymbolImageMaker");
        }
        System.exit(0);
    }

    public class SymbolTreeHolder
    extends ListenerSupport
    implements TreeSelectionListener {
        protected boolean playWithTreeLineStyle;
        protected String treeLineStyle;
        protected JTree tree;
        protected JPanel optionPanel;
        protected CodeOptions options;
        protected Character[] optionChars;
        protected Hashtable optionMenuHashtable;

        public SymbolTreeHolder(SymbolPart schemeSymbolPart, CodeOptions opts) {
            super(schemeSymbolPart);
            this.playWithTreeLineStyle = false;
            this.treeLineStyle = "Angled";
            this.optionChars = new Character[15];
            DefaultMutableTreeNode top = new DefaultMutableTreeNode(schemeSymbolPart);
            this.addNodes(top, schemeSymbolPart);
            this.tree = new JTree(top);
            this.tree.getSelectionModel().setSelectionMode(1);
            this.tree.setVisibleRowCount(10);
            this.tree.addTreeSelectionListener(this);
            this.tree.setSelectionPath(new TreePath(top));
            if (this.playWithTreeLineStyle) {
                this.tree.putClientProperty("JTree.lineStyle", this.treeLineStyle);
            }
            this.options = opts;
            this.optionPanel = this.getOptionPanel();
        }

        public JTree getTree() {
            return this.tree;
        }

        protected void addNodes(DefaultMutableTreeNode node, SymbolPart sp2) {
            DefaultMutableTreeNode newNode = null;
            List subs = sp2.getSubs();
            if (subs != null) {
                for (SymbolPart sp2 : subs) {
                    newNode = new DefaultMutableTreeNode(sp2);
                    node.add(newNode);
                    this.addNodes(newNode, sp2);
                }
            }
        }

        public DefaultMutableTreeNode getNodeForCode(String code) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.tree.getModel().getRoot();
            SymbolPart sp = (SymbolPart)root.getUserObject();
            if (Debug.debugging("symbology.detail")) {
                Debug.output("Tree root object has " + sp.getClass().getName() + " user object with code |" + sp.getCode() + "| at code position " + sp.getCodePosition().startIndex);
            }
            if (sp.codeMatches(code)) {
                return this.getNodeForCodeStartingAt(root, code);
            }
            return null;
        }

        protected DefaultMutableTreeNode getNodeForCodeStartingAt(DefaultMutableTreeNode node, String code) {
            Enumeration<TreeNode> enumeration = node.children();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode kid = (DefaultMutableTreeNode)enumeration.nextElement();
                SymbolPart ssp = (SymbolPart)kid.getUserObject();
                try {
                    if (code.charAt(ssp.getCodePosition().startIndex) == '-') {
                        return node;
                    }
                    if (!ssp.codeMatches(code)) continue;
                    return this.getNodeForCodeStartingAt(kid, code);
                }
                catch (StringIndexOutOfBoundsException sioobe) {
                }
                catch (NullPointerException npe) {
                }
            }
            return node;
        }

        protected void updateOptionsForCode(String text) {
            block0: for (CodePosition cp : this.options.getOptions()) {
                JComboBox jcb = (JComboBox)this.optionMenuHashtable.get(cp);
                if (jcb == null) continue;
                int numComps = jcb.getItemCount();
                for (int i = 0; i < numComps; ++i) {
                    if (!((CodePosition)jcb.getItemAt(i)).codeMatches(text)) continue;
                    jcb.setSelectedIndex(i);
                    continue block0;
                }
            }
        }

        public void valueChanged(TreeSelectionEvent e) {
            this.handleNodeSelection((DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent());
        }

        public void updateInterfaceToLastSelectedNode() {
            this.handleNodeSelection((DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent());
        }

        public void handleNodeSelection(DefaultMutableTreeNode node) {
            if (node == null) {
                SymbolChooser.this.setCode("");
                return;
            }
            Object nodeInfo = node.getUserObject();
            if (nodeInfo instanceof SymbolPart) {
                SymbolPart symbolPart = (SymbolPart)nodeInfo;
                SymbolChooser.this.currentSymbol = node;
                SymbolChooser.this.setCode(this.updateStringWithCurrentOptionChars(symbolPart.getSymbolCode()));
                ImageIcon ii = SymbolChooser.this.library.getIcon(SymbolChooser.this.getCode(), new Dimension(100, 100));
                if (SymbolChooser.this.createImageFileButton != null) {
                    SymbolChooser.this.createImageFileButton.setEnabled(ii != null);
                }
                if (ii == null) {
                    ii = SymbolChooser.getNotFoundImageIcon();
                }
                SymbolChooser.this.setImageIcon(ii);
            } else {
                SymbolChooser.this.setCode("");
                SymbolChooser.this.setImageIcon(SymbolChooser.getNotFoundImageIcon());
                SymbolChooser.this.createImageFileButton.setEnabled(false);
            }
        }

        public JPanel getOptionPanel() {
            if (this.optionPanel == null) {
                this.optionMenuHashtable = new Hashtable();
                this.optionPanel = new JPanel();
                GridBagLayout gridbag = new GridBagLayout();
                GridBagConstraints c = new GridBagConstraints();
                this.optionPanel.setLayout(gridbag);
                if (this.options != null) {
                    int i = 0;
                    for (CodePosition cp : this.options.getOptions()) {
                        List lt = cp.getPositionChoices();
                        if (lt == null) continue;
                        JLabel label = new JLabel(cp.getPrettyName() + ": ");
                        c.gridx = 0;
                        c.gridy = i++;
                        c.weightx = 0.0;
                        c.fill = 0;
                        c.anchor = 13;
                        gridbag.setConstraints(label, c);
                        this.optionPanel.add(label);
                        JComboBox<Object> jcb = new JComboBox<Object>(lt.toArray());
                        jcb.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent ae) {
                                SymbolTreeHolder.this.setPositionSetting((CodePosition)((JComboBox)ae.getSource()).getSelectedItem());
                                SymbolTreeHolder.this.updateInterfaceToLastSelectedNode();
                            }
                        });
                        c.gridx = 1;
                        c.anchor = 17;
                        c.fill = 2;
                        c.weightx = 1.0;
                        gridbag.setConstraints(jcb, c);
                        this.optionPanel.add(jcb);
                        this.optionMenuHashtable.put(cp, jcb);
                    }
                } else {
                    this.optionPanel.add(new JLabel("No options available for these symbols."));
                }
            }
            return this.optionPanel;
        }

        public void setPositionSetting(CodePosition cp) {
            if (Debug.debugging("codeposition")) {
                Debug.output("Setting " + cp.getPrettyName() + " [" + cp.getID() + "] at " + cp.getStartIndex() + ", " + cp.getEndIndex());
            }
            this.updateOptionChars(cp);
            SymbolChooser.this.setCode(this.updateStringWithCurrentOptionChars(SymbolChooser.this.getCode()));
        }

        public void updateOptionChars(CodePosition cp) {
            String cpString = cp.getID();
            for (int i = 0; i < cpString.length(); ++i) {
                char curChar = cpString.charAt(i);
                this.optionChars[cp.getStartIndex() + i] = new Character(curChar);
            }
        }

        public String updateStringWithCurrentOptionChars(String currentSymbolCode) {
            try {
                StringBuffer buf = new StringBuffer(currentSymbolCode);
                for (int i = 0; i < this.optionChars.length; ++i) {
                    Character c = this.optionChars[i];
                    if (c == null) continue;
                    buf.setCharAt(i, c.charValue());
                }
                currentSymbolCode = buf.toString();
            }
            catch (StringIndexOutOfBoundsException siobe) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return currentSymbolCode;
        }

        public String toString() {
            return ((SymbolPart)this.getSource()).getCodePosition().getPrettyName();
        }
    }
}

