/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.proj.BasicProjectionLoader;
import com.bbn.openmap.proj.DatumShiftProjection;
import com.bbn.openmap.proj.Ellipsoid;
import com.bbn.openmap.proj.GeoProj;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionException;
import com.bbn.openmap.proj.UTMProjection;
import com.bbn.openmap.proj.coords.DatumShiftGCT;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.geom.Point2D;
import java.util.Properties;

public class UTMProjectionLoader
extends BasicProjectionLoader {
    public static final String ZONE_NUMBER = "zoneNumber";
    public static final String ZONE_LETTER = "zoneLetter";
    protected int defaultZoneNumber = 0;
    protected char defaultZoneLetter = (char)78;

    public UTMProjectionLoader() {
        super(UTMProjection.class, "UTM Projection", "UTM Projection");
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.defaultZoneNumber = PropUtils.intFromProperties(props, prefix + ZONE_NUMBER, this.defaultZoneNumber);
        this.defaultZoneLetter = PropUtils.charFromProperties(props, prefix + ZONE_LETTER, this.defaultZoneLetter);
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + ZONE_LETTER, "" + this.defaultZoneLetter);
        props.put(prefix + ZONE_NUMBER, Integer.toString(this.defaultZoneNumber));
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        PropUtils.setI18NPropertyInfo(this.i18n, props, UTMProjectionLoader.class, ZONE_LETTER, "Zone Letter", "The UTM Zone Letter (N or S)", null);
        PropUtils.setI18NPropertyInfo(this.i18n, props, UTMProjectionLoader.class, ZONE_NUMBER, "Zone Number", "The UTM Zone Number", null);
        return props;
    }

    public Projection create(Properties props) throws ProjectionException {
        try {
            LatLonPoint center = this.convertToLLP((Point2D)props.get("CENTER"));
            float scale = PropUtils.floatFromProperties(props, "SCALE", 1.0E7f);
            int height = PropUtils.intFromProperties(props, "HEIGHT", 100);
            int width = PropUtils.intFromProperties(props, "WIDTH", 100);
            int zone_number = PropUtils.intFromProperties(props, ZONE_NUMBER, this.defaultZoneNumber);
            char zone_letter = PropUtils.charFromProperties(props, ZONE_LETTER, this.defaultZoneLetter);
            boolean isnorthern = zone_letter == 'N';
            String ellipsoidString = props.getProperty("DATUM");
            Ellipsoid ellps = Ellipsoid.WGS_84;
            if (ellipsoidString != null) {
                ellps = Ellipsoid.getByName(ellipsoidString);
            }
            GeoProj proj = new UTMProjection(center, scale, width, height, zone_number, isnorthern, ellps);
            if (ellps != null && (ellps != Ellipsoid.WGS_84 || ellps == Ellipsoid.GRS_1980)) {
                proj = new DatumShiftProjection(proj, new DatumShiftGCT(ellps));
            }
            return proj;
        }
        catch (Exception e) {
            if (Debug.debugging("proj")) {
                Debug.output("UTMProjectionLoader: problem creating UTM projection " + e.getMessage());
                e.printStackTrace();
            }
            throw new ProjectionException("UTMProjectionLoader: problem creating UTM projection");
        }
    }
}

