/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.MoreMath;
import com.bbn.openmap.proj.Cylindrical;
import com.bbn.openmap.proj.DrawUtil;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.coords.LatLonPoint;
import com.bbn.openmap.util.Debug;
import java.awt.geom.Point2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mercator
extends Cylindrical {
    public static final transient String MercatorName = "Mercator";
    protected static final int MAX_RHUMB_SEGS = 512;
    protected static double epsilon = 0.01f;
    protected transient double hy;
    protected transient double wx;
    protected transient double tanCtrLat;
    protected transient double asinh_of_tanCtrLat;

    public Mercator(LatLonPoint center, float scale, int width, int height) {
        super(center, scale, width, height);
    }

    @Override
    public String toString() {
        return "Mercator[" + super.toString();
    }

    @Override
    protected void computeParameters() {
        Debug.message("mercator", "Mercator.computeParameters()");
        super.computeParameters();
        this.tanCtrLat = Math.tan(this.centerY);
        this.asinh_of_tanCtrLat = MoreMath.asinh(this.tanCtrLat);
        this.hy = this.height / 2;
        this.wx = this.width / 2;
    }

    @Override
    public double normalizeLatitude(double lat) {
        if (lat > 1.5707963705062866 - epsilon) {
            return 1.5707963705062866 - epsilon;
        }
        if (lat < -1.5707963705062866 + epsilon) {
            return -1.5707963705062866 + epsilon;
        }
        return lat;
    }

    @Override
    public boolean isPlotable(double lat, double lon) {
        return true;
    }

    @Override
    public Point2D forward(double lat, double lon, Point2D p, boolean isRadian) {
        if (!isRadian) {
            lat = ProjMath.degToRad(lat);
            lon = ProjMath.degToRad(lon);
        }
        lat = this.normalizeLatitude(lat);
        lon = Mercator.wrapLongitude(lon);
        double x = this.scaled_radius * Mercator.wrapLongitude(lon - this.centerX) + this.wx;
        double y = this.hy - this.scaled_radius * (MoreMath.asinh(Math.tan(lat)) - this.asinh_of_tanCtrLat);
        p.setLocation(x, y);
        return p;
    }

    @Override
    public <T extends Point2D> T inverse(double x, double y, T llp) {
        if (llp == null) {
            llp = new LatLonPoint.Double();
        }
        y = this.hy - y;
        double wc = this.asinh_of_tanCtrLat * this.scaled_radius;
        ((Point2D)llp).setLocation(Math.toDegrees(Mercator.wrapLongitude((x -= this.wx) / this.scaled_radius + this.centerX)), Math.toDegrees(this.normalizeLatitude(Math.atan(MoreMath.sinh((y + wc) / this.scaled_radius)))));
        return (T)llp;
    }

    protected static final int rhumbStep(Point2D pt1, Point2D pt2) {
        int step = (int)DrawUtil.distance(pt1.getX(), pt1.getY(), pt2.getX(), pt2.getY());
        step = step > 8192 ? 512 : (step >>= 3);
        return step == 0 ? 1 : step;
    }

    protected float[] rhumbProject(Point2D from, Point2D to, boolean include_last, int nsegs) {
        if (nsegs < 1) {
            nsegs = DrawUtil.pixel_distance((int)from.getX(), (int)from.getY(), (int)to.getX(), (int)to.getY()) >> 3;
            if (nsegs == 0) {
                nsegs = 1;
            } else if (nsegs > 512) {
                nsegs = 512;
            }
        }
        LatLonPoint.Double llp = new LatLonPoint.Double();
        int[] xypts = DrawUtil.lineSegments((int)from.getX(), (int)from.getY(), (int)to.getX(), (int)to.getY(), nsegs, include_last, new int[nsegs << 1]);
        float[] llpts = new float[xypts.length];
        for (int i = 0; i < llpts.length; i += 2) {
            this.inverse(xypts[i], xypts[i + 1], llp);
            llpts[i] = (float)((LatLonPoint)llp).getRadLat();
            llpts[i + 1] = (float)((LatLonPoint)llp).getRadLon();
        }
        return llpts;
    }

    protected double[] rhumbProjectDouble(Point2D from, Point2D to, boolean include_last, int nsegs) {
        if (nsegs < 1) {
            nsegs = DrawUtil.pixel_distance((int)from.getX(), (int)from.getY(), (int)to.getX(), (int)to.getY()) >> 3;
            if (nsegs == 0) {
                nsegs = 1;
            } else if (nsegs > 512) {
                nsegs = 512;
            }
        }
        LatLonPoint.Double llp = new LatLonPoint.Double();
        int[] xypts = DrawUtil.lineSegments((int)from.getX(), (int)from.getY(), (int)to.getX(), (int)to.getY(), nsegs, include_last, new int[nsegs << 1]);
        double[] llpts = new double[xypts.length];
        for (int i = 0; i < llpts.length; i += 2) {
            this.inverse(xypts[i], xypts[i + 1], llp);
            llpts[i] = ((LatLonPoint)llp).getRadLat();
            llpts[i + 1] = ((LatLonPoint)llp).getRadLon();
        }
        return llpts;
    }

    @Override
    public String getName() {
        return MercatorName;
    }
}

